/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.google.common.base.Predicate;
import dan200.computercraft.ComputerCraft;
import dan200.computercraft.shared.computer.blocks.BlockComputerBase;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.turtle.blocks.BlockTurtleDyeVariant;
import dan200.computercraft.shared.turtle.blocks.ITurtleTile;
import dan200.computercraft.shared.turtle.blocks.TileTurtle;
import dan200.computercraft.shared.turtle.blocks.TileTurtleAdvanced;
import dan200.computercraft.shared.turtle.blocks.TileTurtleExpanded;
import dan200.computercraft.shared.util.DirectionUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTurtle
extends BlockComputerBase {
    public BlockTurtle() {
        super(Material.field_151573_f);
        this.func_149711_c(2.5f);
        this.func_149663_c("computercraft.turtle");
        this.func_149647_a(ComputerCraft.mainCreativeTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)Properties.FACING, (Comparable)EnumFacing.NORTH).func_177226_a(Properties.DYE, (Comparable)((Object)BlockTurtleDyeVariant.None)));
    }

    public static BlockTurtle createTurtleBlock() {
        return new BlockTurtle();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Properties.FACING, Properties.DYE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)Properties.FACING, (Comparable)this.getDirection(world, pos));
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof ITurtleTile) {
            ITurtleTile turtle = (ITurtleTile)tile;
            state = state.func_177226_a(Properties.DYE, (Comparable)((Object)BlockTurtleDyeVariant.fromColour(turtle.getColour())));
        } else {
            state = state.func_177226_a(Properties.DYE, (Comparable)((Object)BlockTurtleDyeVariant.None));
        }
        return state;
    }

    @Override
    protected IBlockState getDefaultBlockState(ComputerFamily family, EnumFacing placedSide) {
        return this.func_176223_P();
    }

    private ComputerFamily getFamily() {
        if (this == ComputerCraft.Blocks.turtleAdvanced) {
            return ComputerFamily.Advanced;
        }
        return ComputerFamily.Normal;
    }

    @Override
    public ComputerFamily getFamily(int damage) {
        return this.getFamily();
    }

    @Override
    public ComputerFamily getFamily(IBlockState state) {
        return this.getFamily();
    }

    @Override
    protected TileComputerBase createTile(ComputerFamily family) {
        if (this == ComputerCraft.Blocks.turtleAdvanced) {
            return new TileTurtleAdvanced();
        }
        if (this == ComputerCraft.Blocks.turtleExpanded) {
            return new TileTurtleExpanded();
        }
        return new TileTurtle();
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack itemstack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileTurtle) {
            tile.func_145834_a(world);
            tile.func_174878_a(pos);
        }
        EnumFacing dir = DirectionUtil.fromEntityRot(player);
        this.setDirection(world, pos, dir.func_176734_d());
    }

    public static class Properties {
        public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
        public static final PropertyEnum<BlockTurtleDyeVariant> DYE = PropertyEnum.func_177709_a((String)"dye", BlockTurtleDyeVariant.class);
    }
}

