/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.upgrades.TurtleInventoryCrafting;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class TurtleCraftCommand
implements ITurtleCommand {
    private final int m_limit;

    public TurtleCraftCommand(int limit) {
        this.m_limit = limit;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        TurtleInventoryCrafting crafting = new TurtleInventoryCrafting(turtle);
        ArrayList<ItemStack> results = crafting.doCrafting(turtle.getWorld(), this.m_limit);
        if (results != null) {
            for (ItemStack stack : results) {
                ItemStack remainder = InventoryUtil.storeItems(stack, turtle.getInventory(), 0, turtle.getInventory().func_70302_i_(), turtle.getSelectedSlot());
                if (remainder == null) continue;
                BlockPos position = turtle.getPosition();
                WorldUtil.dropItemStack(remainder, turtle.getWorld(), position, turtle.getDirection());
            }
            if (results.size() > 0) {
                turtle.playAnimation(TurtleAnimation.Wait);
            }
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("No matching recipes");
    }
}

