/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.proxy.CCTurtleProxyCommon;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class TurtleEquipCommand
implements ITurtleCommand {
    private final TurtleSide m_side;

    public TurtleEquipCommand(TurtleSide side) {
        this.m_side = side;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        ItemStack craftingItem;
        ITurtleUpgrade oldUpgrade;
        ITurtleUpgrade newUpgrade;
        ItemStack newUpgradeStack;
        IInventory inventory = turtle.getInventory();
        ItemStack selectedStack = inventory.func_70301_a(turtle.getSelectedSlot());
        if (selectedStack != null) {
            newUpgradeStack = selectedStack.func_77946_l();
            newUpgrade = ComputerCraft.getTurtleUpgrade(newUpgradeStack);
            if (newUpgrade == null || !CCTurtleProxyCommon.isUpgradeSuitableForFamily(((TurtleBrain)turtle).getFamily(), newUpgrade)) {
                return TurtleCommandResult.failure("Not a valid upgrade");
            }
        } else {
            newUpgradeStack = null;
            newUpgrade = null;
        }
        ItemStack oldUpgradeStack = (oldUpgrade = turtle.getUpgrade(this.m_side)) != null ? ((craftingItem = oldUpgrade.getCraftingItem()) != null ? craftingItem.func_77946_l() : null) : null;
        if (newUpgradeStack != null) {
            InventoryUtil.takeItems(1, inventory, turtle.getSelectedSlot(), 1, turtle.getSelectedSlot());
            inventory.func_70296_d();
        }
        if (oldUpgradeStack != null) {
            ItemStack remainder = InventoryUtil.storeItems(oldUpgradeStack, inventory, 0, inventory.func_70302_i_(), turtle.getSelectedSlot());
            if (remainder != null) {
                BlockPos position = turtle.getPosition();
                WorldUtil.dropItemStack(remainder, turtle.getWorld(), position, turtle.getDirection());
            }
            inventory.func_70296_d();
        }
        turtle.setUpgrade(this.m_side, newUpgrade);
        if (newUpgrade != null || oldUpgrade != null) {
            turtle.playAnimation(TurtleAnimation.Wait);
        }
        return TurtleCommandResult.success();
    }
}

