/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleCommand;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.turtle.core.MoveDirection;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TurtleMoveCommand
implements ITurtleCommand {
    private final MoveDirection m_direction;

    public TurtleMoveCommand(MoveDirection direction) {
        this.m_direction = direction;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        EnumFacing direction = this.m_direction.toWorldDir(turtle);
        World oldWorld = turtle.getWorld();
        BlockPos oldPosition = turtle.getPosition();
        BlockPos newPosition = WorldUtil.moveCoords(oldPosition, direction);
        TurtlePlayer turtlePlayer = TurtlePlaceCommand.createPlayer(turtle, oldPosition, direction);
        TurtleCommandResult canEnterResult = this.canEnter(turtlePlayer, oldWorld, newPosition);
        if (!canEnterResult.isSuccess()) {
            return canEnterResult;
        }
        Block block = oldWorld.func_180495_p(newPosition).func_177230_c();
        if (!(block == null || oldWorld.func_175623_d(newPosition) || WorldUtil.isLiquidBlock(oldWorld, newPosition) || block.func_176200_f((IBlockAccess)oldWorld, newPosition))) {
            return TurtleCommandResult.failure("Movement obstructed");
        }
        AxisAlignedBB aabb = ((TurtleBrain)turtle).getOwner().getBounds();
        if (!oldWorld.func_72855_b(aabb = aabb.func_72317_d((double)newPosition.func_177958_n(), (double)newPosition.func_177956_o(), (double)newPosition.func_177952_p()))) {
            if (ComputerCraft.Config.turtlesCanPush && this.m_direction != MoveDirection.Up && this.m_direction != MoveDirection.Down) {
                List list = oldWorld.func_72839_b(null, aabb);
                for (int i = 0; i < list.size(); ++i) {
                    AxisAlignedBB pushedBB;
                    Entity entity = (Entity)list.get(i);
                    if (entity.field_70128_L || !entity.field_70156_m) continue;
                    AxisAlignedBB entityBB = entity.func_174813_aQ();
                    if (entityBB == null) {
                        entityBB = entity.func_70046_E();
                    }
                    if (entityBB == null || oldWorld.func_184144_a(entity, pushedBB = entityBB.func_72317_d((double)direction.func_82601_c(), (double)direction.func_96559_d(), (double)direction.func_82599_e())).isEmpty()) continue;
                    return TurtleCommandResult.failure("Movement obstructed");
                }
            } else {
                return TurtleCommandResult.failure("Movement obstructed");
            }
        }
        if (turtle.isFuelNeeded() && turtle.getFuelLevel() < 1) {
            return TurtleCommandResult.failure("Out of fuel");
        }
        if (turtle.teleportTo(oldWorld, newPosition)) {
            turtle.consumeFuel(1);
            switch (this.m_direction) {
                default: {
                    turtle.playAnimation(TurtleAnimation.MoveForward);
                    break;
                }
                case Back: {
                    turtle.playAnimation(TurtleAnimation.MoveBack);
                    break;
                }
                case Up: {
                    turtle.playAnimation(TurtleAnimation.MoveUp);
                    break;
                }
                case Down: {
                    turtle.playAnimation(TurtleAnimation.MoveDown);
                }
            }
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("Movement failed");
    }

    private TurtleCommandResult canEnter(TurtlePlayer turtlePlayer, World world, BlockPos position) {
        if (position.func_177956_o() < 0) {
            return TurtleCommandResult.failure("Too low to move");
        }
        if (position.func_177956_o() > world.func_72800_K() - 1) {
            return TurtleCommandResult.failure("Too high to move");
        }
        if (ComputerCraft.Config.turtlesObeyBlockProtection && !ComputerCraft.isBlockEnterable(world, position, (EntityPlayer)turtlePlayer)) {
            return TurtleCommandResult.failure("Cannot enter protected area");
        }
        if (!world.func_175667_e(position)) {
            return TurtleCommandResult.failure("Cannot leave loaded world");
        }
        return TurtleCommandResult.success();
    }
}

