/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.ItemComputerBase;
import dan200.computercraft.shared.turtle.blocks.ITurtleTile;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.util.Colour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public abstract class ItemTurtleBase
extends ItemComputerBase
implements ITurtleItem {
    protected ItemTurtleBase(Block block) {
        super(block);
        this.func_77625_d(64);
        this.func_77627_a(true);
    }

    public abstract ItemStack create(int var1, String var2, Colour var3, ITurtleUpgrade var4, ITurtleUpgrade var5, int var6, ResourceLocation var7);

    public void func_150895_a(Item itemID, CreativeTabs tabs, List<ItemStack> list) {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>();
        ComputerCraft.addAllUpgradedTurtles(all);
        for (ItemStack stack : all) {
            if (stack.func_77973_b() != this) continue;
            list.add(stack);
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && tile instanceof ITurtleTile) {
                ITurtleTile turtle = (ITurtleTile)tile;
                this.setupTurtleAfterPlacement(stack, turtle);
            }
            return true;
        }
        return false;
    }

    public void setupTurtleAfterPlacement(ItemStack stack, ITurtleTile turtle) {
        ResourceLocation overlay;
        String label;
        int id = this.getComputerID(stack);
        if (id >= 0) {
            turtle.setComputerID(id);
        }
        if ((label = this.getLabel(stack)) != null) {
            turtle.setLabel(label);
        }
        for (TurtleSide side : TurtleSide.values()) {
            turtle.getAccess().setUpgrade(side, this.getUpgrade(stack, side));
        }
        int fuelLevel = this.getFuelLevel(stack);
        turtle.getAccess().setFuelLevel(fuelLevel);
        Colour colour = this.getColour(stack);
        if (colour != null) {
            turtle.getAccess().setDyeColour(colour.ordinal());
        }
        if ((overlay = this.getOverlay(stack)) != null) {
            ((TurtleBrain)turtle.getAccess()).setOverlay(overlay);
        }
    }

    public String func_77667_c(ItemStack stack) {
        ComputerFamily family = this.getFamily(stack);
        switch (family) {
            default: {
                return "tile.computercraft.turtle";
            }
            case Advanced: {
                return "tile.computercraft.advanced_turtle";
            }
            case Beginners: 
        }
        return "tile.computercraftedu.beginner_turtle";
    }

    public String func_77653_i(ItemStack stack) {
        String baseString = this.func_77667_c(stack);
        ITurtleUpgrade left = this.getUpgrade(stack, TurtleSide.Left);
        ITurtleUpgrade right = this.getUpgrade(stack, TurtleSide.Right);
        if (left != null && right != null) {
            return I18n.func_74837_a((String)(baseString + ".upgraded_twice.name"), (Object[])new Object[]{I18n.func_74838_a((String)right.getUnlocalisedAdjective()), I18n.func_74838_a((String)left.getUnlocalisedAdjective())});
        }
        if (left != null) {
            return I18n.func_74837_a((String)(baseString + ".upgraded.name"), (Object[])new Object[]{I18n.func_74838_a((String)left.getUnlocalisedAdjective())});
        }
        if (right != null) {
            return I18n.func_74837_a((String)(baseString + ".upgraded.name"), (Object[])new Object[]{I18n.func_74838_a((String)right.getUnlocalisedAdjective())});
        }
        return I18n.func_74838_a((String)(baseString + ".name"));
    }

    @Override
    public abstract ITurtleUpgrade getUpgrade(ItemStack var1, TurtleSide var2);

    @Override
    public abstract Colour getColour(ItemStack var1);

    @Override
    public abstract ResourceLocation getOverlay(ItemStack var1);

    @Override
    public abstract int getFuelLevel(ItemStack var1);
}

