/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.items;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.turtle.blocks.ITurtleTile;
import dan200.computercraft.shared.turtle.items.ItemTurtleBase;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.ReflectionUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TurtleItemFactory {
    @Nullable
    public static ItemStack create(ITurtleTile turtle) {
        String label;
        ITurtleUpgrade leftUpgrade = turtle.getAccess().getUpgrade(TurtleSide.Left);
        ITurtleUpgrade rightUpgrade = turtle.getAccess().getUpgrade(TurtleSide.Right);
        IComputer computer = turtle.getComputer();
        if (computer != null && (label = computer.getLabel()) != null) {
            if (turtle.getFamily() != ComputerFamily.Beginners) {
                int id = computer.getID();
                int fuelLevel = turtle.getAccess().getFuelLevel();
                return TurtleItemFactory.create(id, label, turtle.getColour(), turtle.getFamily(), leftUpgrade, rightUpgrade, fuelLevel, turtle.getOverlay());
            }
            return TurtleItemFactory.create(-1, label, turtle.getColour(), turtle.getFamily(), leftUpgrade, rightUpgrade, 0, turtle.getOverlay());
        }
        return TurtleItemFactory.create(-1, null, turtle.getColour(), turtle.getFamily(), leftUpgrade, rightUpgrade, 0, turtle.getOverlay());
    }

    @Nullable
    public static ItemStack create(int id, String label, Colour colour, ComputerFamily family, ITurtleUpgrade leftUpgrade, ITurtleUpgrade rightUpgrade, int fuelLevel, ResourceLocation overlay) {
        switch (family) {
            case Normal: {
                ItemTurtleBase legacy = (ItemTurtleBase)Item.func_150898_a((Block)ComputerCraft.Blocks.turtle);
                ItemTurtleBase normal = (ItemTurtleBase)Item.func_150898_a((Block)ComputerCraft.Blocks.turtleExpanded);
                ItemStack legacyStack = legacy.create(id, label, colour, leftUpgrade, rightUpgrade, fuelLevel, overlay);
                return legacyStack != null ? legacyStack : normal.create(id, label, colour, leftUpgrade, rightUpgrade, fuelLevel, overlay);
            }
            case Advanced: {
                ItemTurtleBase advanced = (ItemTurtleBase)Item.func_150898_a((Block)ComputerCraft.Blocks.turtleAdvanced);
                return advanced.create(id, label, colour, leftUpgrade, rightUpgrade, fuelLevel, overlay);
            }
            case Beginners: {
                Block beginnersBlock = ReflectionUtil.safeGet(ReflectionUtil.getOptionalField(ReflectionUtil.getOptionalInnerClass(ReflectionUtil.getOptionalClass("dan200.computercraftedu.ComputerCraftEdu"), "Blocks"), "turtleJunior"), null, Block.class);
                if (beginnersBlock != null) {
                    ItemTurtleBase beginnersItem = (ItemTurtleBase)Item.func_150898_a((Block)beginnersBlock);
                    return beginnersItem.create(id, label, colour, leftUpgrade, rightUpgrade, fuelLevel, overlay);
                }
                return null;
            }
        }
        return null;
    }
}

