/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.items.IComputerItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class TurtleRecipe
implements IRecipe {
    private final Item[] m_recipe;
    private final ComputerFamily m_family;

    public TurtleRecipe(Item[] recipe, ComputerFamily family) {
        this.m_recipe = recipe;
        this.m_family = family;
    }

    public int func_77570_a() {
        return 9;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return TurtleItemFactory.create(-1, null, null, this.m_family, null, null, 0, null);
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting _inventory, @Nonnull World world) {
        return this.func_77572_b(_inventory) != null;
    }

    @Nullable
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventory) {
        int computerID = -1;
        String label = null;
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                ItemStack item = inventory.func_70463_b(x, y);
                if (item != null && item.func_77973_b() == this.m_recipe[x + y * 3]) {
                    if (!(item.func_77973_b() instanceof IComputerItem)) continue;
                    IComputerItem itemComputer = (IComputerItem)item.func_77973_b();
                    if (this.m_family == ComputerFamily.Beginners || itemComputer.getFamily(item) == this.m_family) {
                        computerID = itemComputer.getComputerID(item);
                        label = itemComputer.getLabel(item);
                        continue;
                    }
                    return null;
                }
                return null;
            }
        }
        if (this.m_family != ComputerFamily.Beginners) {
            return TurtleItemFactory.create(computerID, label, null, this.m_family, null, null, 0, null);
        }
        return TurtleItemFactory.create(-1, label, null, this.m_family, null, null, 0, null);
    }

    @Nullable
    public ItemStack[] func_179532_b(@Nonnull InventoryCrafting inventoryCrafting) {
        ItemStack[] results = new ItemStack[inventoryCrafting.func_70302_i_()];
        for (int i = 0; i < results.length; ++i) {
            ItemStack stack = inventoryCrafting.func_70301_a(i);
            results[i] = ForgeHooks.getContainerItem((ItemStack)stack);
        }
        return results;
    }
}

