/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.recipes;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.proxy.CCTurtleProxyCommon;
import dan200.computercraft.shared.turtle.items.ITurtleItem;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.util.Colour;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class TurtleUpgradeRecipe
implements IRecipe {
    public int func_77570_a() {
        return 3;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return TurtleItemFactory.create(-1, null, null, ComputerFamily.Normal, null, null, 0, null);
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inventory, @Nonnull World world) {
        return this.func_77572_b(inventory) != null;
    }

    @Nullable
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventory) {
        ItemStack leftItem = null;
        ItemStack turtle = null;
        ItemStack rightItem = null;
        for (int y = 0; y < inventory.func_174923_h(); ++y) {
            if (turtle == null) {
                boolean finishedRow = false;
                for (int x = 0; x < inventory.func_174922_i(); ++x) {
                    ItemStack item = inventory.func_70463_b(x, y);
                    if (item != null) {
                        if (finishedRow) {
                            return null;
                        }
                        if (item.func_77973_b() instanceof ITurtleItem) {
                            if (turtle == null) {
                                turtle = item;
                                continue;
                            }
                            return null;
                        }
                        if (turtle == null && leftItem == null) {
                            leftItem = item;
                            continue;
                        }
                        if (turtle != null && rightItem == null) {
                            rightItem = item;
                            continue;
                        }
                        return null;
                    }
                    if (leftItem == null && turtle == null) continue;
                    finishedRow = true;
                }
                if (turtle != null || leftItem == null && rightItem == null) continue;
                return null;
            }
            for (int x = 0; x < inventory.func_174922_i(); ++x) {
                ItemStack item = inventory.func_70463_b(x, y);
                if (item == null) continue;
                return null;
            }
        }
        if (turtle == null || leftItem == null && rightItem == null) {
            return null;
        }
        ITurtleItem itemTurtle = (ITurtleItem)turtle.func_77973_b();
        ComputerFamily family = itemTurtle.getFamily(turtle);
        ITurtleUpgrade[] upgrades = new ITurtleUpgrade[]{itemTurtle.getUpgrade(turtle, TurtleSide.Left), itemTurtle.getUpgrade(turtle, TurtleSide.Right)};
        ItemStack[] items = new ItemStack[]{rightItem, leftItem};
        for (int i = 0; i < 2; ++i) {
            if (items[i] == null) continue;
            ITurtleUpgrade itemUpgrade = ComputerCraft.getTurtleUpgrade(items[i]);
            if (itemUpgrade == null) {
                return null;
            }
            if (upgrades[i] != null) {
                return null;
            }
            if (!CCTurtleProxyCommon.isUpgradeSuitableForFamily(family, itemUpgrade)) {
                return null;
            }
            upgrades[i] = itemUpgrade;
        }
        int computerID = itemTurtle.getComputerID(turtle);
        String label = itemTurtle.getLabel(turtle);
        int fuelLevel = itemTurtle.getFuelLevel(turtle);
        Colour colour = itemTurtle.getColour(turtle);
        ResourceLocation overlay = itemTurtle.getOverlay(turtle);
        return TurtleItemFactory.create(computerID, label, colour, family, upgrades[0], upgrades[1], fuelLevel, overlay);
    }

    @Nonnull
    public ItemStack[] func_179532_b(@Nonnull InventoryCrafting inventoryCrafting) {
        ItemStack[] results = new ItemStack[inventoryCrafting.func_70302_i_()];
        for (int i = 0; i < results.length; ++i) {
            ItemStack stack = inventoryCrafting.func_70301_a(i);
            results[i] = ForgeHooks.getContainerItem((ItemStack)stack);
        }
        return results;
    }
}

