/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.peripheral.PeripheralType;
import dan200.computercraft.shared.peripheral.common.PeripheralItemFactory;
import dan200.computercraft.shared.peripheral.modem.WirelessModemPeripheral;
import javax.vecmath.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TurtleModem
implements ITurtleUpgrade {
    private boolean m_advanced;
    private ResourceLocation m_id;
    private int m_legacyID;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation m_leftOffModel;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation m_rightOffModel;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation m_leftOnModel;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation m_rightOnModel;

    public TurtleModem(boolean advanced, ResourceLocation id, int legacyId) {
        this.m_advanced = advanced;
        this.m_id = id;
        this.m_legacyID = legacyId;
    }

    @Override
    public ResourceLocation getUpgradeID() {
        return this.m_id;
    }

    @Override
    public int getLegacyUpgradeID() {
        return this.m_legacyID;
    }

    @Override
    public String getUnlocalisedAdjective() {
        if (this.m_advanced) {
            return "upgrade.computercraft.advanced_modem.adjective";
        }
        return "upgrade.computercraft.wireless_modem.adjective";
    }

    @Override
    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    @Override
    public ItemStack getCraftingItem() {
        if (this.m_advanced) {
            return PeripheralItemFactory.create(PeripheralType.AdvancedModem, null, 1);
        }
        return PeripheralItemFactory.create(PeripheralType.WirelessModem, null, 1);
    }

    @Override
    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return new Peripheral(turtle, this.m_advanced);
    }

    @Override
    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, EnumFacing dir) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void loadModelLocations() {
        if (this.m_leftOffModel == null) {
            if (this.m_advanced) {
                this.m_leftOffModel = new ModelResourceLocation("computercraft:advanced_turtle_modem_off_left", "inventory");
                this.m_rightOffModel = new ModelResourceLocation("computercraft:advanced_turtle_modem_off_right", "inventory");
                this.m_leftOnModel = new ModelResourceLocation("computercraft:advanced_turtle_modem_on_left", "inventory");
                this.m_rightOnModel = new ModelResourceLocation("computercraft:advanced_turtle_modem_on_right", "inventory");
            } else {
                this.m_leftOffModel = new ModelResourceLocation("computercraft:turtle_modem_off_left", "inventory");
                this.m_rightOffModel = new ModelResourceLocation("computercraft:turtle_modem_off_right", "inventory");
                this.m_leftOnModel = new ModelResourceLocation("computercraft:turtle_modem_on_left", "inventory");
                this.m_rightOnModel = new ModelResourceLocation("computercraft:turtle_modem_on_right", "inventory");
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, TurtleSide side) {
        NBTTagCompound turtleNBT;
        this.loadModelLocations();
        boolean active = false;
        if (turtle != null && (turtleNBT = turtle.getUpgradeNBTData(side)).func_74764_b("active")) {
            active = turtleNBT.func_74767_n("active");
        }
        Object transform = null;
        Minecraft mc = Minecraft.func_71410_x();
        ModelManager modelManager = mc.func_175599_af().func_175037_a().func_178083_a();
        if (side == TurtleSide.Left) {
            return Pair.of((Object)(active ? modelManager.func_174953_a(this.m_leftOnModel) : modelManager.func_174953_a(this.m_leftOffModel)), transform);
        }
        return Pair.of((Object)(active ? modelManager.func_174953_a(this.m_rightOnModel) : modelManager.func_174953_a(this.m_rightOffModel)), transform);
    }

    @Override
    public void update(ITurtleAccess turtle, TurtleSide side) {
        Peripheral modemPeripheral;
        IPeripheral peripheral;
        if (!turtle.getWorld().field_72995_K && (peripheral = turtle.getPeripheral(side)) != null && peripheral instanceof Peripheral && (modemPeripheral = (Peripheral)peripheral).pollChanged()) {
            turtle.getUpgradeNBTData(side).func_74757_a("active", modemPeripheral.isActive());
            turtle.updateUpgradeNBTData(side);
        }
    }

    private static class Peripheral
    extends WirelessModemPeripheral
    implements IPeripheral {
        private final ITurtleAccess m_turtle;

        public Peripheral(ITurtleAccess turtle, boolean advanced) {
            super(advanced);
            this.m_turtle = turtle;
        }

        @Override
        protected World getWorld() {
            return this.m_turtle.getWorld();
        }

        @Override
        protected Vec3d getPosition() {
            BlockPos turtlePos = this.m_turtle.getPosition();
            return new Vec3d((double)turtlePos.func_177958_n(), (double)turtlePos.func_177956_o(), (double)turtlePos.func_177952_p());
        }

        @Override
        public boolean equals(IPeripheral other) {
            if (other instanceof Peripheral) {
                Peripheral otherModem = (Peripheral)other;
                return otherModem.m_turtle == this.m_turtle;
            }
            return false;
        }
    }
}

