/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.ComputerCraft;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.IEntityDropConsumer;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class TurtleTool
implements ITurtleUpgrade {
    protected ItemStack m_item;
    private ResourceLocation m_id;
    private int m_legacyId;
    private String m_adjective;

    public TurtleTool(ResourceLocation id, int legacyID, String adjective, Item item) {
        this.m_id = id;
        this.m_legacyId = legacyID;
        this.m_adjective = adjective;
        this.m_item = new ItemStack(item, 1, 0);
    }

    @Override
    public ResourceLocation getUpgradeID() {
        return this.m_id;
    }

    @Override
    public int getLegacyUpgradeID() {
        return this.m_legacyId;
    }

    @Override
    public String getUnlocalisedAdjective() {
        return this.m_adjective;
    }

    @Override
    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    @Override
    public ItemStack getCraftingItem() {
        return this.m_item.func_77946_l();
    }

    @Override
    public IPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, TurtleSide side) {
        float xOffset = side == TurtleSide.Left ? -0.40625f : 0.40625f;
        Matrix4f transform = new Matrix4f(0.0f, 0.0f, -1.0f, 1.0f + xOffset, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        return Pair.of((Object)mc.func_175599_af().func_175037_a().func_178089_a(this.m_item), (Object)transform);
    }

    @Override
    public void update(ITurtleAccess turtle, TurtleSide side) {
    }

    @Override
    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, EnumFacing direction) {
        switch (verb) {
            case Attack: {
                return this.attack(turtle, direction);
            }
            case Dig: {
                return this.dig(turtle, direction);
            }
        }
        return TurtleCommandResult.failure("Unsupported action");
    }

    protected boolean canBreakBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        return !block.isAir(state, (IBlockAccess)world, pos) && block != Blocks.field_150357_h && !(block.func_176195_g(state, world, pos) <= -1.0f);
    }

    protected boolean canHarvestBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        TurtlePlayer turtlePlayer = new TurtlePlayer((WorldServer)world);
        turtlePlayer.loadInventory(this.m_item.func_77946_l());
        return ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)turtlePlayer, (IBlockAccess)world, (BlockPos)pos);
    }

    protected float getDamageMultiplier() {
        return 3.0f;
    }

    private TurtleCommandResult attack(final ITurtleAccess turtle, EnumFacing direction) {
        BlockPos position;
        Vec3d rayDir;
        TurtlePlayer turtlePlayer;
        Vec3d turtlePos;
        Vec3d rayStart;
        final World world = turtle.getWorld();
        Pair<Entity, Vec3d> hit = WorldUtil.rayTraceEntities(world, rayStart = (turtlePos = new Vec3d(turtlePlayer.field_70165_t, turtlePlayer.field_70163_u, turtlePlayer.field_70161_v)), rayDir = (turtlePlayer = TurtlePlaceCommand.createPlayer(turtle, position = turtle.getPosition(), direction)).func_70676_i(1.0f), 1.5);
        if (hit != null) {
            ItemStack stackCopy = this.m_item.func_77946_l();
            turtlePlayer.loadInventory(stackCopy);
            Entity hitEntity = (Entity)hit.getKey();
            ComputerCraft.setEntityDropConsumer(hitEntity, new IEntityDropConsumer(){

                @Override
                public void consumeDrop(Entity entity, ItemStack drop) {
                    ItemStack remainder = InventoryUtil.storeItems(drop, turtle.getInventory(), 0, turtle.getInventory().func_70302_i_(), turtle.getSelectedSlot());
                    if (remainder != null) {
                        WorldUtil.dropItemStack(remainder, world, position, turtle.getDirection().func_176734_d());
                    }
                }
            });
            boolean placed = false;
            if (hitEntity.func_70075_an() && !hitEntity.func_85031_j((Entity)turtlePlayer)) {
                float damage = (float)turtlePlayer.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                if ((damage *= this.getDamageMultiplier()) > 0.0f) {
                    DamageSource source = DamageSource.func_76365_a((EntityPlayer)turtlePlayer);
                    if (hitEntity instanceof EntityArmorStand) {
                        hitEntity.func_70097_a(source, damage);
                        if (!hitEntity.field_70128_L) {
                            hitEntity.func_70097_a(source, damage);
                        }
                        placed = true;
                    } else if (hitEntity.func_70097_a(source, damage)) {
                        placed = true;
                    }
                }
            }
            ComputerCraft.clearEntityDropConsumer(hitEntity);
            if (placed) {
                turtlePlayer.unloadInventory(turtle);
                return TurtleCommandResult.success();
            }
        }
        return TurtleCommandResult.failure("Nothing to attack here");
    }

    private TurtleCommandResult dig(ITurtleAccess turtle, EnumFacing direction) {
        BlockPos position;
        BlockPos newPosition;
        World world = turtle.getWorld();
        if (WorldUtil.isBlockInWorld(world, newPosition = WorldUtil.moveCoords(position = turtle.getPosition(), direction)) && !world.func_175623_d(newPosition) && !WorldUtil.isLiquidBlock(world, newPosition)) {
            List<ItemStack> items;
            TurtlePlayer turtlePlayer;
            if (ComputerCraft.Config.turtlesObeyBlockProtection && !ComputerCraft.isBlockEditable(world, newPosition, (EntityPlayer)(turtlePlayer = TurtlePlaceCommand.createPlayer(turtle, position, direction)))) {
                return TurtleCommandResult.failure("Cannot break protected block");
            }
            if (!this.canBreakBlock(world, newPosition)) {
                return TurtleCommandResult.failure("Unbreakable block detected");
            }
            if (this.canHarvestBlock(world, newPosition) && (items = this.getBlockDropped(world, newPosition)).size() > 0) {
                for (ItemStack stack : items) {
                    ItemStack remainder = InventoryUtil.storeItems(stack, turtle.getInventory(), 0, turtle.getInventory().func_70302_i_(), turtle.getSelectedSlot());
                    if (remainder == null) continue;
                    WorldUtil.dropItemStack(remainder, world, position, direction);
                }
            }
            IBlockState previousState = world.func_180495_p(newPosition);
            world.func_175718_b(2001, newPosition, Block.func_176210_f((IBlockState)previousState));
            world.func_175698_g(newPosition);
            if (turtle instanceof TurtleBrain) {
                TurtleBrain brain = (TurtleBrain)turtle;
                brain.saveBlockChange(newPosition, previousState);
            }
            return TurtleCommandResult.success();
        }
        return TurtleCommandResult.failure("Nothing to dig here");
    }

    private List<ItemStack> getBlockDropped(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block.getDrops((IBlockAccess)world, pos, world.func_180495_p(pos), 0);
    }
}

