/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class IDAssigner {
    private IDAssigner() {
    }

    public static int getNextIDFromDirectory(File dir) {
        return IDAssigner.getNextID(dir, true);
    }

    public static int getNextIDFromFile(File file) {
        return IDAssigner.getNextID(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getNextID(File location, boolean directory) {
        File lastidFile = null;
        if (directory) {
            location.mkdirs();
            lastidFile = new File(location, "lastid.txt");
        } else {
            location.getParentFile().mkdirs();
            lastidFile = location;
        }
        int id = 0;
        if (!lastidFile.exists()) {
            if (directory && location.exists() && location.isDirectory()) {
                String[] contents = location.list();
                for (int i = 0; i < contents.length; ++i) {
                    try {
                        int number = Integer.parseInt(contents[i]);
                        id = Math.max(number + 1, id);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
        } else {
            String idString = "0";
            try {
                InputStreamReader isr;
                FileInputStream in = new FileInputStream(lastidFile);
                try {
                    isr = new InputStreamReader((InputStream)in, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    isr = new InputStreamReader(in);
                }
                try (BufferedReader br = new BufferedReader(isr);){
                    idString = br.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return 0;
            }
            try {
                id = Integer.parseInt(idString) + 1;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return 0;
            }
        }
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(lastidFile, false));
            out.write(Integer.toString(id));
            out.newLine();
            out.close();
        }
        catch (IOException e) {
            System.out.println("An error occured while trying to create the computer folder. Please check you have relevant permissions.");
            e.printStackTrace();
        }
        return id;
    }
}

