/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryUtil {
    public static boolean areItemsEqual(@Nullable ItemStack a, @Nullable ItemStack b) {
        return InventoryUtil.areItemsStackable(a, b) && a.field_77994_a == b.field_77994_a;
    }

    public static boolean areItemsStackable(@Nullable ItemStack a, @Nullable ItemStack b) {
        if (a == b) {
            return true;
        }
        return a.func_77973_b() == b.func_77973_b() && a.func_77952_i() == b.func_77952_i() && (a.func_77978_p() == null && b.func_77978_p() == null || a.func_77978_p() != null && b.func_77978_p() != null && a.func_77978_p().equals((Object)b.func_77978_p()));
    }

    @Nullable
    public static ItemStack copyItem(@Nullable ItemStack a) {
        return a.func_77946_l();
    }

    public static IInventory getInventory(World world, BlockPos pos, EnumFacing side) {
        Entity entity;
        EnumFacing dir;
        Vec3d vecDir;
        TileEntity tileEntity;
        int y = pos.func_177956_o();
        if (y >= 0 && y < world.func_72800_K() && (tileEntity = world.func_175625_s(pos)) != null && tileEntity instanceof IInventory) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (block == Blocks.field_150486_ae || block == Blocks.field_150447_bR) {
                if (world.func_180495_p(pos.func_177976_e()).func_177230_c() == block) {
                    return new InventoryLargeChest("Large chest", (ILockableContainer)world.func_175625_s(pos.func_177976_e()), (ILockableContainer)tileEntity);
                }
                if (world.func_180495_p(pos.func_177974_f()).func_177230_c() == block) {
                    return new InventoryLargeChest("Large chest", (ILockableContainer)tileEntity, (ILockableContainer)world.func_175625_s(pos.func_177974_f()));
                }
                if (world.func_180495_p(pos.func_177978_c()).func_177230_c() == block) {
                    return new InventoryLargeChest("Large chest", (ILockableContainer)world.func_175625_s(pos.func_177978_c()), (ILockableContainer)tileEntity);
                }
                if (world.func_180495_p(pos.func_177968_d()).func_177230_c() == block) {
                    return new InventoryLargeChest("Large chest", (ILockableContainer)tileEntity, (ILockableContainer)world.func_175625_s(pos.func_177968_d()));
                }
            }
            return (IInventory)tileEntity;
        }
        Vec3d vecStart = new Vec3d((double)pos.func_177958_n() + 0.5 + 0.6 * (double)side.func_82601_c(), (double)pos.func_177956_o() + 0.5 + 0.6 * (double)side.func_96559_d(), (double)pos.func_177952_p() + 0.5 + 0.6 * (double)side.func_82599_e());
        Pair<Entity, Vec3d> hit = WorldUtil.rayTraceEntities(world, vecStart, vecDir = new Vec3d((double)(dir = side.func_176734_d()).func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e()), 1.1);
        if (hit != null && (entity = (Entity)hit.getKey()) instanceof IInventory) {
            return (IInventory)entity;
        }
        return null;
    }

    @Nullable
    public static ItemStack storeItems(ItemStack itemstack, IInventory inventory, int start, int range, int begin) {
        int[] slots = InventoryUtil.makeSlotList(start, range, begin);
        return InventoryUtil.storeItems(itemstack, inventory, slots, null);
    }

    @Nullable
    public static ItemStack storeItems(ItemStack itemstack, IInventory inventory, EnumFacing side) {
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_180463_a(side);
            return InventoryUtil.storeItems(itemstack, inventory, slots, side);
        }
        int[] slots = InventoryUtil.makeSlotList(0, inventory.func_70302_i_(), 0);
        return InventoryUtil.storeItems(itemstack, inventory, slots, side);
    }

    @Nullable
    public static ItemStack takeItems(int count, IInventory inventory, int start, int range, int begin) {
        int[] slots = InventoryUtil.makeSlotList(start, range, begin);
        return InventoryUtil.takeItems(count, inventory, slots, null);
    }

    @Nullable
    public static ItemStack takeItems(int count, IInventory inventory, EnumFacing side) {
        if (inventory instanceof ISidedInventory) {
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_180463_a(side);
            return InventoryUtil.takeItems(count, inventory, slots, side);
        }
        int[] slots = InventoryUtil.makeSlotList(0, inventory.func_70302_i_(), 0);
        return InventoryUtil.takeItems(count, inventory, slots, side);
    }

    private static int[] makeSlotList(int start, int range, int begin) {
        if (start < 0 || range == 0) {
            return null;
        }
        int[] slots = new int[range];
        for (int n = 0; n < slots.length; ++n) {
            slots[n] = start + (n + (begin - start)) % range;
        }
        return slots;
    }

    @Nullable
    private static ItemStack storeItems(ItemStack stack, IInventory inventory, int[] slots, EnumFacing face) {
        if (slots == null || slots.length == 0) {
            return stack;
        }
        if (stack == null || stack.field_77994_a == 0) {
            return null;
        }
        ItemStack remainder = stack;
        for (int slot : slots) {
            int space;
            if (!InventoryUtil.canPlaceItemThroughFace(inventory, slot, remainder, face)) continue;
            ItemStack slotContents = inventory.func_70301_a(slot);
            if (slotContents == null) {
                space = inventory.func_70297_j_();
                if (space >= remainder.field_77994_a) {
                    inventory.func_70299_a(slot, remainder);
                    inventory.func_70296_d();
                    return null;
                }
                remainder = remainder.func_77946_l();
                inventory.func_70299_a(slot, remainder.func_77979_a(space));
                continue;
            }
            if (!InventoryUtil.areItemsStackable(slotContents, remainder)) continue;
            space = Math.min(slotContents.func_77976_d(), inventory.func_70297_j_()) - slotContents.field_77994_a;
            if (space >= remainder.field_77994_a) {
                slotContents.field_77994_a += remainder.field_77994_a;
                inventory.func_70299_a(slot, slotContents);
                inventory.func_70296_d();
                return null;
            }
            if (space <= 0) continue;
            remainder = remainder.func_77946_l();
            remainder.field_77994_a -= space;
            slotContents.field_77994_a += space;
            inventory.func_70299_a(slot, slotContents);
        }
        if (remainder != stack) {
            inventory.func_70296_d();
        }
        return remainder;
    }

    private static boolean canPlaceItemThroughFace(IInventory inventory, int slot, ItemStack itemstack, EnumFacing face) {
        if (inventory.func_94041_b(slot, itemstack)) {
            if (face != null && inventory instanceof ISidedInventory) {
                ISidedInventory sided = (ISidedInventory)inventory;
                return sided.func_180462_a(slot, itemstack, face);
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static ItemStack takeItems(int count, IInventory inventory, int[] slots, EnumFacing face) {
        if (slots == null) {
            return null;
        }
        ItemStack partialStack = null;
        int countRemaining = count;
        for (int slot : slots) {
            ItemStack stack;
            if (countRemaining <= 0 || (stack = inventory.func_70301_a(slot)) == null || !InventoryUtil.canTakeItemThroughFace(inventory, slot, stack, face) || partialStack != null && !InventoryUtil.areItemsStackable(stack, partialStack)) continue;
            if (countRemaining >= stack.field_77994_a) {
                inventory.func_70299_a(slot, null);
                if (partialStack == null) {
                    partialStack = stack;
                    countRemaining = Math.min(countRemaining, partialStack.func_77973_b().getItemStackLimit(partialStack)) - stack.field_77994_a;
                    continue;
                }
                partialStack.field_77994_a += stack.field_77994_a;
                countRemaining -= stack.field_77994_a;
                continue;
            }
            ItemStack splitStack = stack.func_77979_a(countRemaining);
            if (partialStack == null) {
                partialStack = splitStack;
                countRemaining = Math.min(countRemaining, partialStack.func_77973_b().getItemStackLimit(partialStack)) - splitStack.field_77994_a;
                continue;
            }
            partialStack.field_77994_a += splitStack.field_77994_a;
            countRemaining -= splitStack.field_77994_a;
        }
        if (partialStack != null) {
            inventory.func_70296_d();
            return partialStack;
        }
        return null;
    }

    private static boolean canTakeItemThroughFace(IInventory inventory, int slot, ItemStack itemstack, EnumFacing face) {
        if (face != null && inventory instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)inventory;
            return sided.func_180461_b(slot, itemstack, face);
        }
        return true;
    }
}

