/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagString;

public class NBTUtil {
    private static NBTBase toNBTTag(Object object) {
        if (object != null) {
            if (object instanceof Boolean) {
                boolean b = (Boolean)object;
                return new NBTTagByte(b ? (byte)1 : 0);
            }
            if (object instanceof Number) {
                Double d = ((Number)object).doubleValue();
                return new NBTTagDouble(d.doubleValue());
            }
            if (object instanceof String) {
                String s = object.toString();
                return new NBTTagString(s);
            }
            if (object instanceof Map) {
                Map m = (Map)object;
                NBTTagCompound nbt = new NBTTagCompound();
                int i = 0;
                for (Map.Entry entry : m.entrySet()) {
                    NBTBase key = NBTUtil.toNBTTag(entry.getKey());
                    NBTBase value = NBTUtil.toNBTTag(entry.getKey());
                    if (key == null || value == null) continue;
                    nbt.func_74782_a("k" + Integer.toString(i), key);
                    nbt.func_74782_a("v" + Integer.toString(i), value);
                    ++i;
                }
                nbt.func_74768_a("len", m.size());
                return nbt;
            }
        }
        return null;
    }

    public static NBTTagCompound encodeObjects(Object[] objects) {
        if (objects != null && objects.length > 0) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("len", objects.length);
            for (int i = 0; i < objects.length; ++i) {
                Object object = objects[i];
                NBTBase tag = NBTUtil.toNBTTag(object);
                if (tag == null) continue;
                nbt.func_74782_a(Integer.toString(i), tag);
            }
            return nbt;
        }
        return null;
    }

    private static Object fromNBTTag(NBTBase tag) {
        if (tag != null) {
            byte typeID = tag.func_74732_a();
            switch (typeID) {
                case 1: {
                    boolean b = ((NBTTagByte)tag).func_150290_f() > 0;
                    return b;
                }
                case 6: {
                    double d = ((NBTTagDouble)tag).func_150286_g();
                    return d;
                }
                case 8: {
                    String s = ((NBTTagString)tag).func_150285_a_();
                    return s;
                }
                case 10: {
                    NBTTagCompound c = (NBTTagCompound)tag;
                    int len = c.func_74762_e("len");
                    HashMap<Object, Object> map = new HashMap<Object, Object>(len);
                    for (int i = 0; i < len; ++i) {
                        Object key = NBTUtil.fromNBTTag(c.func_74781_a("k" + Integer.toString(i)));
                        Object value = NBTUtil.fromNBTTag(c.func_74781_a("v" + Integer.toString(i)));
                        if (key == null || value == null) continue;
                        map.put(key, value);
                    }
                    return map;
                }
            }
        }
        return null;
    }

    public static Object[] decodeObjects(NBTTagCompound tagCompound) {
        int len = tagCompound.func_74762_e("len");
        if (len > 0) {
            Object[] objects = new Object[len];
            for (int i = 0; i < len; ++i) {
                String key = Integer.toString(i);
                if (!tagCompound.func_74764_b(key)) continue;
                NBTBase tag = tagCompound.func_74781_a(key);
                objects[i] = NBTUtil.fromNBTTag(tag);
            }
            return objects;
        }
        return null;
    }
}

