/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.ComputerCraft;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RedstoneUtil {
    private static Block getBlock(IBlockAccess world, BlockPos pos) {
        if (pos.func_177956_o() >= 0) {
            return world.func_180495_p(pos).func_177230_c();
        }
        return null;
    }

    public static int getRedstoneOutput(World world, BlockPos pos, EnumFacing side) {
        int power = 0;
        Block block = RedstoneUtil.getBlock((IBlockAccess)world, pos);
        if (block != null && block != Blocks.field_150350_a) {
            IBlockState state = world.func_180495_p(pos);
            if (block == Blocks.field_150488_af) {
                power = side != EnumFacing.UP ? (Integer)state.func_177229_b((IProperty)BlockRedstoneWire.field_176351_O) : 0;
            } else if (block.func_149744_f(state)) {
                power = block.func_180656_a(state, (IBlockAccess)world, pos, side.func_176734_d());
            }
            if (block.isNormalCube(state, (IBlockAccess)world, pos)) {
                for (EnumFacing testSide : EnumFacing.field_82609_l) {
                    BlockPos testPos;
                    Block neighbour;
                    if (testSide == side || (neighbour = RedstoneUtil.getBlock((IBlockAccess)world, testPos = pos.func_177972_a(testSide))) == null || !neighbour.func_149744_f(state)) continue;
                    power = Math.max(power, neighbour.func_176211_b(state, (IBlockAccess)world, testPos, testSide.func_176734_d()));
                }
            }
        }
        return power;
    }

    public static int getBundledRedstoneOutput(World world, BlockPos pos, EnumFacing side) {
        int signal = ComputerCraft.getBundledRedstoneOutput(world, pos, side);
        if (signal >= 0) {
            return signal;
        }
        return 0;
    }

    public static void propogateRedstoneOutput(World world, BlockPos pos, EnumFacing side) {
        Block block = RedstoneUtil.getBlock((IBlockAccess)world, pos);
        BlockPos neighbourPos = pos.func_177972_a(side);
        Block neighbour = RedstoneUtil.getBlock((IBlockAccess)world, neighbourPos);
        if (neighbour != null && neighbour != Blocks.field_150350_a) {
            world.func_175685_c(neighbourPos, block);
            if (neighbour.isNormalCube(world.func_180495_p(neighbourPos), (IBlockAccess)world, neighbourPos)) {
                world.func_175695_a(neighbourPos, neighbour, side.func_176734_d());
            }
        }
    }
}

