/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.ast;

import org.luaj.vm2.LuaValue;
import org.luaj.vm2.ast.FuncArgs;
import org.luaj.vm2.ast.FuncBody;
import org.luaj.vm2.ast.Name;
import org.luaj.vm2.ast.TableConstructor;
import org.luaj.vm2.ast.Visitor;

public abstract class Exp {
    public abstract void accept(Visitor var1);

    public static Exp constant(LuaValue luaValue) {
        return new Constant(luaValue);
    }

    public static Exp numberconstant(String string) {
        return new Constant(LuaValue.valueOf(string).tonumber());
    }

    public static Exp varargs() {
        return new VarargsExp();
    }

    public static Exp tableconstructor(TableConstructor tableConstructor) {
        return tableConstructor;
    }

    public static Exp unaryexp(int n, Exp exp) {
        if (exp instanceof BinopExp) {
            BinopExp binopExp = (BinopExp)exp;
            if (Exp.precedence(n) > Exp.precedence(binopExp.op)) {
                return Exp.binaryexp(Exp.unaryexp(n, binopExp.lhs), binopExp.op, binopExp.rhs);
            }
        }
        return new UnopExp(n, exp);
    }

    public static Exp binaryexp(Exp exp, int n, Exp exp2) {
        Exp exp3;
        if (exp instanceof UnopExp) {
            exp3 = (UnopExp)exp;
            if (Exp.precedence(n) > Exp.precedence(exp3.op)) {
                return Exp.unaryexp(exp3.op, Exp.binaryexp(exp3.rhs, n, exp2));
            }
        }
        if (exp instanceof BinopExp) {
            exp3 = (BinopExp)exp;
            if (Exp.precedence(n) > Exp.precedence(((BinopExp)exp3).op) || Exp.precedence(n) == Exp.precedence(((BinopExp)exp3).op) && Exp.isrightassoc(n)) {
                return Exp.binaryexp(((BinopExp)exp3).lhs, ((BinopExp)exp3).op, Exp.binaryexp(((BinopExp)exp3).rhs, n, exp2));
            }
        }
        if (exp2 instanceof BinopExp) {
            exp3 = (BinopExp)exp2;
            if (Exp.precedence(n) > Exp.precedence(((BinopExp)exp3).op) || Exp.precedence(n) == Exp.precedence(((BinopExp)exp3).op) && !Exp.isrightassoc(n)) {
                return Exp.binaryexp(Exp.binaryexp(exp, n, ((BinopExp)exp3).lhs), ((BinopExp)exp3).op, ((BinopExp)exp3).rhs);
            }
        }
        return new BinopExp(exp, n, exp2);
    }

    static boolean isrightassoc(int n) {
        switch (n) {
            case 17: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    static int precedence(int n) {
        switch (n) {
            case 59: {
                return 0;
            }
            case 60: {
                return 1;
            }
            case 23: 
            case 24: 
            case 25: 
            case 61: 
            case 62: 
            case 63: {
                return 2;
            }
            case 21: {
                return 3;
            }
            case 12: 
            case 13: {
                return 4;
            }
            case 14: 
            case 15: 
            case 16: {
                return 5;
            }
            case 18: 
            case 19: 
            case 20: {
                return 6;
            }
            case 17: {
                return 7;
            }
        }
        throw new IllegalStateException("precedence of bad op " + n);
    }

    public static Exp anonymousfunction(FuncBody funcBody) {
        return new AnonFuncDef(funcBody);
    }

    public static NameExp nameprefix(String string) {
        return new NameExp(string);
    }

    public static ParensExp parensprefix(Exp exp) {
        return new ParensExp(exp);
    }

    public static IndexExp indexop(PrimaryExp primaryExp, Exp exp) {
        return new IndexExp(primaryExp, exp);
    }

    public static FieldExp fieldop(PrimaryExp primaryExp, String string) {
        return new FieldExp(primaryExp, string);
    }

    public static FuncCall functionop(PrimaryExp primaryExp, FuncArgs funcArgs) {
        return new FuncCall(primaryExp, funcArgs);
    }

    public static MethodCall methodop(PrimaryExp primaryExp, String string, FuncArgs funcArgs) {
        return new MethodCall(primaryExp, string, funcArgs);
    }

    public boolean isvarexp() {
        return false;
    }

    public boolean isfunccall() {
        return false;
    }

    public boolean isvarargexp() {
        return false;
    }

    public static class AnonFuncDef
    extends Exp {
        public final FuncBody body;

        public AnonFuncDef(FuncBody funcBody) {
            this.body = funcBody;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class BinopExp
    extends Exp {
        public final Exp lhs;
        public final Exp rhs;
        public final int op;

        public BinopExp(Exp exp, int n, Exp exp2) {
            this.lhs = exp;
            this.op = n;
            this.rhs = exp2;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class UnopExp
    extends Exp {
        public final int op;
        public final Exp rhs;

        public UnopExp(int n, Exp exp) {
            this.op = n;
            this.rhs = exp;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class VarargsExp
    extends Exp {
        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public boolean isvarargexp() {
            return true;
        }
    }

    public static class Constant
    extends Exp {
        public final LuaValue value;

        public Constant(LuaValue luaValue) {
            this.value = luaValue;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class MethodCall
    extends FuncCall {
        public final String name;

        public MethodCall(PrimaryExp primaryExp, String string, FuncArgs funcArgs) {
            super(primaryExp, funcArgs);
            this.name = new String(string);
        }

        public boolean isfunccall() {
            return true;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class FuncCall
    extends PrimaryExp {
        public final PrimaryExp lhs;
        public final FuncArgs args;

        public FuncCall(PrimaryExp primaryExp, FuncArgs funcArgs) {
            this.lhs = primaryExp;
            this.args = funcArgs;
        }

        public boolean isfunccall() {
            return true;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }

        public boolean isvarargexp() {
            return true;
        }
    }

    public static class IndexExp
    extends VarExp {
        public final PrimaryExp lhs;
        public final Exp exp;

        public IndexExp(PrimaryExp primaryExp, Exp exp) {
            this.lhs = primaryExp;
            this.exp = exp;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class FieldExp
    extends VarExp {
        public final PrimaryExp lhs;
        public final Name name;

        public FieldExp(PrimaryExp primaryExp, String string) {
            this.lhs = primaryExp;
            this.name = new Name(string);
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class ParensExp
    extends PrimaryExp {
        public final Exp exp;

        public ParensExp(Exp exp) {
            this.exp = exp;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NameExp
    extends VarExp {
        public final Name name;

        public NameExp(String string) {
            this.name = new Name(string);
        }

        public void markHasAssignment() {
            this.name.variable.hasassignments = true;
        }

        public void accept(Visitor visitor) {
            visitor.visit(this);
        }
    }

    public static abstract class VarExp
    extends PrimaryExp {
        public boolean isvarexp() {
            return true;
        }

        public void markHasAssignment() {
        }
    }

    public static abstract class PrimaryExp
    extends Exp {
        public boolean isvarexp() {
            return false;
        }

        public boolean isfunccall() {
            return false;
        }
    }
}

