/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.luaj.vm2.LocVars;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaInteger;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.compiler.FuncState;
import org.luaj.vm2.compiler.InstructionPtr;
import org.luaj.vm2.compiler.IntPtr;
import org.luaj.vm2.compiler.LuaC;

public class LexState {
    protected static final String RESERVED_LOCAL_VAR_FOR_CONTROL = "(for control)";
    protected static final String RESERVED_LOCAL_VAR_FOR_STATE = "(for state)";
    protected static final String RESERVED_LOCAL_VAR_FOR_GENERATOR = "(for generator)";
    protected static final String RESERVED_LOCAL_VAR_FOR_STEP = "(for step)";
    protected static final String RESERVED_LOCAL_VAR_FOR_LIMIT = "(for limit)";
    protected static final String RESERVED_LOCAL_VAR_FOR_INDEX = "(for index)";
    protected static final String[] RESERVED_LOCAL_VAR_KEYWORDS;
    private static final Hashtable RESERVED_LOCAL_VAR_KEYWORDS_TABLE;
    private static final int EOZ = -1;
    private static final int MAXSRC = 80;
    private static final int MAX_INT = 0x7FFFFFFD;
    private static final int UCHAR_MAX = 255;
    private static final int LUAI_MAXCCALLS = 200;
    private static final int LUA_COMPAT_LSTR = 1;
    private static final boolean LUA_COMPAT_VARARG = true;
    static final int NO_JUMP = -1;
    static final int OPR_ADD = 0;
    static final int OPR_SUB = 1;
    static final int OPR_MUL = 2;
    static final int OPR_DIV = 3;
    static final int OPR_MOD = 4;
    static final int OPR_POW = 5;
    static final int OPR_CONCAT = 6;
    static final int OPR_NE = 7;
    static final int OPR_EQ = 8;
    static final int OPR_LT = 9;
    static final int OPR_LE = 10;
    static final int OPR_GT = 11;
    static final int OPR_GE = 12;
    static final int OPR_AND = 13;
    static final int OPR_OR = 14;
    static final int OPR_NOBINOPR = 15;
    static final int OPR_MINUS = 0;
    static final int OPR_NOT = 1;
    static final int OPR_LEN = 2;
    static final int OPR_NOUNOPR = 3;
    static final int VVOID = 0;
    static final int VNIL = 1;
    static final int VTRUE = 2;
    static final int VFALSE = 3;
    static final int VK = 4;
    static final int VKNUM = 5;
    static final int VLOCAL = 6;
    static final int VUPVAL = 7;
    static final int VGLOBAL = 8;
    static final int VINDEXED = 9;
    static final int VJMP = 10;
    static final int VRELOCABLE = 11;
    static final int VNONRELOC = 12;
    static final int VCALL = 13;
    static final int VVARARG = 14;
    int current;
    int linenumber;
    int lastline;
    final Token t = new Token();
    final Token lookahead = new Token();
    FuncState fs;
    LuaC L;
    InputStream z;
    byte[] buff;
    int nbuff;
    LuaString source;
    byte decpoint;
    static final String[] luaX_tokens;
    static final int TK_AND = 257;
    static final int TK_BREAK = 258;
    static final int TK_DO = 259;
    static final int TK_ELSE = 260;
    static final int TK_ELSEIF = 261;
    static final int TK_END = 262;
    static final int TK_FALSE = 263;
    static final int TK_FOR = 264;
    static final int TK_FUNCTION = 265;
    static final int TK_IF = 266;
    static final int TK_IN = 267;
    static final int TK_LOCAL = 268;
    static final int TK_NIL = 269;
    static final int TK_NOT = 270;
    static final int TK_OR = 271;
    static final int TK_REPEAT = 272;
    static final int TK_RETURN = 273;
    static final int TK_THEN = 274;
    static final int TK_TRUE = 275;
    static final int TK_UNTIL = 276;
    static final int TK_WHILE = 277;
    static final int TK_CONCAT = 278;
    static final int TK_DOTS = 279;
    static final int TK_EQ = 280;
    static final int TK_GE = 281;
    static final int TK_LE = 282;
    static final int TK_NE = 283;
    static final int TK_NUMBER = 284;
    static final int TK_NAME = 285;
    static final int TK_STRING = 286;
    static final int TK_EOS = 287;
    static final int FIRST_RESERVED = 257;
    static final int NUM_RESERVED = 21;
    static final Hashtable RESERVED;
    static Priority[] priority;
    static final int UNARY_PRIORITY = 8;

    private static final String LUA_QS(String string) {
        return "'" + string + "'";
    }

    private static final String LUA_QL(Object object) {
        return LexState.LUA_QS(String.valueOf(object));
    }

    public static boolean isReservedKeyword(String string) {
        return RESERVED_LOCAL_VAR_KEYWORDS_TABLE.containsKey(string);
    }

    private boolean isalnum(int n) {
        return n >= 48 && n <= 57 || n >= 97 && n <= 122 || n >= 65 && n <= 90 || n == 95;
    }

    private boolean isalpha(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90;
    }

    private boolean isdigit(int n) {
        return n >= 48 && n <= 57;
    }

    private boolean isspace(int n) {
        return n <= 32;
    }

    public LexState(LuaC luaC, InputStream inputStream) {
        this.z = inputStream;
        this.buff = new byte[32];
        this.L = luaC;
    }

    void nextChar() {
        try {
            this.current = this.z.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.current = -1;
        }
    }

    boolean currIsNewline() {
        return this.current == 10 || this.current == 13;
    }

    void save_and_next() {
        this.save(this.current);
        this.nextChar();
    }

    void save(int n) {
        if (this.buff == null || this.nbuff + 1 > this.buff.length) {
            this.buff = LuaC.realloc(this.buff, this.nbuff * 2 + 1);
        }
        this.buff[this.nbuff++] = (byte)n;
    }

    String token2str(int n) {
        if (n < 257) {
            return LexState.iscntrl(n) ? this.L.pushfstring("char(" + n + ")") : this.L.pushfstring(String.valueOf((char)n));
        }
        return luaX_tokens[n - 257];
    }

    private static boolean iscntrl(int n) {
        return n < 32;
    }

    String txtToken(int n) {
        switch (n) {
            case 284: 
            case 285: 
            case 286: {
                return new String(this.buff, 0, this.nbuff);
            }
        }
        return this.token2str(n);
    }

    void lexerror(String string, int n) {
        String string2 = this.chunkid(this.source.tojstring());
        this.L.pushfstring(string2 + ":" + this.linenumber + ": " + string);
        if (n != 0) {
            this.L.pushfstring("syntax error: " + string + " near " + this.txtToken(n));
        }
        throw new LuaError(string2 + ":" + this.linenumber + ": " + string);
    }

    String chunkid(String string) {
        if (string.startsWith("=")) {
            return string.substring(1);
        }
        String string2 = "";
        if (string.startsWith("@")) {
            string = string.substring(1);
        } else {
            string = "[string \"" + string;
            string2 = "\"]";
        }
        int n = string.length() + string2.length();
        if (n > 80) {
            string = string.substring(0, 80 - string2.length() - 3) + "...";
        }
        return string + string2;
    }

    void syntaxerror(String string) {
        this.lexerror(string, this.t.token);
    }

    LuaString newstring(String string) {
        byte[] byArray = string.getBytes();
        return this.L.newTString(byArray, 0, byArray.length);
    }

    LuaString newstring(byte[] byArray, int n, int n2) {
        return this.L.newTString(byArray, n, n2);
    }

    void inclinenumber() {
        int n = this.current;
        LuaC._assert(this.currIsNewline());
        this.nextChar();
        if (this.currIsNewline() && this.current != n) {
            this.nextChar();
        }
        if (++this.linenumber >= 0x7FFFFFFD) {
            this.syntaxerror("chunk has too many lines");
        }
    }

    void setinput(LuaC luaC, int n, InputStream inputStream, LuaString luaString) {
        this.decpoint = (byte)46;
        this.L = luaC;
        this.lookahead.token = 287;
        this.z = inputStream;
        this.fs = null;
        this.linenumber = 1;
        this.lastline = 1;
        this.source = luaString;
        this.nbuff = 0;
        this.current = n;
        this.skipShebang();
    }

    private void skipShebang() {
        if (this.current == 35) {
            while (!this.currIsNewline() && this.current != -1) {
                this.nextChar();
            }
        }
    }

    boolean check_next(String string) {
        if (string.indexOf(this.current) < 0) {
            return false;
        }
        this.save_and_next();
        return true;
    }

    void buffreplace(byte by, byte by2) {
        int n = this.nbuff;
        byte[] byArray = this.buff;
        while (--n >= 0) {
            if (byArray[n] != by) continue;
            byArray[n] = by2;
        }
    }

    boolean str2d(String string, SemInfo semInfo) {
        double d = (string = string.trim()).startsWith("0x") ? (double)Long.parseLong(string.substring(2), 16) : Double.parseDouble(string);
        semInfo.r = LuaValue.valueOf(d);
        return true;
    }

    void read_numeral(SemInfo semInfo) {
        LuaC._assert(this.isdigit(this.current));
        do {
            this.save_and_next();
        } while (this.isdigit(this.current) || this.current == 46);
        if (this.check_next("Ee")) {
            this.check_next("+-");
        }
        while (this.isalnum(this.current) || this.current == 95) {
            this.save_and_next();
        }
        this.save(0);
        this.buffreplace((byte)46, this.decpoint);
        String string = new String(this.buff, 0, this.nbuff);
        this.str2d(string, semInfo);
    }

    int skip_sep() {
        int n = 0;
        int n2 = this.current;
        LuaC._assert(n2 == 91 || n2 == 93);
        this.save_and_next();
        while (this.current == 61) {
            this.save_and_next();
            ++n;
        }
        return this.current == n2 ? n : -n - 1;
    }

    void read_long_string(SemInfo semInfo, int n) {
        int n2 = 0;
        this.save_and_next();
        if (this.currIsNewline()) {
            this.inclinenumber();
        }
        boolean bl = false;
        block6: while (!bl) {
            switch (this.current) {
                case -1: {
                    this.lexerror(semInfo != null ? "unfinished long string" : "unfinished long comment", 287);
                    continue block6;
                }
                case 91: {
                    if (this.skip_sep() != n) continue block6;
                    this.save_and_next();
                    ++n2;
                    if (n != 0) continue block6;
                    this.lexerror("nesting of [[...]] is deprecated", 91);
                    continue block6;
                }
                case 93: {
                    if (this.skip_sep() != n) continue block6;
                    this.save_and_next();
                    bl = true;
                    continue block6;
                }
                case 10: 
                case 13: {
                    this.save(10);
                    this.inclinenumber();
                    if (semInfo != null) continue block6;
                    this.nbuff = 0;
                    continue block6;
                }
            }
            if (semInfo != null) {
                this.save_and_next();
                continue;
            }
            this.nextChar();
        }
        if (semInfo != null) {
            semInfo.ts = this.newstring(this.buff, 2 + n, this.nbuff - 2 * (2 + n));
        }
    }

    void read_string(int n, SemInfo semInfo) {
        this.save_and_next();
        block16: while (this.current != n) {
            switch (this.current) {
                case -1: {
                    this.lexerror("unfinished string", 287);
                    continue block16;
                }
                case 10: 
                case 13: {
                    this.lexerror("unfinished string", 286);
                    continue block16;
                }
                case 92: {
                    int n2;
                    this.nextChar();
                    switch (this.current) {
                        case 97: {
                            n2 = 7;
                            break;
                        }
                        case 98: {
                            n2 = 8;
                            break;
                        }
                        case 102: {
                            n2 = 12;
                            break;
                        }
                        case 110: {
                            n2 = 10;
                            break;
                        }
                        case 114: {
                            n2 = 13;
                            break;
                        }
                        case 116: {
                            n2 = 9;
                            break;
                        }
                        case 118: {
                            n2 = 11;
                            break;
                        }
                        case 10: 
                        case 13: {
                            this.save(10);
                            this.inclinenumber();
                            continue block16;
                        }
                        case -1: {
                            continue block16;
                        }
                        default: {
                            if (!this.isdigit(this.current)) {
                                this.save_and_next();
                                continue block16;
                            }
                            int n3 = 0;
                            n2 = 0;
                            do {
                                n2 = 10 * n2 + (this.current - 48);
                                this.nextChar();
                            } while (++n3 < 3 && this.isdigit(this.current));
                            if (n2 > 255) {
                                this.lexerror("escape sequence too large", 286);
                            }
                            this.save(n2);
                            continue block16;
                        }
                    }
                    this.save(n2);
                    this.nextChar();
                    continue block16;
                }
            }
            this.save_and_next();
        }
        this.save_and_next();
        semInfo.ts = this.newstring(this.buff, 1, this.nbuff - 2);
    }

    int llex(SemInfo semInfo) {
        int n;
        this.nbuff = 0;
        block12: while (true) {
            switch (this.current) {
                case 10: 
                case 13: {
                    this.inclinenumber();
                    continue block12;
                }
                case 45: {
                    this.nextChar();
                    if (this.current != 45) {
                        return 45;
                    }
                    this.nextChar();
                    if (this.current == 91) {
                        n = this.skip_sep();
                        this.nbuff = 0;
                        if (n >= 0) {
                            this.read_long_string(null, n);
                            this.nbuff = 0;
                            continue block12;
                        }
                    }
                    while (true) {
                        if (this.currIsNewline() || this.current == -1) continue block12;
                        this.nextChar();
                    }
                }
                case 91: {
                    n = this.skip_sep();
                    if (n >= 0) {
                        this.read_long_string(semInfo, n);
                        return 286;
                    }
                    if (n == -1) {
                        return 91;
                    }
                    this.lexerror("invalid long string delimiter", 286);
                }
                case 61: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 61;
                    }
                    this.nextChar();
                    return 280;
                }
                case 60: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 60;
                    }
                    this.nextChar();
                    return 282;
                }
                case 62: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 62;
                    }
                    this.nextChar();
                    return 281;
                }
                case 126: {
                    this.nextChar();
                    if (this.current != 61) {
                        return 126;
                    }
                    this.nextChar();
                    return 283;
                }
                case 34: 
                case 39: {
                    this.read_string(this.current, semInfo);
                    return 286;
                }
                case 46: {
                    this.save_and_next();
                    if (this.check_next(".")) {
                        if (this.check_next(".")) {
                            return 279;
                        }
                        return 278;
                    }
                    if (!this.isdigit(this.current)) {
                        return 46;
                    }
                    this.read_numeral(semInfo);
                    return 284;
                }
                case -1: {
                    return 287;
                }
            }
            if (!this.isspace(this.current)) break;
            LuaC._assert(!this.currIsNewline());
            this.nextChar();
        }
        if (this.isdigit(this.current)) {
            this.read_numeral(semInfo);
            return 284;
        }
        if (this.isalpha(this.current) || this.current == 95) {
            do {
                this.save_and_next();
            } while (this.isalnum(this.current) || this.current == 95);
            LuaString luaString = this.newstring(this.buff, 0, this.nbuff);
            if (RESERVED.containsKey(luaString)) {
                return (Integer)RESERVED.get(luaString);
            }
            semInfo.ts = luaString;
            return 285;
        }
        n = this.current;
        this.nextChar();
        return n;
    }

    void next() {
        this.lastline = this.linenumber;
        if (this.lookahead.token != 287) {
            this.t.set(this.lookahead);
            this.lookahead.token = 287;
        } else {
            this.t.token = this.llex(this.t.seminfo);
        }
    }

    void lookahead() {
        LuaC._assert(this.lookahead.token == 287);
        this.lookahead.token = this.llex(this.lookahead.seminfo);
    }

    boolean hasmultret(int n) {
        return n == 13 || n == 14;
    }

    void error_expected(int n) {
        this.syntaxerror(this.L.pushfstring(LexState.LUA_QS(this.token2str(n)) + " expected"));
    }

    boolean testnext(int n) {
        if (this.t.token == n) {
            this.next();
            return true;
        }
        return false;
    }

    void check(int n) {
        if (this.t.token != n) {
            this.error_expected(n);
        }
    }

    void checknext(int n) {
        this.check(n);
        this.next();
    }

    void check_condition(boolean bl, String string) {
        if (!bl) {
            this.syntaxerror(string);
        }
    }

    void check_match(int n, int n2, int n3) {
        if (!this.testnext(n)) {
            if (n3 == this.linenumber) {
                this.error_expected(n);
            } else {
                this.syntaxerror(this.L.pushfstring(LexState.LUA_QS(this.token2str(n)) + " expected " + "(to close " + LexState.LUA_QS(this.token2str(n2)) + " at line " + n3 + ")"));
            }
        }
    }

    LuaString str_checkname() {
        this.check(285);
        LuaString luaString = this.t.seminfo.ts;
        this.next();
        return luaString;
    }

    void codestring(expdesc expdesc2, LuaString luaString) {
        expdesc2.init(4, this.fs.stringK(luaString));
    }

    void checkname(expdesc expdesc2) {
        this.codestring(expdesc2, this.str_checkname());
    }

    int registerlocalvar(LuaString luaString) {
        FuncState funcState = this.fs;
        Prototype prototype = funcState.f;
        if (prototype.locvars == null || funcState.nlocvars + 1 > prototype.locvars.length) {
            prototype.locvars = LuaC.realloc(prototype.locvars, funcState.nlocvars * 2 + 1);
        }
        prototype.locvars[funcState.nlocvars] = new LocVars(luaString, 0, 0);
        short s = funcState.nlocvars;
        funcState.nlocvars = (short)(s + 1);
        return s;
    }

    void new_localvarliteral(String string, int n) {
        LuaString luaString = this.newstring(string);
        this.new_localvar(luaString, n);
    }

    void new_localvar(LuaString luaString, int n) {
        FuncState funcState = this.fs;
        funcState.checklimit(funcState.nactvar + n + 1, 200, "local variables");
        funcState.actvar[funcState.nactvar + n] = (short)this.registerlocalvar(luaString);
    }

    void adjustlocalvars(int n) {
        FuncState funcState = this.fs;
        funcState.nactvar = (short)(funcState.nactvar + n);
        while (n > 0) {
            funcState.getlocvar((int)(funcState.nactvar - n)).startpc = funcState.pc;
            --n;
        }
    }

    void removevars(int n) {
        FuncState funcState = this.fs;
        while (funcState.nactvar > n) {
            funcState.nactvar = (short)(funcState.nactvar - 1);
            funcState.getlocvar((int)((short)(funcState.nactvar - 1))).endpc = funcState.pc;
        }
    }

    void singlevar(expdesc expdesc2) {
        FuncState funcState = this.fs;
        LuaString luaString = this.str_checkname();
        if (funcState.singlevaraux(luaString, expdesc2, 1) == 8) {
            expdesc2.u.s.info = funcState.stringK(luaString);
        }
    }

    void adjust_assign(int n, int n2, expdesc expdesc2) {
        FuncState funcState = this.fs;
        int n3 = n - n2;
        if (this.hasmultret(expdesc2.k)) {
            if (++n3 < 0) {
                n3 = 0;
            }
            funcState.setreturns(expdesc2, n3);
            if (n3 > 1) {
                funcState.reserveregs(n3 - 1);
            }
        } else {
            if (expdesc2.k != 0) {
                funcState.exp2nextreg(expdesc2);
            }
            if (n3 > 0) {
                int n4 = funcState.freereg;
                funcState.reserveregs(n3);
                funcState.nil(n4, n3);
            }
        }
    }

    void enterlevel() {
        if (++this.L.nCcalls > 200) {
            this.lexerror("chunk has too many syntax levels", 0);
        }
    }

    void leavelevel() {
        --this.L.nCcalls;
    }

    void pushclosure(FuncState funcState, expdesc expdesc2) {
        FuncState funcState2 = this.fs;
        Prototype prototype = funcState2.f;
        if (prototype.p == null || funcState2.np + 1 > prototype.p.length) {
            prototype.p = LuaC.realloc(prototype.p, funcState2.np * 2 + 1);
        }
        prototype.p[funcState2.np++] = funcState.f;
        expdesc2.init(11, funcState2.codeABx(36, 0, funcState2.np - 1));
        for (int i = 0; i < funcState.f.nups; ++i) {
            int n = funcState.upvalues[i].k == 6 ? 0 : 4;
            funcState2.codeABC(n, 0, funcState.upvalues[i].info, 0);
        }
    }

    void open_func(FuncState funcState) {
        LuaC luaC = this.L;
        Prototype prototype = new Prototype();
        if (this.fs != null) {
            prototype.source = this.fs.f.source;
        }
        funcState.f = prototype;
        funcState.prev = this.fs;
        funcState.ls = this;
        funcState.L = luaC;
        this.fs = funcState;
        funcState.pc = 0;
        funcState.lasttarget = -1;
        funcState.jpc = new IntPtr(-1);
        funcState.freereg = 0;
        funcState.nk = 0;
        funcState.np = 0;
        funcState.nlocvars = 0;
        funcState.nactvar = 0;
        funcState.bl = null;
        prototype.maxstacksize = 2;
        funcState.htable = new Hashtable();
    }

    void close_func() {
        FuncState funcState = this.fs;
        Prototype prototype = funcState.f;
        this.removevars(0);
        funcState.ret(0, 0);
        prototype.code = LuaC.realloc(prototype.code, funcState.pc);
        prototype.lineinfo = LuaC.realloc(prototype.lineinfo, funcState.pc);
        prototype.k = LuaC.realloc(prototype.k, funcState.nk);
        prototype.p = LuaC.realloc(prototype.p, funcState.np);
        prototype.locvars = LuaC.realloc(prototype.locvars, (int)funcState.nlocvars);
        prototype.upvalues = LuaC.realloc(prototype.upvalues, prototype.nups);
        LuaC._assert(funcState.bl == null);
        this.fs = funcState.prev;
    }

    void field(expdesc expdesc2) {
        FuncState funcState = this.fs;
        expdesc expdesc3 = new expdesc();
        funcState.exp2anyreg(expdesc2);
        this.next();
        this.checkname(expdesc3);
        funcState.indexed(expdesc2, expdesc3);
    }

    void yindex(expdesc expdesc2) {
        this.next();
        this.expr(expdesc2);
        this.fs.exp2val(expdesc2);
        this.checknext(93);
    }

    void recfield(ConsControl consControl) {
        FuncState funcState = this.fs;
        int n = this.fs.freereg;
        expdesc expdesc2 = new expdesc();
        expdesc expdesc3 = new expdesc();
        if (this.t.token == 285) {
            funcState.checklimit(consControl.nh, 0x7FFFFFFD, "items in a constructor");
            this.checkname(expdesc2);
        } else {
            this.yindex(expdesc2);
        }
        ++consControl.nh;
        this.checknext(61);
        int n2 = funcState.exp2RK(expdesc2);
        this.expr(expdesc3);
        funcState.codeABC(9, consControl.t.u.s.info, n2, funcState.exp2RK(expdesc3));
        funcState.freereg = n;
    }

    void listfield(ConsControl consControl) {
        this.expr(consControl.v);
        this.fs.checklimit(consControl.na, 0x7FFFFFFD, "items in a constructor");
        ++consControl.na;
        ++consControl.tostore;
    }

    void constructor(expdesc expdesc2) {
        FuncState funcState = this.fs;
        int n = this.linenumber;
        int n2 = funcState.codeABC(10, 0, 0, 0);
        ConsControl consControl = new ConsControl();
        consControl.tostore = 0;
        consControl.nh = 0;
        consControl.na = 0;
        consControl.t = expdesc2;
        expdesc2.init(11, n2);
        consControl.v.init(0, 0);
        funcState.exp2nextreg(expdesc2);
        this.checknext(123);
        do {
            LuaC._assert(consControl.v.k == 0 || consControl.tostore > 0);
            if (this.t.token == 125) break;
            funcState.closelistfield(consControl);
            switch (this.t.token) {
                case 285: {
                    this.lookahead();
                    if (this.lookahead.token != 61) {
                        this.listfield(consControl);
                        break;
                    }
                    this.recfield(consControl);
                    break;
                }
                case 91: {
                    this.recfield(consControl);
                    break;
                }
                default: {
                    this.listfield(consControl);
                }
            }
        } while (this.testnext(44) || this.testnext(59));
        this.check_match(125, 123, n);
        funcState.lastlistfield(consControl);
        InstructionPtr instructionPtr = new InstructionPtr(funcState.f.code, n2);
        LuaC.SETARG_B(instructionPtr, LexState.luaO_int2fb(consControl.na));
        LuaC.SETARG_C(instructionPtr, LexState.luaO_int2fb(consControl.nh));
    }

    static int luaO_int2fb(int n) {
        int n2 = 0;
        while (n >= 16) {
            n = n + 1 >> 1;
            ++n2;
        }
        if (n < 8) {
            return n;
        }
        return n2 + 1 << 3 | n - 8;
    }

    void parlist() {
        FuncState funcState = this.fs;
        Prototype prototype = funcState.f;
        int n = 0;
        prototype.is_vararg = 0;
        if (this.t.token != 41) {
            do {
                switch (this.t.token) {
                    case 285: {
                        this.new_localvar(this.str_checkname(), n++);
                        break;
                    }
                    case 279: {
                        this.next();
                        this.new_localvarliteral("arg", n++);
                        prototype.is_vararg = 5;
                        prototype.is_vararg |= 2;
                        break;
                    }
                    default: {
                        this.syntaxerror("<name> or " + LexState.LUA_QL("...") + " expected");
                    }
                }
            } while (prototype.is_vararg == 0 && this.testnext(44));
        }
        this.adjustlocalvars(n);
        prototype.numparams = funcState.nactvar - (prototype.is_vararg & 1);
        funcState.reserveregs(funcState.nactvar);
    }

    void body(expdesc expdesc2, boolean bl, int n) {
        FuncState funcState = new FuncState();
        this.open_func(funcState);
        funcState.f.linedefined = n;
        this.checknext(40);
        if (bl) {
            this.new_localvarliteral("self", 0);
            this.adjustlocalvars(1);
        }
        this.parlist();
        this.checknext(41);
        this.chunk();
        funcState.f.lastlinedefined = this.linenumber;
        this.check_match(262, 265, n);
        this.close_func();
        this.pushclosure(funcState, expdesc2);
    }

    int explist1(expdesc expdesc2) {
        int n = 1;
        this.expr(expdesc2);
        while (this.testnext(44)) {
            this.fs.exp2nextreg(expdesc2);
            this.expr(expdesc2);
            ++n;
        }
        return n;
    }

    void funcargs(expdesc expdesc2) {
        int n;
        FuncState funcState = this.fs;
        expdesc expdesc3 = new expdesc();
        int n2 = this.linenumber;
        switch (this.t.token) {
            case 40: {
                if (n2 != this.lastline) {
                    this.syntaxerror("ambiguous syntax (function call x new statement)");
                }
                this.next();
                if (this.t.token == 41) {
                    expdesc3.k = 0;
                } else {
                    this.explist1(expdesc3);
                    funcState.setmultret(expdesc3);
                }
                this.check_match(41, 40, n2);
                break;
            }
            case 123: {
                this.constructor(expdesc3);
                break;
            }
            case 286: {
                this.codestring(expdesc3, this.t.seminfo.ts);
                this.next();
                break;
            }
            default: {
                this.syntaxerror("function arguments expected");
                return;
            }
        }
        LuaC._assert(expdesc2.k == 12);
        int n3 = expdesc2.u.s.info;
        if (this.hasmultret(expdesc3.k)) {
            n = -1;
        } else {
            if (expdesc3.k != 0) {
                funcState.exp2nextreg(expdesc3);
            }
            n = funcState.freereg - (n3 + 1);
        }
        expdesc2.init(13, funcState.codeABC(28, n3, n + 1, 2));
        funcState.fixline(n2);
        funcState.freereg = n3 + 1;
    }

    void prefixexp(expdesc expdesc2) {
        switch (this.t.token) {
            case 40: {
                int n = this.linenumber;
                this.next();
                this.expr(expdesc2);
                this.check_match(41, 40, n);
                this.fs.dischargevars(expdesc2);
                return;
            }
            case 285: {
                this.singlevar(expdesc2);
                return;
            }
        }
        this.syntaxerror("unexpected symbol");
    }

    void primaryexp(expdesc expdesc2) {
        FuncState funcState = this.fs;
        this.prefixexp(expdesc2);
        block6: while (true) {
            switch (this.t.token) {
                case 46: {
                    this.field(expdesc2);
                    continue block6;
                }
                case 91: {
                    expdesc expdesc3 = new expdesc();
                    funcState.exp2anyreg(expdesc2);
                    this.yindex(expdesc3);
                    funcState.indexed(expdesc2, expdesc3);
                    continue block6;
                }
                case 58: {
                    expdesc expdesc3 = new expdesc();
                    this.next();
                    this.checkname(expdesc3);
                    funcState.self(expdesc2, expdesc3);
                    this.funcargs(expdesc2);
                    continue block6;
                }
                case 40: 
                case 123: 
                case 286: {
                    funcState.exp2nextreg(expdesc2);
                    this.funcargs(expdesc2);
                    continue block6;
                }
            }
            break;
        }
    }

    void simpleexp(expdesc expdesc2) {
        switch (this.t.token) {
            case 284: {
                expdesc2.init(5, 0);
                expdesc2.u.setNval(this.t.seminfo.r);
                break;
            }
            case 286: {
                this.codestring(expdesc2, this.t.seminfo.ts);
                break;
            }
            case 269: {
                expdesc2.init(1, 0);
                break;
            }
            case 275: {
                expdesc2.init(2, 0);
                break;
            }
            case 263: {
                expdesc2.init(3, 0);
                break;
            }
            case 279: {
                FuncState funcState = this.fs;
                this.check_condition(funcState.f.is_vararg != 0, "cannot use " + LexState.LUA_QL("...") + " outside a vararg function");
                funcState.f.is_vararg &= 0xFFFFFFFB;
                expdesc2.init(14, funcState.codeABC(37, 0, 1, 0));
                break;
            }
            case 123: {
                this.constructor(expdesc2);
                return;
            }
            case 265: {
                this.next();
                this.body(expdesc2, false, this.linenumber);
                return;
            }
            default: {
                this.primaryexp(expdesc2);
                return;
            }
        }
        this.next();
    }

    int getunopr(int n) {
        switch (n) {
            case 270: {
                return 1;
            }
            case 45: {
                return 0;
            }
            case 35: {
                return 2;
            }
        }
        return 3;
    }

    int getbinopr(int n) {
        switch (n) {
            case 43: {
                return 0;
            }
            case 45: {
                return 1;
            }
            case 42: {
                return 2;
            }
            case 47: {
                return 3;
            }
            case 37: {
                return 4;
            }
            case 94: {
                return 5;
            }
            case 278: {
                return 6;
            }
            case 283: {
                return 7;
            }
            case 280: {
                return 8;
            }
            case 60: {
                return 9;
            }
            case 282: {
                return 10;
            }
            case 62: {
                return 11;
            }
            case 281: {
                return 12;
            }
            case 257: {
                return 13;
            }
            case 271: {
                return 14;
            }
        }
        return 15;
    }

    int subexpr(expdesc expdesc2, int n) {
        this.enterlevel();
        int n2 = this.getunopr(this.t.token);
        if (n2 != 3) {
            this.next();
            this.subexpr(expdesc2, 8);
            this.fs.prefix(n2, expdesc2);
        } else {
            this.simpleexp(expdesc2);
        }
        int n3 = this.getbinopr(this.t.token);
        while (n3 != 15 && LexState.priority[n3].left > n) {
            expdesc expdesc3 = new expdesc();
            this.next();
            this.fs.infix(n3, expdesc2);
            int n4 = this.subexpr(expdesc3, LexState.priority[n3].right);
            this.fs.posfix(n3, expdesc2, expdesc3);
            n3 = n4;
        }
        this.leavelevel();
        return n3;
    }

    void expr(expdesc expdesc2) {
        this.subexpr(expdesc2, 0);
    }

    boolean block_follow(int n) {
        switch (n) {
            case 260: 
            case 261: 
            case 262: 
            case 276: 
            case 287: {
                return true;
            }
        }
        return false;
    }

    void block() {
        FuncState funcState = this.fs;
        FuncState.BlockCnt blockCnt = new FuncState.BlockCnt();
        funcState.enterblock(blockCnt, false);
        this.chunk();
        LuaC._assert(blockCnt.breaklist.i == -1);
        funcState.leaveblock();
    }

    void check_conflict(LHS_assign lHS_assign, expdesc expdesc2) {
        FuncState funcState = this.fs;
        int n = funcState.freereg;
        boolean bl = false;
        while (lHS_assign != null) {
            if (lHS_assign.v.k == 9) {
                if (lHS_assign.v.u.s.info == expdesc2.u.s.info) {
                    bl = true;
                    lHS_assign.v.u.s.info = n;
                }
                if (lHS_assign.v.u.s.aux == expdesc2.u.s.info) {
                    bl = true;
                    lHS_assign.v.u.s.aux = n;
                }
            }
            lHS_assign = lHS_assign.prev;
        }
        if (bl) {
            funcState.codeABC(0, funcState.freereg, expdesc2.u.s.info, 0);
            funcState.reserveregs(1);
        }
    }

    void assignment(LHS_assign lHS_assign, int n) {
        expdesc expdesc2 = new expdesc();
        this.check_condition(6 <= lHS_assign.v.k && lHS_assign.v.k <= 9, "syntax error");
        if (this.testnext(44)) {
            LHS_assign lHS_assign2 = new LHS_assign();
            lHS_assign2.prev = lHS_assign;
            this.primaryexp(lHS_assign2.v);
            if (lHS_assign2.v.k == 6) {
                this.check_conflict(lHS_assign, lHS_assign2.v);
            }
            this.assignment(lHS_assign2, n + 1);
        } else {
            this.checknext(61);
            int n2 = this.explist1(expdesc2);
            if (n2 != n) {
                this.adjust_assign(n, n2, expdesc2);
                if (n2 > n) {
                    this.fs.freereg -= n2 - n;
                }
            } else {
                this.fs.setoneret(expdesc2);
                this.fs.storevar(lHS_assign.v, expdesc2);
                return;
            }
        }
        expdesc2.init(12, this.fs.freereg - 1);
        this.fs.storevar(lHS_assign.v, expdesc2);
    }

    int cond() {
        expdesc expdesc2 = new expdesc();
        this.expr(expdesc2);
        if (expdesc2.k == 1) {
            expdesc2.k = 3;
        }
        this.fs.goiftrue(expdesc2);
        return expdesc2.f.i;
    }

    void breakstat() {
        FuncState funcState = this.fs;
        FuncState.BlockCnt blockCnt = funcState.bl;
        boolean bl = false;
        while (blockCnt != null && !blockCnt.isbreakable) {
            bl |= blockCnt.upval;
            blockCnt = blockCnt.previous;
        }
        if (blockCnt == null) {
            this.syntaxerror("no loop to break");
        }
        if (bl) {
            funcState.codeABC(35, blockCnt.nactvar, 0, 0);
        }
        funcState.concat(blockCnt.breaklist, funcState.jump());
    }

    void whilestat(int n) {
        FuncState funcState = this.fs;
        FuncState.BlockCnt blockCnt = new FuncState.BlockCnt();
        this.next();
        int n2 = funcState.getlabel();
        int n3 = this.cond();
        funcState.enterblock(blockCnt, true);
        this.checknext(259);
        this.block();
        funcState.patchlist(funcState.jump(), n2);
        this.check_match(262, 277, n);
        funcState.leaveblock();
        funcState.patchtohere(n3);
    }

    void repeatstat(int n) {
        FuncState funcState = this.fs;
        int n2 = funcState.getlabel();
        FuncState.BlockCnt blockCnt = new FuncState.BlockCnt();
        FuncState.BlockCnt blockCnt2 = new FuncState.BlockCnt();
        funcState.enterblock(blockCnt, true);
        funcState.enterblock(blockCnt2, false);
        this.next();
        this.chunk();
        this.check_match(276, 272, n);
        int n3 = this.cond();
        if (!blockCnt2.upval) {
            funcState.leaveblock();
            funcState.patchlist(n3, n2);
        } else {
            this.breakstat();
            funcState.patchtohere(n3);
            funcState.leaveblock();
            funcState.patchlist(funcState.jump(), n2);
        }
        funcState.leaveblock();
    }

    int exp1() {
        expdesc expdesc2 = new expdesc();
        this.expr(expdesc2);
        int n = expdesc2.k;
        this.fs.exp2nextreg(expdesc2);
        return n;
    }

    void forbody(int n, int n2, int n3, boolean bl) {
        FuncState.BlockCnt blockCnt = new FuncState.BlockCnt();
        FuncState funcState = this.fs;
        this.adjustlocalvars(3);
        this.checknext(259);
        int n4 = bl ? funcState.codeAsBx(32, n, -1) : funcState.jump();
        funcState.enterblock(blockCnt, false);
        this.adjustlocalvars(n3);
        funcState.reserveregs(n3);
        this.block();
        funcState.leaveblock();
        funcState.patchtohere(n4);
        int n5 = bl ? funcState.codeAsBx(31, n, -1) : funcState.codeABC(33, n, 0, n3);
        funcState.fixline(n2);
        funcState.patchlist(bl ? n5 : funcState.jump(), n4 + 1);
    }

    void fornum(LuaString luaString, int n) {
        FuncState funcState = this.fs;
        int n2 = funcState.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_INDEX, 0);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_LIMIT, 1);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STEP, 2);
        this.new_localvar(luaString, 3);
        this.checknext(61);
        this.exp1();
        this.checknext(44);
        this.exp1();
        if (this.testnext(44)) {
            this.exp1();
        } else {
            funcState.codeABx(1, funcState.freereg, funcState.numberK(LuaInteger.valueOf(1)));
            funcState.reserveregs(1);
        }
        this.forbody(n2, n, 1, true);
    }

    void forlist(LuaString luaString) {
        FuncState funcState = this.fs;
        expdesc expdesc2 = new expdesc();
        int n = 0;
        int n2 = funcState.freereg;
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_GENERATOR, n++);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_STATE, n++);
        this.new_localvarliteral(RESERVED_LOCAL_VAR_FOR_CONTROL, n++);
        this.new_localvar(luaString, n++);
        while (this.testnext(44)) {
            this.new_localvar(this.str_checkname(), n++);
        }
        this.checknext(267);
        int n3 = this.linenumber;
        this.adjust_assign(3, this.explist1(expdesc2), expdesc2);
        funcState.checkstack(3);
        this.forbody(n2, n3, n - 3, false);
    }

    void forstat(int n) {
        FuncState funcState = this.fs;
        FuncState.BlockCnt blockCnt = new FuncState.BlockCnt();
        funcState.enterblock(blockCnt, true);
        this.next();
        LuaString luaString = this.str_checkname();
        switch (this.t.token) {
            case 61: {
                this.fornum(luaString, n);
                break;
            }
            case 44: 
            case 267: {
                this.forlist(luaString);
                break;
            }
            default: {
                this.syntaxerror(LexState.LUA_QL("=") + " or " + LexState.LUA_QL("in") + " expected");
            }
        }
        this.check_match(262, 264, n);
        funcState.leaveblock();
    }

    int test_then_block() {
        this.next();
        int n = this.cond();
        this.checknext(274);
        this.block();
        return n;
    }

    void ifstat(int n) {
        FuncState funcState = this.fs;
        IntPtr intPtr = new IntPtr(-1);
        int n2 = this.test_then_block();
        while (this.t.token == 261) {
            funcState.concat(intPtr, funcState.jump());
            funcState.patchtohere(n2);
            n2 = this.test_then_block();
        }
        if (this.t.token == 260) {
            funcState.concat(intPtr, funcState.jump());
            funcState.patchtohere(n2);
            this.next();
            this.block();
        } else {
            funcState.concat(intPtr, n2);
        }
        funcState.patchtohere(intPtr.i);
        this.check_match(262, 266, n);
    }

    void localfunc() {
        expdesc expdesc2 = new expdesc();
        expdesc expdesc3 = new expdesc();
        FuncState funcState = this.fs;
        this.new_localvar(this.str_checkname(), 0);
        expdesc2.init(6, funcState.freereg);
        funcState.reserveregs(1);
        this.adjustlocalvars(1);
        this.body(expdesc3, false, this.linenumber);
        funcState.storevar(expdesc2, expdesc3);
        funcState.getlocvar((int)(funcState.nactvar - 1)).startpc = funcState.pc;
    }

    void localstat() {
        int n;
        int n2 = 0;
        expdesc expdesc2 = new expdesc();
        do {
            this.new_localvar(this.str_checkname(), n2++);
        } while (this.testnext(44));
        if (this.testnext(61)) {
            n = this.explist1(expdesc2);
        } else {
            expdesc2.k = 0;
            n = 0;
        }
        this.adjust_assign(n2, n, expdesc2);
        this.adjustlocalvars(n2);
    }

    boolean funcname(expdesc expdesc2) {
        boolean bl = false;
        this.singlevar(expdesc2);
        while (this.t.token == 46) {
            this.field(expdesc2);
        }
        if (this.t.token == 58) {
            bl = true;
            this.field(expdesc2);
        }
        return bl;
    }

    void funcstat(int n) {
        expdesc expdesc2 = new expdesc();
        expdesc expdesc3 = new expdesc();
        this.next();
        boolean bl = this.funcname(expdesc2);
        this.body(expdesc3, bl, n);
        this.fs.storevar(expdesc2, expdesc3);
        this.fs.fixline(n);
    }

    void exprstat() {
        FuncState funcState = this.fs;
        LHS_assign lHS_assign = new LHS_assign();
        this.primaryexp(lHS_assign.v);
        if (lHS_assign.v.k == 13) {
            LuaC.SETARG_C(funcState.getcodePtr(lHS_assign.v), 1);
        } else {
            lHS_assign.prev = null;
            this.assignment(lHS_assign, 1);
        }
    }

    void retstat() {
        int n;
        int n2;
        FuncState funcState = this.fs;
        expdesc expdesc2 = new expdesc();
        this.next();
        if (this.block_follow(this.t.token) || this.t.token == 59) {
            n2 = 0;
            n = 0;
        } else {
            n2 = this.explist1(expdesc2);
            if (this.hasmultret(expdesc2.k)) {
                funcState.setmultret(expdesc2);
                if (expdesc2.k == 13 && n2 == 1) {
                    LuaC.SET_OPCODE(funcState.getcodePtr(expdesc2), 29);
                    LuaC._assert(Lua.GETARG_A(funcState.getcode(expdesc2)) == funcState.nactvar);
                }
                n = funcState.nactvar;
                n2 = -1;
            } else if (n2 == 1) {
                n = funcState.exp2anyreg(expdesc2);
            } else {
                funcState.exp2nextreg(expdesc2);
                n = funcState.nactvar;
                LuaC._assert(n2 == funcState.freereg - n);
            }
        }
        funcState.ret(n, n2);
    }

    boolean statement() {
        int n = this.linenumber;
        switch (this.t.token) {
            case 266: {
                this.ifstat(n);
                return false;
            }
            case 277: {
                this.whilestat(n);
                return false;
            }
            case 259: {
                this.next();
                this.block();
                this.check_match(262, 259, n);
                return false;
            }
            case 264: {
                this.forstat(n);
                return false;
            }
            case 272: {
                this.repeatstat(n);
                return false;
            }
            case 265: {
                this.funcstat(n);
                return false;
            }
            case 268: {
                this.next();
                if (this.testnext(265)) {
                    this.localfunc();
                } else {
                    this.localstat();
                }
                return false;
            }
            case 273: {
                this.retstat();
                return true;
            }
            case 258: {
                this.next();
                this.breakstat();
                return true;
            }
        }
        this.exprstat();
        return false;
    }

    void chunk() {
        boolean bl = false;
        this.enterlevel();
        while (!bl && !this.block_follow(this.t.token)) {
            bl = this.statement();
            this.testnext(59);
            LuaC._assert(this.fs.f.maxstacksize >= this.fs.freereg && this.fs.freereg >= this.fs.nactvar);
            this.fs.freereg = this.fs.nactvar;
        }
        this.leavelevel();
    }

    static {
        int n;
        RESERVED_LOCAL_VAR_KEYWORDS = new String[]{RESERVED_LOCAL_VAR_FOR_CONTROL, RESERVED_LOCAL_VAR_FOR_GENERATOR, RESERVED_LOCAL_VAR_FOR_INDEX, RESERVED_LOCAL_VAR_FOR_LIMIT, RESERVED_LOCAL_VAR_FOR_STATE, RESERVED_LOCAL_VAR_FOR_STEP};
        RESERVED_LOCAL_VAR_KEYWORDS_TABLE = new Hashtable();
        for (n = 0; n < RESERVED_LOCAL_VAR_KEYWORDS.length; ++n) {
            RESERVED_LOCAL_VAR_KEYWORDS_TABLE.put(RESERVED_LOCAL_VAR_KEYWORDS[n], Boolean.TRUE);
        }
        luaX_tokens = new String[]{"and", "break", "do", "else", "elseif", "end", "false", "for", "function", "if", "in", "local", "nil", "not", "or", "repeat", "return", "then", "true", "until", "while", "..", "...", "==", ">=", "<=", "~=", "<number>", "<name>", "<string>", "<eof>"};
        RESERVED = new Hashtable();
        for (n = 0; n < 21; ++n) {
            LuaString luaString = LuaValue.valueOf(luaX_tokens[n]);
            RESERVED.put(luaString, new Integer(257 + n));
        }
        priority = new Priority[]{new Priority(6, 6), new Priority(6, 6), new Priority(7, 7), new Priority(7, 7), new Priority(7, 7), new Priority(10, 9), new Priority(5, 4), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(3, 3), new Priority(2, 2), new Priority(1, 1)};
    }

    static class LHS_assign {
        LHS_assign prev;
        expdesc v = new expdesc();

        LHS_assign() {
        }
    }

    static class Priority {
        final byte left;
        final byte right;

        public Priority(int n, int n2) {
            this.left = (byte)n;
            this.right = (byte)n2;
        }
    }

    static class ConsControl {
        expdesc v = new expdesc();
        expdesc t;
        int nh;
        int na;
        int tostore;

        ConsControl() {
        }
    }

    static class expdesc {
        int k;
        final U u = new U();
        final IntPtr t = new IntPtr();
        final IntPtr f = new IntPtr();

        expdesc() {
        }

        void init(int n, int n2) {
            this.f.i = -1;
            this.t.i = -1;
            this.k = n;
            this.u.s.info = n2;
        }

        boolean hasjumps() {
            return this.t.i != this.f.i;
        }

        boolean isnumeral() {
            return this.k == 5 && this.t.i == -1 && this.f.i == -1;
        }

        public void setvalue(expdesc expdesc2) {
            this.k = expdesc2.k;
            this.u._nval = expdesc2.u._nval;
            this.u.s.info = expdesc2.u.s.info;
            this.u.s.aux = expdesc2.u.s.aux;
            this.t.i = expdesc2.t.i;
            this.f.i = expdesc2.f.i;
        }

        static class U {
            final S s = new S();
            private LuaValue _nval;

            U() {
            }

            public void setNval(LuaValue luaValue) {
                this._nval = luaValue;
            }

            public LuaValue nval() {
                return this._nval == null ? LuaInteger.valueOf(this.s.info) : this._nval;
            }

            static class S {
                int info;
                int aux;

                S() {
                }
            }
        }
    }

    private static class Token {
        int token;
        final SemInfo seminfo = new SemInfo();

        private Token() {
        }

        public void set(Token token) {
            this.token = token.token;
            this.seminfo.r = token.seminfo.r;
            this.seminfo.ts = token.seminfo.ts;
        }
    }

    private static class SemInfo {
        LuaValue r;
        LuaString ts;

        private SemInfo() {
        }
    }
}

