/*
 * Decompiled with CFR 0.152.
 */
package org.luaj.vm2.lib;

import java.lang.ref.WeakReference;
import org.luaj.vm2.Lua;
import org.luaj.vm2.LuaBoolean;
import org.luaj.vm2.LuaClosure;
import org.luaj.vm2.LuaError;
import org.luaj.vm2.LuaFunction;
import org.luaj.vm2.LuaNil;
import org.luaj.vm2.LuaNumber;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaThread;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Print;
import org.luaj.vm2.Prototype;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.PackageLib;
import org.luaj.vm2.lib.VarArgFunction;

public class DebugLib
extends VarArgFunction {
    public static final boolean CALLS = null != System.getProperty("CALLS");
    public static final boolean TRACE = null != System.getProperty("TRACE");
    public static boolean DEBUG_ENABLED;
    static final String[] NAMES;
    private static final int INIT = 0;
    private static final int DEBUG = 1;
    private static final int GETFENV = 2;
    private static final int GETHOOK = 3;
    private static final int GETINFO = 4;
    private static final int GETLOCAL = 5;
    private static final int GETMETATABLE = 6;
    private static final int GETREGISTRY = 7;
    private static final int GETUPVALUE = 8;
    private static final int SETFENV = 9;
    private static final int SETHOOK = 10;
    private static final int SETLOCAL = 11;
    private static final int SETMETATABLE = 12;
    private static final int SETUPVALUE = 13;
    private static final int TRACEBACK = 14;
    private static final int MAXSTACK = 250;
    private static final LuaString LUA;
    private static final LuaString JAVA;
    private static final LuaString QMARK;
    private static final LuaString GLOBAL;
    private static final LuaString LOCAL;
    private static final LuaString METHOD;
    private static final LuaString UPVALUE;
    private static final LuaString FIELD;
    private static final LuaString CALL;
    private static final LuaString LINE;
    private static final LuaString COUNT;
    private static final LuaString RETURN;
    private static final LuaString TAILRETURN;
    private static final LuaString FUNC;
    private static final LuaString NUPS;
    private static final LuaString NAME;
    private static final LuaString NAMEWHAT;
    private static final LuaString WHAT;
    private static final LuaString SOURCE;
    private static final LuaString SHORT_SRC;
    private static final LuaString LINEDEFINED;
    private static final LuaString LASTLINEDEFINED;
    private static final LuaString CURRENTLINE;
    private static final LuaString ACTIVELINES;
    static /* synthetic */ Class class$org$luaj$vm2$lib$DebugLib;

    private LuaTable init() {
        DEBUG_ENABLED = true;
        LuaTable luaTable = new LuaTable();
        this.bind(luaTable, class$org$luaj$vm2$lib$DebugLib == null ? (class$org$luaj$vm2$lib$DebugLib = DebugLib.class$("org.luaj.vm2.lib.DebugLib")) : class$org$luaj$vm2$lib$DebugLib, NAMES, 1);
        this.env.set("debug", (LuaValue)luaTable);
        PackageLib.instance.LOADED.set("debug", (LuaValue)luaTable);
        return luaTable;
    }

    public Varargs invoke(Varargs varargs) {
        switch (this.opcode) {
            case 0: {
                return this.init();
            }
            case 1: {
                return DebugLib._debug(varargs);
            }
            case 2: {
                return DebugLib._getfenv(varargs);
            }
            case 3: {
                return DebugLib._gethook(varargs);
            }
            case 4: {
                return DebugLib._getinfo(varargs, this);
            }
            case 5: {
                return DebugLib._getlocal(varargs);
            }
            case 6: {
                return DebugLib._getmetatable(varargs);
            }
            case 7: {
                return DebugLib._getregistry(varargs);
            }
            case 8: {
                return DebugLib._getupvalue(varargs);
            }
            case 9: {
                return DebugLib._setfenv(varargs);
            }
            case 10: {
                return DebugLib._sethook(varargs);
            }
            case 11: {
                return DebugLib._setlocal(varargs);
            }
            case 12: {
                return DebugLib._setmetatable(varargs);
            }
            case 13: {
                return DebugLib._setupvalue(varargs);
            }
            case 14: {
                return DebugLib._traceback(varargs);
            }
        }
        return NONE;
    }

    static DebugState getDebugState(LuaThread luaThread) {
        if (luaThread.debugState == null) {
            luaThread.debugState = new DebugState(luaThread);
        }
        return (DebugState)luaThread.debugState;
    }

    static DebugState getDebugState() {
        return DebugLib.getDebugState(LuaThread.getRunning());
    }

    public static void debugSetupCall(Varargs varargs, LuaValue[] luaValueArray) {
        DebugState debugState = DebugLib.getDebugState();
        if (debugState.inhook) {
            return;
        }
        debugState.nextInfo().setargs(varargs, luaValueArray);
    }

    public static void debugOnCall(LuaThread luaThread, int n, LuaFunction luaFunction) {
        DebugState debugState = DebugLib.getDebugState();
        if (debugState.inhook) {
            return;
        }
        DebugInfo debugInfo = debugState.pushInfo(n);
        debugInfo.setfunction(luaFunction);
        if (CALLS) {
            System.out.println("calling " + luaFunction);
        }
        if (debugState.hookcall) {
            debugState.callHookFunc(debugState, CALL, LuaValue.NIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debugOnReturn(LuaThread luaThread, int n) {
        DebugState debugState = DebugLib.getDebugState(luaThread);
        if (debugState.inhook) {
            return;
        }
        if (CALLS) {
            System.out.println("returning");
        }
        try {
            if (debugState.hookrtrn) {
                debugState.callHookFunc(debugState, RETURN, LuaValue.NIL);
            }
        }
        finally {
            DebugLib.getDebugState().popInfo(n);
        }
    }

    public static void debugBytecode(int n, Varargs varargs, int n2) {
        int n3;
        int n4;
        DebugState debugState = DebugLib.getDebugState();
        if (debugState.inhook) {
            return;
        }
        DebugInfo debugInfo = debugState.getDebugInfo();
        if (TRACE) {
            Print.printState(debugInfo.closure, n, debugInfo.stack, n2, debugInfo.varargs);
        }
        debugInfo.bytecode(n, varargs, n2);
        if (debugState.hookcount > 0 && ++debugState.hookcodes >= debugState.hookcount) {
            debugState.hookcodes = 0;
            debugState.callHookFunc(debugState, COUNT, LuaValue.NIL);
        }
        if (debugState.hookline && (n4 = debugInfo.currentline()) != debugState.line && (((n3 = debugInfo.closure.p.code[n]) & 0x3F) != 22 || (n3 >>> 14) - 131071 >= 0)) {
            debugState.line = n4;
            debugState.callHookFunc(debugState, LINE, LuaValue.valueOf(n4));
        }
    }

    static Varargs _debug(Varargs varargs) {
        return NONE;
    }

    static Varargs _gethook(Varargs varargs) {
        int n = 1;
        LuaThread luaThread = varargs.isthread(n) ? varargs.checkthread(n++) : LuaThread.getRunning();
        DebugState debugState = DebugLib.getDebugState(luaThread);
        return DebugLib.varargsOf(debugState.hookfunc, DebugLib.valueOf((debugState.hookcall ? "c" : "") + (debugState.hookline ? "l" : "") + (debugState.hookrtrn ? "r" : "")), DebugLib.valueOf(debugState.hookcount));
    }

    static Varargs _sethook(Varargs varargs) {
        int n = 1;
        LuaThread luaThread = varargs.isthread(n) ? varargs.checkthread(n++) : LuaThread.getRunning();
        LuaFunction luaFunction = varargs.optfunction(n++, null);
        String string = varargs.optjstring(n++, "");
        int n2 = varargs.optint(n++, 0);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        block5: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case 'c': {
                    bl = true;
                    continue block5;
                }
                case 'l': {
                    bl2 = true;
                    continue block5;
                }
                case 'r': {
                    bl3 = true;
                }
            }
        }
        DebugLib.getDebugState(luaThread).sethook(luaFunction, bl, bl2, bl3, n2);
        return NONE;
    }

    static Varargs _getfenv(Varargs varargs) {
        LuaValue luaValue = varargs.arg1();
        LuaValue luaValue2 = luaValue.getfenv();
        return luaValue2 != null ? luaValue2 : LuaValue.NIL;
    }

    static Varargs _setfenv(Varargs varargs) {
        LuaValue luaValue = varargs.arg1();
        LuaTable luaTable = varargs.checktable(2);
        luaValue.setfenv(luaTable);
        return luaValue;
    }

    protected static Varargs _getinfo(Varargs varargs, LuaValue luaValue) {
        int n;
        int n2 = 1;
        LuaThread luaThread = varargs.isthread(n2) ? varargs.checkthread(n2++) : LuaThread.getRunning();
        LuaValue luaValue2 = varargs.arg(n2++);
        String string = varargs.optjstring(n2++, "nSluf");
        DebugState debugState = DebugLib.getDebugState(luaThread);
        DebugInfo debugInfo = null;
        debugInfo = luaValue2.isnumber() ? ((n = luaValue2.checkint()) > 0 ? debugState.getDebugInfo(n - 1) : new DebugInfo(luaValue)) : debugState.findDebugInfo(luaValue2.checkfunction());
        if (debugInfo == null) {
            return NIL;
        }
        LuaTable luaTable = new LuaTable();
        LuaClosure luaClosure = debugInfo.closure;
        int n3 = string.length();
        block8: for (int i = 0; i < n3; ++i) {
            switch (string.charAt(i)) {
                case 'S': {
                    if (luaClosure != null) {
                        Prototype prototype = luaClosure.p;
                        luaTable.set(WHAT, (LuaValue)LUA);
                        luaTable.set(SOURCE, (LuaValue)prototype.source);
                        luaTable.set(SHORT_SRC, (LuaValue)DebugLib.valueOf(DebugLib.sourceshort(prototype)));
                        luaTable.set(LINEDEFINED, (LuaValue)DebugLib.valueOf(prototype.linedefined));
                        luaTable.set(LASTLINEDEFINED, (LuaValue)DebugLib.valueOf(prototype.lastlinedefined));
                        continue block8;
                    }
                    String string2 = debugInfo.func.tojstring();
                    LuaString luaString = LuaString.valueOf("[Java] " + string2);
                    luaTable.set(WHAT, (LuaValue)JAVA);
                    luaTable.set(SOURCE, (LuaValue)luaString);
                    luaTable.set(SHORT_SRC, (LuaValue)DebugLib.valueOf(string2));
                    luaTable.set(LINEDEFINED, (LuaValue)LuaValue.MINUSONE);
                    luaTable.set(LASTLINEDEFINED, (LuaValue)LuaValue.MINUSONE);
                    continue block8;
                }
                case 'l': {
                    int n4 = debugInfo.currentline();
                    luaTable.set(CURRENTLINE, (LuaValue)DebugLib.valueOf(n4));
                    continue block8;
                }
                case 'u': {
                    luaTable.set(NUPS, (LuaValue)DebugLib.valueOf(luaClosure != null ? luaClosure.p.nups : 0));
                    continue block8;
                }
                case 'n': {
                    LuaString[] luaStringArray = debugInfo.getfunckind();
                    luaTable.set(NAME, (LuaValue)(luaStringArray != null ? luaStringArray[0] : QMARK));
                    luaTable.set(NAMEWHAT, (LuaValue)(luaStringArray != null ? luaStringArray[1] : EMPTYSTRING));
                    continue block8;
                }
                case 'f': {
                    luaTable.set(FUNC, debugInfo.func);
                    continue block8;
                }
                case 'L': {
                    LuaTable luaTable2 = new LuaTable();
                    luaTable.set(ACTIVELINES, (LuaValue)luaTable2);
                    continue block8;
                }
            }
        }
        return luaTable;
    }

    public static String sourceshort(Prototype prototype) {
        String string = prototype.source.tojstring();
        if (string.startsWith("@") || string.startsWith("=")) {
            string = string.substring(1);
        } else if (string.startsWith("\u001b")) {
            string = "binary string";
        }
        return string;
    }

    static Varargs _getlocal(Varargs varargs) {
        LuaString luaString;
        int n = 1;
        LuaThread luaThread = varargs.isthread(n) ? varargs.checkthread(n++) : LuaThread.getRunning();
        int n2 = varargs.checkint(n++);
        int n3 = varargs.checkint(n++);
        DebugState debugState = DebugLib.getDebugState(luaThread);
        DebugInfo debugInfo = debugState.getDebugInfo(n2 - 1);
        LuaString luaString2 = luaString = debugInfo != null ? debugInfo.getlocalname(n3) : null;
        if (luaString != null) {
            LuaValue luaValue = debugInfo.stack[n3 - 1];
            return DebugLib.varargsOf(luaString, (Varargs)luaValue);
        }
        return NIL;
    }

    static Varargs _setlocal(Varargs varargs) {
        LuaString luaString;
        int n = 1;
        LuaThread luaThread = varargs.isthread(n) ? varargs.checkthread(n++) : LuaThread.getRunning();
        int n2 = varargs.checkint(n++);
        int n3 = varargs.checkint(n++);
        LuaValue luaValue = varargs.arg(n++);
        DebugState debugState = DebugLib.getDebugState(luaThread);
        DebugInfo debugInfo = debugState.getDebugInfo(n2 - 1);
        LuaString luaString2 = luaString = debugInfo != null ? debugInfo.getlocalname(n3) : null;
        if (luaString != null) {
            debugInfo.stack[n3 - 1] = luaValue;
            return luaString;
        }
        return NIL;
    }

    static LuaValue _getmetatable(Varargs varargs) {
        LuaValue luaValue = varargs.arg(1);
        LuaValue luaValue2 = luaValue.getmetatable();
        return luaValue2 != null ? luaValue2 : NIL;
    }

    static Varargs _setmetatable(Varargs varargs) {
        LuaValue luaValue = varargs.arg(1);
        try {
            LuaTable luaTable = varargs.opttable(2, null);
            switch (luaValue.type()) {
                case 0: {
                    LuaNil.s_metatable = luaTable;
                    break;
                }
                case 3: {
                    LuaNumber.s_metatable = luaTable;
                    break;
                }
                case 1: {
                    LuaBoolean.s_metatable = luaTable;
                    break;
                }
                case 4: {
                    LuaString.s_metatable = luaTable;
                    break;
                }
                case 6: {
                    LuaFunction.s_metatable = luaTable;
                    break;
                }
                case 8: {
                    LuaThread.s_metatable = luaTable;
                    break;
                }
                default: {
                    luaValue.setmetatable(luaTable);
                }
            }
            return LuaValue.TRUE;
        }
        catch (LuaError luaError) {
            return DebugLib.varargsOf(FALSE, (Varargs)DebugLib.valueOf(luaError.toString()));
        }
    }

    static Varargs _getregistry(Varargs varargs) {
        return new LuaTable();
    }

    static LuaString findupvalue(LuaClosure luaClosure, int n) {
        if (luaClosure.upValues != null && n > 0 && n <= luaClosure.upValues.length) {
            if (luaClosure.p.upvalues != null && n <= luaClosure.p.upvalues.length) {
                return luaClosure.p.upvalues[n - 1];
            }
            return LuaString.valueOf("." + n);
        }
        return null;
    }

    static Varargs _getupvalue(Varargs varargs) {
        LuaClosure luaClosure;
        LuaString luaString;
        LuaValue luaValue = varargs.checkfunction(1);
        int n = varargs.checkint(2);
        if (luaValue instanceof LuaClosure && (luaString = DebugLib.findupvalue(luaClosure = (LuaClosure)luaValue, n)) != null) {
            return DebugLib.varargsOf(luaString, (Varargs)luaClosure.upValues[n - 1].getValue());
        }
        return NIL;
    }

    static LuaValue _setupvalue(Varargs varargs) {
        LuaClosure luaClosure;
        LuaString luaString;
        LuaValue luaValue = varargs.checkfunction(1);
        int n = varargs.checkint(2);
        LuaValue luaValue2 = varargs.arg(3);
        if (luaValue instanceof LuaClosure && (luaString = DebugLib.findupvalue(luaClosure = (LuaClosure)luaValue, n)) != null) {
            luaClosure.upValues[n - 1].setValue(luaValue2);
            return luaString;
        }
        return NIL;
    }

    static LuaValue _traceback(Varargs varargs) {
        int n = 1;
        LuaThread luaThread = varargs.isthread(n) ? varargs.checkthread(n++) : LuaThread.getRunning();
        String string = varargs.optjstring(n++, null);
        int n2 = varargs.optint(n++, 1);
        String string2 = DebugLib.traceback(luaThread, n2 - 1);
        return DebugLib.valueOf(string != null ? string + "\n" + string2 : string2);
    }

    public static String traceback(int n) {
        return DebugLib.traceback(LuaThread.getRunning(), n);
    }

    public static String traceback(LuaThread luaThread, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        DebugState debugState = DebugLib.getDebugState(luaThread);
        stringBuffer.append("stack traceback:");
        DebugInfo debugInfo = debugState.getDebugInfo(n);
        if (debugInfo != null) {
            stringBuffer.append("\n\t");
            stringBuffer.append(debugInfo.sourceline());
            stringBuffer.append(" in ");
            while ((debugInfo = debugState.getDebugInfo(++n)) != null) {
                stringBuffer.append(debugInfo.tracename());
                stringBuffer.append("\n\t");
                stringBuffer.append(debugInfo.sourceline());
                stringBuffer.append(" in ");
            }
            stringBuffer.append("main chunk");
        }
        return stringBuffer.toString();
    }

    public static String fileline() {
        DebugState debugState = DebugLib.getDebugState(LuaThread.getRunning());
        int n = debugState.debugCalls;
        for (int i = 0; i < n; ++i) {
            DebugInfo debugInfo = debugState.getDebugInfo(i);
            if (debugInfo == null || !debugInfo.func.isclosure()) continue;
            return debugInfo.sourceline();
        }
        return DebugLib.fileline(0);
    }

    public static String fileline(int n) {
        DebugState debugState = DebugLib.getDebugState(LuaThread.getRunning());
        DebugInfo debugInfo = debugState.getDebugInfo(n);
        return debugInfo != null ? debugInfo.sourceline() : null;
    }

    static void lua_assert(boolean bl) {
        if (!bl) {
            throw new RuntimeException("lua_assert failed");
        }
    }

    static LuaString[] getobjname(DebugInfo debugInfo, int n) {
        if (debugInfo.closure != null) {
            Prototype prototype = debugInfo.closure.p;
            int n2 = debugInfo.pc;
            LuaString luaString = prototype.getlocalname(n + 1, n2);
            if (luaString != null) {
                return new LuaString[]{luaString, LOCAL};
            }
            int n3 = DebugLib.symbexec(prototype, n2, n);
            DebugLib.lua_assert(n2 != -1);
            switch (Lua.GET_OPCODE(n3)) {
                case 5: {
                    int n4 = Lua.GETARG_Bx(n3);
                    return new LuaString[]{prototype.k[n4].strvalue(), GLOBAL};
                }
                case 0: {
                    int n5 = Lua.GETARG_A(n3);
                    int n6 = Lua.GETARG_B(n3);
                    if (n6 >= n5) break;
                    return DebugLib.getobjname(debugInfo, n6);
                }
                case 6: {
                    int n7 = Lua.GETARG_C(n3);
                    luaString = DebugLib.kname(prototype, n7);
                    return new LuaString[]{luaString, FIELD};
                }
                case 4: {
                    int n8 = Lua.GETARG_B(n3);
                    luaString = n8 < prototype.upvalues.length ? prototype.upvalues[n8] : QMARK;
                    return new LuaString[]{luaString, UPVALUE};
                }
                case 11: {
                    int n9 = Lua.GETARG_C(n3);
                    luaString = DebugLib.kname(prototype, n9);
                    return new LuaString[]{luaString, METHOD};
                }
            }
        }
        return null;
    }

    static LuaString kname(Prototype prototype, int n) {
        if (Lua.ISK(n) && prototype.k[Lua.INDEXK(n)].isstring()) {
            return prototype.k[Lua.INDEXK(n)].strvalue();
        }
        return QMARK;
    }

    static boolean checkreg(Prototype prototype, int n) {
        return n < prototype.maxstacksize;
    }

    static boolean precheck(Prototype prototype) {
        if (prototype.maxstacksize > 250) {
            return false;
        }
        DebugLib.lua_assert(prototype.numparams + (prototype.is_vararg & 1) <= prototype.maxstacksize);
        DebugLib.lua_assert((prototype.is_vararg & 4) == 0 || (prototype.is_vararg & 1) != 0);
        if (prototype.upvalues.length > prototype.nups) {
            return false;
        }
        if (prototype.lineinfo.length != prototype.code.length && prototype.lineinfo.length != 0) {
            return false;
        }
        return Lua.GET_OPCODE(prototype.code[prototype.code.length - 1]) == 30;
    }

    static boolean checkopenop(Prototype prototype, int n) {
        int n2 = prototype.code[n + 1];
        switch (Lua.GET_OPCODE(n2)) {
            case 28: 
            case 29: 
            case 30: 
            case 34: {
                return Lua.GETARG_B(n2) == 0;
            }
        }
        return false;
    }

    static boolean checkArgMode(Prototype prototype, int n, int n2) {
        switch (n2) {
            case 0: {
                if (n == 0) break;
                return false;
            }
            case 1: {
                break;
            }
            case 2: {
                DebugLib.checkreg(prototype, n);
                break;
            }
            case 3: {
                if (!Lua.ISK(n) ? n < prototype.maxstacksize : Lua.INDEXK(n) < prototype.k.length) break;
                return false;
            }
        }
        return true;
    }

    static int symbexec(Prototype prototype, int n, int n2) {
        int n3 = prototype.code.length - 1;
        if (!DebugLib.precheck(prototype)) {
            return 0;
        }
        block21: for (int i = 0; i < n; ++i) {
            int n4;
            int n5;
            int n6 = prototype.code[i];
            int n7 = Lua.GET_OPCODE(n6);
            int n8 = Lua.GETARG_A(n6);
            int n9 = 0;
            int n10 = 0;
            if (n7 >= 38) {
                return 0;
            }
            if (!DebugLib.checkreg(prototype, n8)) {
                return 0;
            }
            switch (Lua.getOpMode(n7)) {
                case 0: {
                    n9 = Lua.GETARG_B(n6);
                    n10 = Lua.GETARG_C(n6);
                    if (!DebugLib.checkArgMode(prototype, n9, Lua.getBMode(n7))) {
                        return 0;
                    }
                    if (DebugLib.checkArgMode(prototype, n10, Lua.getCMode(n7))) break;
                    return 0;
                }
                case 1: {
                    n9 = Lua.GETARG_Bx(n6);
                    if (Lua.getBMode(n7) != 3 || n9 < prototype.k.length) break;
                    return 0;
                }
                case 2: {
                    n9 = Lua.GETARG_sBx(n6);
                    if (Lua.getBMode(n7) != 2) break;
                    n5 = i + 1 + n9;
                    if (0 > n5 || n5 >= prototype.code.length) {
                        return 0;
                    }
                    if (n5 <= 0 || Lua.GET_OPCODE(n4 = prototype.code[n5 - 1]) != 34 || Lua.GETARG_C(n4) != 0) break;
                    return 0;
                }
            }
            if (Lua.testAMode(n7) && n8 == n2) {
                n3 = i;
            }
            if (Lua.testTMode(n7)) {
                if (i + 2 >= prototype.code.length) {
                    return 0;
                }
                if (Lua.GET_OPCODE(prototype.code[i + 1]) != 22) {
                    return 0;
                }
            }
            switch (n7) {
                case 2: {
                    if (n10 == 0 || i + 2 < prototype.code.length) continue block21;
                    return 0;
                }
                case 3: {
                    if (n8 > n2 || n2 > n9) continue block21;
                    n3 = i;
                    continue block21;
                }
                case 4: 
                case 8: {
                    if (n9 < prototype.nups) continue block21;
                    return 0;
                }
                case 5: 
                case 7: {
                    if (prototype.k[n9].isstring()) continue block21;
                    return 0;
                }
                case 11: {
                    if (!DebugLib.checkreg(prototype, n8 + 1)) {
                        return 0;
                    }
                    if (n2 != n8 + 1) continue block21;
                    n3 = i;
                    continue block21;
                }
                case 21: {
                    if (n9 < n10) continue block21;
                    return 0;
                }
                case 33: {
                    if (n10 < 1) {
                        return 0;
                    }
                    if (!DebugLib.checkreg(prototype, n8 + 2 + n10)) {
                        return 0;
                    }
                    if (n2 < n8 + 2) continue block21;
                    n3 = i;
                    continue block21;
                }
                case 31: 
                case 32: {
                    if (!DebugLib.checkreg(prototype, n8 + 3)) {
                        return 0;
                    }
                }
                case 22: {
                    n5 = i + 1 + n9;
                    if (n2 == 255 || i >= n5 || n5 > n) continue block21;
                    i += n9;
                    continue block21;
                }
                case 28: 
                case 29: {
                    if (n9 != 0 && !DebugLib.checkreg(prototype, n8 + n9 - 1)) {
                        return 0;
                    }
                    if (--n10 == -1 ? !DebugLib.checkopenop(prototype, i) : n10 != 0 && !DebugLib.checkreg(prototype, n8 + n10 - 1)) {
                        return 0;
                    }
                    if (n2 < n8) continue block21;
                    n3 = i;
                    continue block21;
                }
                case 30: {
                    if (--n9 <= 0 || DebugLib.checkreg(prototype, n8 + n9 - 1)) continue block21;
                    return 0;
                }
                case 34: {
                    if (n9 > 0 && !DebugLib.checkreg(prototype, n8 + n9)) {
                        return 0;
                    }
                    if (n10 != 0) continue block21;
                    ++i;
                    continue block21;
                }
                case 36: {
                    if (n9 >= prototype.p.length) {
                        return 0;
                    }
                    n5 = prototype.p[n9].nups;
                    if (i + n5 >= prototype.code.length) {
                        return 0;
                    }
                    for (n4 = 1; n4 <= n5; ++n4) {
                        int n11 = Lua.GET_OPCODE(prototype.code[i + n4]);
                        if (n11 == 4 || n11 == 0) continue;
                        return 0;
                    }
                    if (n2 == 255) continue block21;
                    i += n5;
                    continue block21;
                }
                case 37: {
                    if ((prototype.is_vararg & 2) == 0 || (prototype.is_vararg & 4) != 0) {
                        return 0;
                    }
                    if (--n9 == -1 && !DebugLib.checkopenop(prototype, i)) {
                        return 0;
                    }
                    if (DebugLib.checkreg(prototype, n8 + n9 - 1)) continue block21;
                    return 0;
                }
            }
        }
        return prototype.code[n3];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        NAMES = new String[]{"debug", "getfenv", "gethook", "getinfo", "getlocal", "getmetatable", "getregistry", "getupvalue", "setfenv", "sethook", "setlocal", "setmetatable", "setupvalue", "traceback"};
        LUA = DebugLib.valueOf("Lua");
        JAVA = DebugLib.valueOf("Java");
        QMARK = DebugLib.valueOf("?");
        GLOBAL = DebugLib.valueOf("global");
        LOCAL = DebugLib.valueOf("local");
        METHOD = DebugLib.valueOf("method");
        UPVALUE = DebugLib.valueOf("upvalue");
        FIELD = DebugLib.valueOf("field");
        CALL = DebugLib.valueOf("call");
        LINE = DebugLib.valueOf("line");
        COUNT = DebugLib.valueOf("count");
        RETURN = DebugLib.valueOf("return");
        TAILRETURN = DebugLib.valueOf("tail return");
        FUNC = DebugLib.valueOf("func");
        NUPS = DebugLib.valueOf("nups");
        NAME = DebugLib.valueOf("name");
        NAMEWHAT = DebugLib.valueOf("namewhat");
        WHAT = DebugLib.valueOf("what");
        SOURCE = DebugLib.valueOf("source");
        SHORT_SRC = DebugLib.valueOf("short_src");
        LINEDEFINED = DebugLib.valueOf("linedefined");
        LASTLINEDEFINED = DebugLib.valueOf("lastlinedefined");
        CURRENTLINE = DebugLib.valueOf("currentline");
        ACTIVELINES = DebugLib.valueOf("activelines");
    }

    static class DebugState {
        private final WeakReference thread_ref;
        private int debugCalls = 0;
        private DebugInfo[] debugInfo = new DebugInfo[257];
        private LuaValue hookfunc;
        private boolean hookcall;
        private boolean hookline;
        private boolean hookrtrn;
        private boolean inhook;
        private int hookcount;
        private int hookcodes;
        private int line;

        DebugState(LuaThread luaThread) {
            this.thread_ref = new WeakReference<LuaThread>(luaThread);
        }

        public DebugInfo nextInfo() {
            DebugInfo debugInfo = this.debugInfo[this.debugCalls];
            if (debugInfo == null) {
                this.debugInfo[this.debugCalls] = debugInfo = new DebugInfo();
            }
            return debugInfo;
        }

        public DebugInfo pushInfo(int n) {
            while (this.debugCalls < n) {
                this.nextInfo();
                ++this.debugCalls;
            }
            return this.debugInfo[this.debugCalls - 1];
        }

        public void popInfo(int n) {
            while (this.debugCalls > n) {
                this.debugInfo[--this.debugCalls].clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void callHookFunc(DebugState debugState, LuaString luaString, LuaValue luaValue) {
            if (this.inhook || this.hookfunc == null) {
                return;
            }
            this.inhook = true;
            try {
                int n = this.debugCalls;
                debugState.nextInfo().setargs(luaValue, null);
                debugState.pushInfo(n + 1).setfunction(this.hookfunc);
                try {
                    this.hookfunc.call(luaString, luaValue);
                }
                finally {
                    debugState.popInfo(n);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.inhook = false;
            }
        }

        public void sethook(LuaValue luaValue, boolean bl, boolean bl2, boolean bl3, int n) {
            this.hookcount = n;
            this.hookcall = bl;
            this.hookline = bl2;
            this.hookrtrn = bl3;
            this.hookfunc = luaValue;
        }

        DebugInfo getDebugInfo() {
            try {
                return this.debugInfo[this.debugCalls - 1];
            }
            catch (Exception exception) {
                if (this.debugCalls <= 0) {
                    DebugInfo debugInfo = new DebugInfo();
                    this.debugInfo[this.debugCalls++] = debugInfo;
                    return debugInfo;
                }
                return null;
            }
        }

        DebugInfo getDebugInfo(int n) {
            return n < 0 || n >= this.debugCalls ? null : this.debugInfo[this.debugCalls - n - 1];
        }

        public DebugInfo findDebugInfo(LuaValue luaValue) {
            int n = this.debugCalls;
            while (--n >= 0) {
                if (this.debugInfo[n].func != luaValue) continue;
                return this.debugInfo[n];
            }
            return new DebugInfo(luaValue);
        }

        public String tojstring() {
            LuaThread luaThread = (LuaThread)this.thread_ref.get();
            return luaThread != null ? DebugLib.traceback(luaThread, 0) : "orphaned thread";
        }
    }

    static class DebugInfo {
        LuaValue func;
        LuaClosure closure;
        LuaValue[] stack;
        Varargs varargs;
        Varargs extras;
        int pc;
        int top;

        private DebugInfo() {
            this.func = LuaValue.NIL;
        }

        private DebugInfo(LuaValue luaValue) {
            this.pc = -1;
            this.setfunction(luaValue);
        }

        void setargs(Varargs varargs, LuaValue[] luaValueArray) {
            this.varargs = varargs;
            this.stack = luaValueArray;
        }

        void setfunction(LuaValue luaValue) {
            this.func = luaValue;
            this.closure = luaValue instanceof LuaClosure ? (LuaClosure)luaValue : null;
        }

        void clear() {
            this.func = LuaValue.NIL;
            this.closure = null;
            this.stack = null;
            this.extras = null;
            this.varargs = null;
            this.top = 0;
            this.pc = 0;
        }

        public void bytecode(int n, Varargs varargs, int n2) {
            this.pc = n;
            this.top = n2;
            this.extras = varargs;
        }

        public int currentline() {
            if (this.closure == null) {
                return -1;
            }
            int[] nArray = this.closure.p.lineinfo;
            return nArray == null || this.pc < 0 || this.pc >= nArray.length ? -1 : nArray[this.pc];
        }

        public LuaString[] getfunckind() {
            if (this.closure == null || this.pc < 0) {
                return null;
            }
            int n = this.closure.p.code[this.pc] >> 6 & 0xFF;
            return DebugLib.getobjname(this, n);
        }

        public String sourceline() {
            if (this.closure == null) {
                return this.func.tojstring();
            }
            String string = this.closure.p.source.tojstring();
            int n = this.currentline();
            return (string.startsWith("@") || string.startsWith("=") ? string.substring(1) : string) + ":" + n;
        }

        public String tracename() {
            LuaString[] luaStringArray = this.getfunckind();
            if (luaStringArray == null) {
                return "function ?";
            }
            return "function " + luaStringArray[0].tojstring();
        }

        public LuaString getlocalname(int n) {
            if (this.closure == null) {
                return null;
            }
            return this.closure.p.getlocalname(n, this.pc);
        }

        public String tojstring() {
            return this.tracename() + " " + this.sourceline();
        }
    }
}

