/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.interf.IExtraVariantHolder;
import vazkii.arl.item.ItemModBlock;
import vazkii.quark.base.lib.LibMisc;
import vazkii.quark.decoration.block.BlockCustomChest;
import vazkii.quark.decoration.feature.VariedChests;
import vazkii.quark.decoration.tile.TileCustomChest;

public class ItemChestBlock
extends ItemModBlock
implements IExtraVariantHolder {
    public ItemChestBlock(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    public int func_77647_b(int damage) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getCustomMeshDefinition() {
        return new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                VariedChests.ChestType type = VariedChests.custom_chest.getCustomType(stack);
                return ItemChestBlock.this.func_179223_d() == VariedChests.custom_chest_trap ? type.trapModel : type.normalModel;
            }
        };
    }

    public String func_77667_c(ItemStack stack) {
        VariedChests.ChestType type = VariedChests.custom_chest.getCustomType(stack);
        String name = type.name + (this.func_179223_d() == VariedChests.custom_chest_trap ? "_trap" : "");
        return "tile." + LibMisc.PREFIX_MOD + "custom_chest_" + name;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        TileEntity te;
        int typeCnt = 0;
        BlockPos posN = pos.func_177978_c();
        BlockPos posS = pos.func_177968_d();
        BlockPos posW = pos.func_177976_e();
        BlockPos posE = pos.func_177974_f();
        BlockCustomChest cChest = (BlockCustomChest)this.func_179223_d();
        VariedChests.ChestType myType = cChest.getCustomType(stack);
        if (world.func_180495_p(posN).func_177230_c() == this.field_150939_a && cChest.getCustomType((IBlockAccess)world, posN) == myType) {
            typeCnt += cChest.isDoubleChest(world, posN, myType) ? 2 : 1;
        }
        if (world.func_180495_p(posS).func_177230_c() == this.field_150939_a && cChest.getCustomType((IBlockAccess)world, posS) == myType) {
            typeCnt += cChest.isDoubleChest(world, posS, myType) ? 2 : 1;
        }
        if (world.func_180495_p(posW).func_177230_c() == this.field_150939_a && cChest.getCustomType((IBlockAccess)world, posW) == myType) {
            typeCnt += cChest.isDoubleChest(world, posW, myType) ? 2 : 1;
        }
        if (world.func_180495_p(posE).func_177230_c() == this.field_150939_a && cChest.getCustomType((IBlockAccess)world, posE) == myType) {
            typeCnt += cChest.isDoubleChest(world, posE, myType) ? 2 : 1;
        }
        if (typeCnt <= 1 && super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState) && (te = world.func_175625_s(pos)) instanceof TileCustomChest) {
            ((TileCustomChest)te).chestType = myType;
            return true;
        }
        return false;
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        BlockCustomChest chest = (BlockCustomChest)Block.func_149634_a((Item)itemIn);
        for (VariedChests.ChestType type : VariedChests.ChestType.VALID_TYPES) {
            subItems.add(chest.setCustomType(new ItemStack(itemIn, 1), type));
        }
    }

    public String[] getExtraVariants() {
        ArrayList<String> variants = new ArrayList<String>();
        for (VariedChests.ChestType type : VariedChests.ChestType.VALID_TYPES) {
            variants.add("custom_chest_" + type.name);
            variants.add("custom_chest_trap_" + type.name);
        }
        return variants.toArray(new String[variants.size()]);
    }
}

