/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.vanity.client.emotes.base;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.quark.base.lib.LibObfuscation;
import vazkii.quark.vanity.client.emotes.base.EmoteBase;

public final class EmoteHandler {
    public static Map<String, Class<? extends EmoteBase>> emoteMap = new LinkedHashMap<String, Class<? extends EmoteBase>>();
    private static WeakHashMap<EntityPlayer, EmoteBase> playerEmotes = new WeakHashMap();
    private static List<EntityPlayer> updatedPlayers = new ArrayList<EntityPlayer>();
    public static float time;
    public static float partialTicks;
    public static float total;
    public static float delta;

    public static void putEmote(AbstractClientPlayer player, String emoteName) {
        if (emoteMap.containsKey(emoteName)) {
            EmoteHandler.putEmote(player, emoteMap.get(emoteName));
        }
    }

    public static void putEmote(AbstractClientPlayer player, Class<? extends EmoteBase> clazz) {
        if (playerEmotes.containsKey(player)) {
            return;
        }
        ModelBiped model = EmoteHandler.getPlayerModel(player);
        ModelBiped armorModel = EmoteHandler.getPlayerArmorModel(player);
        ModelBiped armorLegModel = EmoteHandler.getPlayerArmorLegModel(player);
        if (model.field_78116_c.field_78796_g < 0.0f) {
            model.field_78116_c.field_78796_g = (float)Math.PI * 2 - model.field_78116_c.field_78796_g;
        }
        try {
            playerEmotes.put((EntityPlayer)player, clazz.getConstructor(EntityPlayer.class, ModelBiped.class, ModelBiped.class, ModelBiped.class).newInstance(player, model, armorModel, armorLegModel));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateEmotes(Entity e) {
        AbstractClientPlayer player;
        if (e instanceof AbstractClientPlayer && playerEmotes.containsKey(player = (AbstractClientPlayer)e)) {
            EmoteBase emote = playerEmotes.get(player);
            boolean done = emote.isDone();
            if (player.field_70733_aJ > 0.0f || player.field_70737_aN > 0) {
                done = true;
            }
            if (done) {
                playerEmotes.remove(player);
                EmoteHandler.resetModel(EmoteHandler.getPlayerModel(player));
                EmoteHandler.resetModel(EmoteHandler.getPlayerArmorModel(player));
                EmoteHandler.resetModel(EmoteHandler.getPlayerArmorLegModel(player));
            } else {
                emote.update(!updatedPlayers.contains(player));
            }
            updatedPlayers.add((EntityPlayer)player);
        }
    }

    public static void clearPlayerList() {
        updatedPlayers.clear();
    }

    private static RenderPlayer getRenderPlayer(AbstractClientPlayer player) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderManager manager = mc.func_175598_ae();
        return (RenderPlayer)manager.getSkinMap().get(player.func_175154_l());
    }

    private static ModelBiped getPlayerModel(AbstractClientPlayer player) {
        return EmoteHandler.getRenderPlayer(player).func_177087_b();
    }

    private static ModelBiped getPlayerArmorModel(AbstractClientPlayer player) {
        List list = (List)ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)EmoteHandler.getRenderPlayer(player), (String[])LibObfuscation.LAYER_RENDERERS);
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof LayerBipedArmor)) continue;
            return (ModelBiped)ReflectionHelper.getPrivateValue(LayerArmorBase.class, (Object)((LayerArmorBase)list.get(i)), (String[])LibObfuscation.MODEL_ARMOR);
        }
        return null;
    }

    private static ModelBiped getPlayerArmorLegModel(AbstractClientPlayer player) {
        List list = (List)ReflectionHelper.getPrivateValue(RenderLivingBase.class, (Object)EmoteHandler.getRenderPlayer(player), (String[])LibObfuscation.LAYER_RENDERERS);
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof LayerBipedArmor)) continue;
            return (ModelBiped)ReflectionHelper.getPrivateValue(LayerArmorBase.class, (Object)((LayerArmorBase)list.get(i)), (String[])LibObfuscation.MODEL_LEGGINGS);
        }
        return null;
    }

    private static void resetModel(ModelBiped model) {
        model.field_78116_c.field_78808_h = 0.0f;
        model.field_178720_f.field_78808_h = 0.0f;
        model.field_78115_e.field_78808_h = 0.0f;
        model.field_178721_j.field_78808_h = 0.0f;
        model.field_178722_k.field_78808_h = 0.0f;
    }

    public static class TickHandler {
        private void calcDelta() {
            float oldTotal = total;
            total = time + partialTicks;
            delta = (total - oldTotal) * 50.0f;
        }

        @SubscribeEvent
        public void renderTick(TickEvent.RenderTickEvent event) {
            if (event.phase == TickEvent.Phase.START) {
                partialTicks = event.renderTickTime;
                EmoteHandler.clearPlayerList();
            } else {
                this.calcDelta();
            }
        }

        @SubscribeEvent
        public void clientTickEnd(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END) {
                Minecraft mc = Minecraft.func_71410_x();
                GuiScreen gui = mc.field_71462_r;
                if (gui == null || !gui.func_73868_f()) {
                    time += 1.0f;
                    partialTicks = 0.0f;
                }
                this.calcDelta();
            }
        }
    }
}

