/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.gui;

import java.awt.Point;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import shetiphian.core.client.GuiFunctions;
import shetiphian.multistorage.client.gui.GuiContainer;
import shetiphian.multistorage.common.inventory.ContainerChameleon;
import shetiphian.multistorage.common.inventory.SlotHideable;
import shetiphian.multistorage.common.network.NetworkHandler;
import shetiphian.multistorage.common.network.PacketChameleon;
import shetiphian.multistorage.common.tileentity.TileEntityChameleon;

@SideOnly(value=Side.CLIENT)
public class GuiChameleon
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("multistorage", "textures/gui/chameleon.png");
    private TileEntityChameleon tile;
    private int slotCount;
    private boolean editMode;
    private byte[] posShift = new byte[3];

    public GuiChameleon(ContainerChameleon chest, TileEntityChameleon tile) {
        super(chest);
        this.tile = tile;
        this.field_146291_p = false;
        this.slotCount = 0;
        if (chest != null) {
            this.slotCount = chest.field_75151_b.size() - 36;
        }
        this.field_146999_f = 182;
        this.field_147000_g = 195;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_147009_r += 7;
        this.field_146292_n.clear();
        this.field_146292_n.add(new Button(0, this.field_147003_i + 8, this.field_147009_r + 73, 16, 16, ButtonType.ICON));
        this.field_146292_n.add(new Button(1, this.field_147003_i + 39, this.field_147009_r + 68, 12, 12, ButtonType.CANCEL));
        this.field_146292_n.add(new Button(2, this.field_147003_i + 131, this.field_147009_r + 68, 12, 12, ButtonType.OK));
        this.field_146292_n.add(new Button(3, this.field_147003_i + 61, this.field_147009_r + 22, 12, 12, ButtonType.ADD));
        this.field_146292_n.add(new Button(4, this.field_147003_i + 85, this.field_147009_r + 22, 12, 12, ButtonType.ADD));
        this.field_146292_n.add(new Button(5, this.field_147003_i + 109, this.field_147009_r + 22, 12, 12, ButtonType.ADD));
        this.field_146292_n.add(new Button(6, this.field_147003_i + 61, this.field_147009_r + 54, 12, 12, ButtonType.SUBTRACT));
        this.field_146292_n.add(new Button(7, this.field_147003_i + 85, this.field_147009_r + 54, 12, 12, ButtonType.SUBTRACT));
        this.field_146292_n.add(new Button(8, this.field_147003_i + 109, this.field_147009_r + 54, 12, 12, ButtonType.SUBTRACT));
        this.field_147009_r -= 7;
        this.enableButtons(false);
    }

    private void enableButtons(boolean enable) {
        this.editMode = enable;
        for (GuiButton button : this.field_146292_n) {
            button.field_146125_m = button.field_146124_l = button.field_146127_k == 0 != enable;
        }
        for (Slot invSlot : this.field_147002_h.field_75151_b) {
            if (!(invSlot instanceof SlotHideable)) continue;
            SlotHideable slot = (SlotHideable)invSlot;
            slot.setVisible(!enable);
        }
        if (enable) {
            this.posShift[0] = (byte)(this.tile.getClonedPos().func_177958_n() - this.tile.func_174877_v().func_177958_n());
            this.posShift[1] = (byte)(this.tile.getClonedPos().func_177956_o() - this.tile.func_174877_v().func_177956_o());
            this.posShift[2] = (byte)(this.tile.getClonedPos().func_177952_p() - this.tile.func_174877_v().func_177952_p());
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        int winLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int winTop = (this.field_146295_m - this.field_147000_g) / 2 + 7;
        int ypos = 0;
        if (this.slotCount > 12 || this.editMode) {
            int left = 27;
            this.func_73729_b(winLeft + left, winTop, 27, 66, 128, 92);
            if (!this.editMode) {
                this.func_73729_b(winLeft + left + 10, winTop + 10, 192, 76, 54, 72);
                this.func_73729_b(winLeft + left + 64, winTop + 10, 192, 76, 54, 72);
            }
        } else {
            this.func_73729_b(winLeft + 54, winTop + ypos, 182, 66, 74, 92);
        }
        this.func_73729_b(winLeft, winTop + (ypos += 92), 0, 158, 182, 98);
        GuiFunctions.exitDrawTextureStateWithBlend();
    }

    @Override
    protected void func_146977_a(Slot slot) {
        if (slot.func_111238_b()) {
            super.func_146977_a(slot);
        }
    }

    @Override
    protected boolean func_146981_a(Slot slot, int mouseX, int mouseY) {
        return slot.func_111238_b() && super.func_146981_a(slot, mouseX, mouseY);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.editMode) {
            this.func_73732_a(this.field_146289_q, "" + this.posShift[0], 67, 40, -1);
            this.func_73732_a(this.field_146289_q, "" + this.posShift[1], 91, 40, -1);
            this.func_73732_a(this.field_146289_q, "" + this.posShift[2], 115, 40, -1);
        }
    }

    protected void func_146284_a(GuiButton button) {
        int pointer;
        if (!this.editMode) {
            if (button.field_146127_k == 0) {
                this.enableButtons(true);
            }
            return;
        }
        if (button.field_146127_k == 1) {
            this.enableButtons(false);
        } else if (button.field_146127_k == 2) {
            NetworkHandler.sendToServer(new PacketChameleon(this.tile.func_174877_v(), this.posShift));
            this.enableButtons(false);
        } else if (button.field_146127_k > 2 && button.field_146127_k < 6) {
            int pointer2 = button.field_146127_k - 3;
            if (this.posShift[pointer2] < 2) {
                int n = pointer2;
                this.posShift[n] = (byte)(this.posShift[n] + 1);
            }
        } else if (button.field_146127_k > 5 && button.field_146127_k < 9 && this.posShift[pointer = button.field_146127_k - 6] > -2) {
            int n = pointer;
            this.posShift[n] = (byte)(this.posShift[n] - 1);
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.editMode && keyCode == 1) {
            this.enableButtons(false);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private static class Button
    extends GuiButton {
        private final ButtonType type;

        Button(int id, int x, int y, int width, int height, ButtonType type) {
            super(id, x, y, width, height, "");
            this.type = type;
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            if (!this.field_146125_m) {
                return;
            }
            boolean bl = this.field_146123_n = this.field_146124_l && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            Point txPoint = this.field_146123_n ? (Mouse.isButtonDown((int)0) ? this.type.pressed : this.type.hover) : this.type.normal;
            GuiFunctions.enterDrawTextureStateWithBlend();
            mc.func_110434_K().func_110577_a(texture);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, txPoint.x, txPoint.y, this.field_146120_f, this.field_146121_g);
            GuiFunctions.exitDrawTextureStateWithBlend();
        }
    }

    private static enum ButtonType {
        ICON(new Point(240, 208), new Point(240, 224), new Point(240, 240)),
        ADD(new Point(228, 220), new Point(228, 232), new Point(228, 244)),
        SUBTRACT(new Point(216, 220), new Point(216, 232), new Point(216, 244)),
        OK(new Point(204, 220), new Point(204, 232), new Point(204, 244)),
        CANCEL(new Point(192, 220), new Point(192, 232), new Point(192, 244));

        private final Point normal;
        private final Point hover;
        private final Point pressed;

        private ButtonType(Point normal, Point hover, Point pressed) {
            this.normal = normal;
            this.hover = hover;
            this.pressed = pressed;
        }
    }
}

