/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import shetiphian.core.client.GuiFunctions;
import shetiphian.multistorage.client.gui.GuiContainer;
import shetiphian.multistorage.common.enderlink.ChestInfoHelper;
import shetiphian.multistorage.common.inventory.ContainerEnderLink;
import shetiphian.multistorage.common.inventory.SlotHideable;
import shetiphian.multistorage.common.item.ItemEnderBag;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLinkChest;

@SideOnly(value=Side.CLIENT)
public class GuiEnderLink
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("multistorage", "textures/gui/enderlink.png");
    private IInventory chest;
    private String owner;
    private int slotCount;
    private int columns;
    private int rows;
    private int colOffset;
    private boolean bagAccess;
    private long worldtime;

    public GuiEnderLink(EntityPlayer player, TileEntityEnderLinkChest tile, String owner) {
        super(new ContainerEnderLink(player, tile));
        this.chest = tile.getChest();
        this.owner = ChestInfoHelper.formatChestOwner(owner, true);
        this.field_146999_f = 182;
        this.bagAccess = false;
        this.setLayout();
    }

    public GuiEnderLink(EntityPlayer player, IInventory chest, String owner) {
        super(new ContainerEnderLink(player, chest));
        this.chest = chest;
        this.owner = ChestInfoHelper.formatChestOwner(owner, true);
        this.field_146999_f = 182;
        this.bagAccess = true;
        this.setLayout();
    }

    private void setLayout() {
        this.slotCount = this.chest.func_70302_i_();
        int n = this.columns = this.slotCount >= 27 ? 9 : this.slotCount / 3;
        this.rows = this.slotCount <= 27 ? 3 : (this.slotCount % 9 == 0 ? this.slotCount / 9 : this.slotCount / 9 + 1);
        this.colOffset = (9 - this.columns) * 9;
        int rowOffset = (this.rows - 3) * 18;
        this.field_147000_g = 172 + rowOffset;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
        for (Slot invSlot : this.field_147002_h.field_75151_b) {
            if (invSlot instanceof SlotHideable) {
                SlotHideable slot = (SlotHideable)invSlot;
                int group = slot.getSlotIndex();
                if (slot.getSlotIndex() >= this.slotCount) {
                    slot.setVisible(false);
                    continue;
                }
                slot.setVisible(true);
                slot.field_75223_e = 11 + this.colOffset + group % this.columns * 18;
                slot.field_75221_f = 11 + group / this.columns * 18;
                continue;
            }
            int slotId = invSlot.getSlotIndex();
            int row = slotId / 9 - 1;
            int col = slotId % 9 * 18;
            invSlot.field_75223_e = 11 + col;
            invSlot.field_75221_f = 87 + rowOffset + (row == -1 ? 58 : row * 18);
        }
    }

    public void func_146270_b(int tint) {
        if (this.field_146297_k == null) {
            this.field_146297_k = Minecraft.func_71410_x();
        }
        super.func_146270_b(tint);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.func_73732_a(this.field_146289_q, this.owner, this.field_146999_f / 2, -8, -32961);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        if (this.bagAccess) {
            if (this.worldtime == 0L) {
                this.worldtime = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.worldtime < 200L) {
                Mouse.setGrabbed((boolean)false);
            }
        }
        if (this.slotCount != this.chest.func_70302_i_()) {
            this.setLayout();
        }
        GuiFunctions.enterDrawTextureStateWithBlend();
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        int winLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int winTop = (this.field_146295_m - this.field_147000_g) / 2;
        int ypos = 0;
        if (this.slotCount >= 27) {
            int rem;
            this.func_73729_b(winLeft, winTop + ypos, 0, 102, 182, 46);
            this.func_73729_b(winLeft, winTop + (ypos += 46), 0, 112, 182, this.rows == 3 ? 18 : 36);
            ypos += this.rows == 3 ? 18 : 36;
            if (this.rows > 4) {
                this.func_73729_b(winLeft, winTop + ypos, 0, 112, 182, this.rows == 5 ? 18 : 36);
                ypos += this.rows == 5 ? 18 : 36;
            }
            if ((rem = this.slotCount % 9) != 0) {
                int left = rem == 3 ? 64 : 118;
                this.func_73729_b(winLeft + left, winTop + ypos - 18, left, this.rows % 2 == 0 ? 82 : 64, 182 - left - 10, 18);
            }
            this.func_73729_b(winLeft, winTop + ypos, 0, 148, 182, 10);
        } else {
            int left = this.colOffset;
            this.func_73729_b(winLeft + left, winTop, 0, 102, 10, 46);
            this.func_73729_b(winLeft + left, winTop + 46, 0, 112, 10, 18);
            this.func_73729_b(winLeft + left, winTop + 64, 0, 148, 10, 10);
            int half = (this.columns / 2 - 1) * 18;
            this.func_73729_b(winLeft + (left += 10), winTop, 64 - half, 102, this.columns * 18, 46);
            this.func_73729_b(winLeft + left, winTop + 46, 64 - half, 112, this.columns * 18, 18);
            this.func_73729_b(winLeft + left, winTop + 64, 64 - half, 148, this.columns * 18, 10);
            this.func_73729_b(winLeft + (left += this.columns * 18), winTop, 172, 102, 10, 46);
            this.func_73729_b(winLeft + left, winTop + 46, 172, 112, 10, 18);
            this.func_73729_b(winLeft + left, winTop + 64, 172, 148, 10, 10);
            ypos += 64;
        }
        this.func_73729_b(winLeft, winTop + (ypos += 10), 0, 158, 182, 98);
        GuiFunctions.exitDrawTextureStateWithBlend();
    }

    @Override
    protected void func_146977_a(Slot slot) {
        if (slot.func_111238_b()) {
            super.func_146977_a(slot);
        }
    }

    @Override
    protected boolean func_146981_a(Slot slot, int mouseX, int mouseY) {
        return slot.func_111238_b() && super.func_146981_a(slot, mouseX, mouseY);
    }

    @Override
    protected void func_184098_a(Slot slot, int slotId, int clickedButton, ClickType clickType) {
        ItemStack stack;
        if (slot != null && slot.func_75216_d() && (stack = slot.func_75211_c()) != null && stack.func_77973_b() instanceof ItemEnderBag && stack.func_77952_i() > 9) {
            return;
        }
        super.func_184098_a(slot, slotId, clickedButton, clickType);
    }
}

