/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.model;

import com.google.common.collect.HashBasedTable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.multistorage.common.block.BlockStoneStorage;
import shetiphian.multistorage.common.block.BlockStorageType;
import shetiphian.multistorage.common.tileentity.TileEntityStackingChest;

@SideOnly(value=Side.CLIENT)
public class ModelStackingChest
extends ModelBase {
    private static HashBasedTable<Boolean, ChestStyle, ResourceLocation> textures = HashBasedTable.create();
    private Minecraft mc = FMLClientHandler.instance().getClient();
    public ModelRenderer doorLeft;
    public ModelRenderer doorRight;

    public ModelStackingChest() {
        this.field_78090_t = 44;
        this.field_78089_u = 19;
        this.doorLeft = new ModelRenderer((ModelBase)this, 0, 0);
        this.doorLeft.func_78789_a(0.0f, -8.0f, -3.0f, 8, 16, 3);
        this.doorLeft.func_78793_a(-8.0f, 16.0f, -5.0f);
        this.doorLeft.func_78787_b(128, 128);
        this.doorLeft.field_78809_i = true;
        this.setRotation(this.doorLeft, 0.0f, 1.0f, 0.0f);
        this.doorRight = new ModelRenderer((ModelBase)this, 22, 0);
        this.doorRight.func_78789_a(-8.0f, -8.0f, -3.0f, 8, 16, 3);
        this.doorRight.func_78793_a(8.0f, 16.0f, -5.0f);
        this.doorRight.func_78787_b(128, 128);
        this.doorRight.field_78809_i = true;
        this.setRotation(this.doorRight, 0.0f, -1.0f, 0.0f);
        textures.clear();
        for (ChestStyle style : ChestStyle.values()) {
            textures.put((Object)false, (Object)style, (Object)new ResourceLocation("multistorage", "textures/models/stacking/cloud_" + style.toString().toLowerCase() + ".png"));
            textures.put((Object)true, (Object)style, (Object)new ResourceLocation("multistorage", "textures/models/stacking/stone_" + style.toString().toLowerCase() + ".png"));
        }
    }

    public void func_78088_a(Entity entity, float f, float f1, float f2, float f3, float f4, float f5) {
        super.func_78088_a(entity, f, f1, f2, f3, f4, f5);
        this.func_78087_a(f, f1, f2, f3, f4, f5, entity);
        this.renderModel(f5);
    }

    public void renderModel(float f5) {
        this.doorLeft.func_78785_a(f5);
        this.doorRight.func_78785_a(f5);
    }

    private void setRotation(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public void func_78087_a(float f, float f1, float f2, float f3, float f4, float f5, Entity entity) {
        super.func_78087_a(f, f1, f2, f3, f4, f5, entity);
    }

    public void bindTexture(TileEntityStackingChest tile) {
        this.mc.func_110434_K().func_110577_a((ResourceLocation)textures.get((Object)(tile.func_145838_q() instanceof BlockStoneStorage), (Object)this.getStyle(tile.func_145831_w().func_180495_p(tile.func_174877_v()))));
    }

    private ChestStyle getStyle(IBlockState state) {
        switch (BlockStorageType.getEnumType(state)) {
            case STACKABLE_SINGLE: {
                return ChestStyle.SINGLE;
            }
            case STACKABLE_TOP: {
                return ChestStyle.TOP;
            }
            case STACKABLE_MIDDLE: {
                return ChestStyle.MIDDLE;
            }
            case STACKABLE_BOTTOM: {
                return ChestStyle.BOTTOM;
            }
            case DENSE_STACKABLE_SINGLE: {
                return ChestStyle.SINGLE_DENSE;
            }
            case DENSE_STACKABLE_TOP: {
                return ChestStyle.TOP_DENSE;
            }
            case DENSE_STACKABLE_MIDDLE: {
                return ChestStyle.MIDDLE_DENSE;
            }
            case DENSE_STACKABLE_BOTTOM: {
                return ChestStyle.BOTTOM_DENSE;
            }
        }
        return ChestStyle.SINGLE;
    }

    private static enum ChestStyle {
        SINGLE,
        TOP,
        MIDDLE,
        BOTTOM,
        SINGLE_DENSE,
        TOP_DENSE,
        MIDDLE_DENSE,
        BOTTOM_DENSE;

    }
}

