/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.client.renderer;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.common.property.Properties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.multistorage.common.block.BlockEnderLinkChest;
import shetiphian.multistorage.common.tileentity.TileEntityEnderLinkChest;

@SideOnly(value=Side.CLIENT)
public class RenderEnderChest
extends FastTESR<TileEntityEnderLinkChest> {
    private static BlockRendererDispatcher blockRenderer;

    public void renderTileEntityFast(TileEntityEnderLinkChest tile, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer renderer) {
        if (blockRenderer == null) {
            blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        }
        BlockPos pos = tile.func_174877_v();
        ChunkCache world = MinecraftForgeClient.getRegionRenderCache((World)tile.func_145831_w(), (BlockPos)pos);
        IBlockState state = world.func_180495_p(pos);
        if ((state = state.func_185899_b((IBlockAccess)world, pos)).func_177227_a().contains(Properties.StaticProperty)) {
            state = state.func_177226_a((IProperty)Properties.StaticProperty, (Comparable)Boolean.valueOf(false));
        }
        float lidAngle = tile.prevLidAngle + (tile.lidAngle - tile.prevLidAngle) * partialTicks;
        lidAngle *= 0.7f;
        IBakedModel model = blockRenderer.func_175023_a().func_178125_b(state);
        EnumFacing facing = BlockEnderLinkChest.getFacing(state);
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            lidAngle = -lidAngle;
        }
        switch (facing.func_176740_k()) {
            case X: {
                renderer.func_178969_c(x - (double)pos.func_177958_n() + (double)lidAngle, y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
                break;
            }
            case Y: {
                renderer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o() + (double)lidAngle, z - (double)pos.func_177952_p());
                break;
            }
            case Z: {
                renderer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p() + (double)lidAngle);
            }
        }
        GlStateManager.func_179089_o();
        blockRenderer.func_175019_b().func_178267_a((IBlockAccess)world, model, state, pos, renderer, true);
    }
}

