/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import shetiphian.core.common.Function;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.common.block.BlockStorageType;
import shetiphian.multistorage.common.block.IStorageType;
import shetiphian.multistorage.common.tileentity.TileEntityQueue;
import shetiphian.multistorage.common.tileentity.TileEntityQueueDense;

public class TypeQueue
implements IStorageType {
    private TileEntityQueue getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityQueue ? (TileEntityQueue)tile : null;
    }

    @Override
    public TileEntity createTileEntity(boolean dense) {
        return dense ? new TileEntityQueueDense() : new TileEntityQueue();
    }

    @Override
    public IBlockState getActualState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityQueue tile = this.getTile(world, pos);
        if (tile != null) {
            return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)BlockStorageType.DATA, (Object)tile.getDataTag());
        }
        return state;
    }

    @Override
    public AxisAlignedBB getBoxBounds(BlockStorageType block, IBlockState state, IBlockAccess world, BlockPos pos) {
        return Block.field_185505_j;
    }

    @Override
    public boolean addCollisionBoxesToList(World world, BlockPos pos, IBlockState state, AxisAlignedBB aabb, List<AxisAlignedBB> list, Entity entity) {
        return false;
    }

    @Override
    public float getBlockHardness(IBlockState state, World world, BlockPos pos, float original) {
        TileEntityQueue tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            return original + 50.0f * tile.getFillPercentage();
        }
        return original;
    }

    @Override
    public void onBlockPlaced(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public void onBlockRemoved(World world, BlockPos pos, EntityPlayer player) {
    }

    @Override
    public void getDrops(List<ItemStack> ret, Block block, BlockStorageType.EnumType type) {
        ret.add(new ItemStack(block, 1, 7 + (type.isDense() ? 1 : 0)));
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    @Override
    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)MultiStorage.INSTANCE, 11, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Override
    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityQueue tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            tile.setFacing(tile.getFacing().func_176746_e());
            Function.syncTile((TileEntity)tile);
            return true;
        }
        return false;
    }

    @Override
    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return 0.0f;
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Override
    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.SOLID || layer == BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public int colorMultiplier(IBlockAccess world, BlockPos pos, int renderPass) {
        if (renderPass > 0 && renderPass <= 18) {
            --renderPass;
            TileEntityQueue tile = this.getTile(world, pos);
            if (tile != null) {
                int group = renderPass / 6;
                switch (tile.getSidedWrapper().getIndexes()[renderPass % 6]) {
                    case 0: {
                        return group == 0 ? 0x5555FF : 0xFFFF55;
                    }
                    case 1: {
                        return 0x5555FF;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        return 0xFFFF55;
                    }
                    case 5: {
                        return group == 0 ? 0xFFAA00 : 170;
                    }
                    case 6: {
                        return 170;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        return 0xFFAA00;
                    }
                }
            }
        }
        return 0xFFFFFF;
    }

    @Override
    public ItemStack getPickBlock(RayTraceResult target, World world, BlockPos pos, EntityPlayer player, Block block, BlockStorageType.EnumType type) {
        return new ItemStack(block, 1, 7 + (type.isDense() ? 1 : 0));
    }
}

