/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import shetiphian.core.common.Function;
import shetiphian.core.common.item.ItemBlockMulti;
import shetiphian.multistorage.Settings;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.common.block.BlockVault;
import shetiphian.multistorage.common.block.VaultHelper;
import shetiphian.multistorage.common.tileentity.IVaultWall;
import shetiphian.multistorage.common.tileentity.TileEntityVaultBroken;
import shetiphian.multistorage.common.tileentity.TileEntityVaultCorer;
import shetiphian.multistorage.common.tileentity.TileEntityVaultDoor;

public class ItemBlockVault
extends ItemBlockMulti {
    public ItemBlockVault(Block block) {
        super(block, "BlockVault", Values.nameMapper);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (Settings.INSTANCE.permissionVault != 0) {
            list.add(new ItemStack((Item)this, 1, 100));
            list.add(new ItemStack((Item)this, 1, 0));
            list.add(new ItemStack((Item)this, 1, 1));
            for (int index = 2; index < 14; ++index) {
                BlockVault.EnumType type = BlockVault.EnumType.byValue(index);
                if (type == null || type.getValue() <= 1) continue;
                list.add(new ItemStack((Item)this, 1, index));
            }
            list.add(new ItemStack((Item)this, 1, 15));
        }
    }

    public int func_77647_b(int damage) {
        return damage > 20 ? 14 : damage;
    }

    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        TileEntity tile;
        if (stack.func_77952_i() == 15 && (!((tile = world.func_175625_s(pos)) instanceof IVaultWall) || tile instanceof TileEntityVaultDoor)) {
            return false;
        }
        return stack.func_77952_i() == 100 || super.func_179222_a(world, pos, side, player, stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (stack.func_77952_i() == 100) {
            if (Values.fluidConcrete != null && Values.fluidConcrete.pourWall(world, pos, player)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                    Function.giveItem((EntityPlayer)player, (ItemStack)new ItemStack(Items.field_151133_ar), null);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        int blockMeta = stack.func_77952_i();
        if (blockMeta > 20) {
            blockMeta = 14;
        }
        if (player instanceof FakePlayer && (blockMeta == 0 || blockMeta == 15)) {
            return EnumActionResult.FAIL;
        }
        if (!(blockMeta != 0 || VaultHelper.canPlayerPlaceDoor(player) && VaultHelper.getDoorStart(world, pos.func_177972_a(facing), player) != null)) {
            return EnumActionResult.FAIL;
        }
        return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (stack.func_77952_i() == 100 || player instanceof FakePlayer && (stack.func_77952_i() == 0 || stack.func_77952_i() == 15)) {
            return false;
        }
        boolean placed = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityVaultBroken) {
            ((TileEntityVaultBroken)tile).setTypeBase(BlockVault.EnumType.byValue(stack.func_77952_i() - 20));
        } else if (tile instanceof TileEntityVaultCorer) {
            ((TileEntityVaultCorer)tile).setFacing(side.func_176734_d());
        }
        return placed;
    }

    protected void addToNameMap() {
        this.add(0, "", "vault#invdoor", "door");
        this.add(1, "vault/", "wall_basic", "wall");
        this.add(2, "vault/", "wall_item", "item");
        this.add(3, "vault/", "wall_redstone", "redstone");
        this.add(4, "vault/", "wall_liquid", "liquid");
        this.add(5, "vault/", "wall_power_eu", "power.eu");
        this.add(6, "vault/", "wall_power_rf", "power.rf");
        this.add(7, "vault/", "wall_power_caps", "power.caps");
        this.add(15, "", "vault#invcorer", "corer");
        this.add(21, "vault/", "wall_basic_broken", "wall.broken");
        this.add(22, "vault/", "wall_item_broken", "item.broken");
        this.add(23, "vault/", "wall_redstone_broken", "redstone.broken");
        this.add(24, "vault/", "wall_liquid_broken", "liquid.broken");
        this.add(25, "vault/", "wall_power_eu_broken", "power.eu.broken");
        this.add(26, "vault/", "wall_power_rf_broken", "power.rf.broken");
        this.add(27, "vault/", "wall_power_caps_broken", "power.caps.broken");
        this.nameMapper.add(this.nameId, 100, "forge", "", "dynbucket", "bucket");
    }
}

