/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.common.network;

import com.google.common.base.Strings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import shetiphian.core.common.network.PacketBase;
import shetiphian.multistorage.client.gui.GuiEnderLink;
import shetiphian.multistorage.common.enderlink.ChestHelper;
import shetiphian.multistorage.common.enderlink.ChestInfoHelper;
import shetiphian.multistorage.common.inventory.ContainerEnderLink;
import shetiphian.multistorage.common.network.NetworkHandler;

public class PacketEnderBag
extends PacketBase {
    private String ownerID;
    private String code;
    private String ownerName;
    private int windowID;

    public PacketEnderBag() {
    }

    public static boolean openBag(EntityPlayer player, String ownerID, String code, String ownerName) {
        if (player instanceof EntityPlayerMP && !(player instanceof FakePlayer)) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.func_71117_bO();
            playerMP.func_71128_l();
            int windowId = playerMP.field_71139_cq;
            NetworkHandler.sendToPlayer(new PacketEnderBag(ownerID, code, ownerName, windowId), playerMP);
            playerMP.field_71070_bA = new ContainerEnderLink(player, ChestHelper.getChest(player.func_130014_f_(), ownerID, code));
            playerMP.field_71070_bA.field_75152_c = windowId;
            playerMP.field_71070_bA.func_75132_a((IContainerListener)playerMP);
            MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open(player, player.field_71070_bA));
            return true;
        }
        return false;
    }

    private PacketEnderBag(String ownerID, String code, String ownerName, int windowID) {
        this.ownerID = ownerID;
        this.code = code;
        this.ownerName = Strings.isNullOrEmpty((String)ownerName) ? ownerID : ownerName;
        this.windowID = windowID;
    }

    public void toBytes(PacketBuffer buffer) {
        this.writeString(buffer, this.ownerID);
        this.writeString(buffer, this.code);
        this.writeString(buffer, this.ownerName);
        buffer.writeInt(this.windowID);
    }

    public void fromBytes(PacketBuffer buffer) {
        this.ownerID = this.readString(buffer);
        this.code = this.readString(buffer);
        this.ownerName = this.readString(buffer);
        this.windowID = buffer.readInt();
    }

    public void handleClientSide(EntityPlayer player) {
        if (Strings.isNullOrEmpty((String)this.ownerID) || Strings.isNullOrEmpty((String)this.code)) {
            ChestInfoHelper.sendError(player, "multistorage.bag.corrupted");
        } else {
            FMLCommonHandler.instance().showGuiScreen((Object)new GuiEnderLink(player, ChestHelper.getChest(player.func_130014_f_(), this.ownerID, this.code), this.ownerName));
            player.field_71070_bA.field_75152_c = this.windowID;
        }
    }

    public void handleServerSide(EntityPlayer player) {
    }

    public static class Handler
    implements IMessageHandler<PacketEnderBag, IMessage> {
        public IMessage onMessage(PacketEnderBag packet, MessageContext ctx) {
            NetworkHandler.onMessage((PacketBase)packet, (MessageContext)ctx);
            return null;
        }
    }
}

