/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multistorage.modintegration;

import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import shetiphian.multistorage.MultiStorage;
import shetiphian.multistorage.Values;
import shetiphian.multistorage.modintegration.enderio.EnderIO_Comms;
import shetiphian.multistorage.modintegration.ichun.iChun_Comms;

public class ModIntegration {
    private static String base = "shetiphian.multistorage.modintegration.";

    public void preInit() {
        ClassLoader classLoader = MultiStorage.class.getClassLoader();
        this.loadAPI(classLoader, "terraqueous.Terraqueous_Active");
    }

    public void load() {
        this.loadAPIs();
        this.sendComms();
    }

    private void loadAPIs() {
        ClassLoader classLoader = MultiStorage.class.getClassLoader();
        if (Values.blockVault != null) {
            this.loadAPI(classLoader, "eu.EU_API_Active");
            this.loadAPI(classLoader, "rf.RF_API_Active");
            this.loadAPI(classLoader, "tesla.Tesla_API_Active");
        }
    }

    private void loadAPI(ClassLoader classLoader, String name) {
        try {
            classLoader.loadClass(base + name).getMethod("init", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void sendComms() {
        FMLInterModComms.sendMessage((String)"shetiphiancore", (String)"loadGuideFile", (String)"MultiStorage:multistorage.json");
        if (Loader.isModLoaded((String)"EnderIO")) {
            EnderIO_Comms.sendComms("EnderIO");
        }
        if (Loader.isModLoaded((String)"PortalGun")) {
            iChun_Comms.sendComms("PortalGun");
        }
        if (Loader.isModLoaded((String)"GraviGun")) {
            iChun_Comms.sendComms("GraviGun");
        }
        if (Loader.isModLoaded((String)"theoneprobe")) {
            FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)(base + "theoneprobe.OneProbeDataProvider$GetTheOneProbe"));
        }
        if (Loader.isModLoaded((String)"Waila")) {
            FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)(base + "waila.WailaDataProvider.callbackRegister"));
        }
    }
}

