/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.FuelHandler;
import mekanism.common.base.ISustainedData;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.GasUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityGasGenerator
extends TileEntityGenerator
implements IGasHandler,
ITubeConnection,
ISustainedData {
    public int MAX_GAS = 18000;
    public GasTank fuelTank;
    public int burnTicks = 0;
    public int maxBurnTicks;
    public double generationRate = 0.0;
    public int clientUsed;
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getGas", "getGasNeeded"};

    public TileEntityGasGenerator() {
        super("gas", "GasGenerator", MekanismConfig.general.FROM_H2 * 100.0, MekanismConfig.general.FROM_H2 * 2.0);
        this.inventory = new ItemStack[2];
        this.fuelTank = new GasTank(this.MAX_GAS);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            boolean operate;
            ChargeUtils.charge((int)1, (IStrictEnergyStorage)this);
            if (this.inventory[0] != null && this.fuelTank.getStored() < this.MAX_GAS) {
                Gas gasType = null;
                if (this.fuelTank.getGas() != null) {
                    gasType = this.fuelTank.getGas().getGas();
                } else if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IGasItem && ((IGasItem)this.inventory[0].func_77973_b()).getGas(this.inventory[0]) != null) {
                    gasType = ((IGasItem)this.inventory[0].func_77973_b()).getGas(this.inventory[0]).getGas();
                }
                if (gasType != null && FuelHandler.getFuel((Gas)gasType) != null) {
                    GasStack removed = GasUtils.removeGas((ItemStack)this.inventory[0], (Gas)gasType, (int)this.fuelTank.getNeeded());
                    boolean isTankEmpty = this.fuelTank.getGas() == null;
                    int fuelReceived = this.fuelTank.receive(removed, true);
                    if (fuelReceived > 0 && isTankEmpty) {
                        this.output = FuelHandler.getFuel((Gas)this.fuelTank.getGas().getGas()).energyPerTick * 2.0;
                    }
                }
            }
            if ((operate = this.canOperate()) && this.getEnergy() + this.generationRate < this.getMaxEnergy()) {
                this.setActive(true);
                FuelHandler.FuelGas fuel = null;
                if (this.fuelTank.getStored() != 0) {
                    fuel = FuelHandler.getFuel((Gas)this.fuelTank.getGas().getGas());
                    this.maxBurnTicks = fuel.burnTicks;
                    this.generationRate = fuel.energyPerTick;
                }
                int toUse = this.getToUse();
                this.output = Math.max(MekanismConfig.general.FROM_H2 * 2.0, this.generationRate * (double)this.getToUse() * 2.0);
                int total = this.burnTicks + this.fuelTank.getStored() * this.maxBurnTicks;
                total -= toUse;
                this.setEnergy(this.getEnergy() + this.generationRate * (double)toUse);
                if (this.fuelTank.getStored() > 0) {
                    this.fuelTank.setGas(new GasStack(this.fuelTank.getGasType(), total / this.maxBurnTicks));
                }
                this.burnTicks = total % this.maxBurnTicks;
                this.clientUsed = toUse;
            } else {
                if (!operate) {
                    this.reset();
                }
                this.clientUsed = 0;
                this.setActive(false);
            }
        }
    }

    public void reset() {
        this.burnTicks = 0;
        this.maxBurnTicks = 0;
        this.generationRate = 0.0;
        this.output = MekanismConfig.general.FROM_H2 * 2.0;
    }

    public int getToUse() {
        if (this.generationRate == 0.0 || this.fuelTank.getGas() == null) {
            return 0;
        }
        int max = (int)Math.ceil((float)this.fuelTank.getStored() / (float)this.fuelTank.getMaxGas() * 256.0f);
        max = Math.min(this.fuelTank.getStored() * this.maxBurnTicks + this.burnTicks, max);
        max = (int)Math.min((this.getMaxEnergy() - this.getEnergy()) / this.generationRate, (double)max);
        return max;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted((ItemStack)itemstack, (boolean)true);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && FuelHandler.getFuel((Gas)((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas()) != null;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] nArray;
        if (side == MekanismUtils.getRight((EnumFacing)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    @Override
    public boolean canOperate() {
        return (this.fuelTank.getStored() > 0 || this.burnTicks > 0) && MekanismUtils.canFunction((TileEntity)this);
    }

    public int getScaledGasLevel(int i) {
        return this.fuelTank.getStored() * i / this.MAX_GAS;
    }

    public String[] getMethods() {
        return methods;
    }

    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
            case 4: {
                return new Object[]{this.fuelTank.getStored()};
            }
            case 5: {
                return new Object[]{this.fuelTank.getNeeded()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (dataStream.readBoolean()) {
                this.fuelTank.setGas(new GasStack(GasRegistry.getGas((int)dataStream.readInt()), dataStream.readInt()));
            } else {
                this.fuelTank.setGas(null);
            }
            this.generationRate = dataStream.readDouble();
            this.output = dataStream.readDouble();
            this.clientUsed = dataStream.readInt();
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.fuelTank.getGas() != null) {
            data.add(true);
            data.add(this.fuelTank.getGas().getGas().getID());
            data.add(this.fuelTank.getStored());
        } else {
            data.add(false);
        }
        data.add(this.generationRate);
        data.add(this.output);
        data.add(this.clientUsed);
        return data;
    }

    public int receiveGas(EnumFacing side, GasStack stack, boolean doTransfer) {
        boolean isTankEmpty;
        boolean bl = isTankEmpty = this.fuelTank.getGas() == null;
        if (this.canReceiveGas(side, stack.getGas()) && (isTankEmpty || this.fuelTank.getGas().isGasEqual(stack))) {
            int fuelReceived = this.fuelTank.receive(stack, doTransfer);
            if (doTransfer && isTankEmpty && fuelReceived > 0) {
                this.output = FuelHandler.getFuel((Gas)this.fuelTank.getGas().getGas()).energyPerTick * 2.0;
            }
            return fuelReceived;
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        FuelHandler.FuelGas fuel;
        super.func_145839_a(nbtTags);
        this.fuelTank.read(nbtTags.func_74775_l("fuelTank"));
        boolean isTankEmpty = this.fuelTank.getGas() == null;
        FuelHandler.FuelGas fuelGas = fuel = isTankEmpty ? null : FuelHandler.getFuel((Gas)this.fuelTank.getGas().getGas());
        if (fuel != null) {
            this.output = fuel.energyPerTick * 2.0;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74782_a("fuelTank", (NBTBase)this.fuelTank.write(new NBTTagCompound()));
        return nbtTags;
    }

    public boolean canReceiveGas(EnumFacing side, Gas type) {
        return FuelHandler.getFuel((Gas)type) != null && side != this.facing;
    }

    public GasStack drawGas(EnumFacing side, int amount, boolean doTransfer) {
        return null;
    }

    public boolean canDrawGas(EnumFacing side, Gas type) {
        return false;
    }

    public boolean canTubeConnect(EnumFacing side) {
        return side != this.facing;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        return capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY || super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == Capabilities.GAS_HANDLER_CAPABILITY || capability == Capabilities.TUBE_CONNECTION_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, side);
    }

    public void writeSustainedData(ItemStack itemStack) {
        if (this.fuelTank != null) {
            ItemDataUtils.setCompound((ItemStack)itemStack, (String)"fuelTank", (NBTTagCompound)this.fuelTank.write(new NBTTagCompound()));
        }
    }

    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData((ItemStack)itemStack, (String)"fuelTank")) {
            FuelHandler.FuelGas fuel;
            this.fuelTank.read(ItemDataUtils.getCompound((ItemStack)itemStack, (String)"fuelTank"));
            boolean isTankEmpty = this.fuelTank.getGas() == null;
            FuelHandler.FuelGas fuelGas = fuel = isTankEmpty ? null : FuelHandler.getFuel((Gas)this.fuelTank.getGas().getGas());
            if (fuel != null) {
                this.output = fuel.energyPerTick * 2.0;
            }
        }
    }
}

