/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.implementation;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.relauncher.Side;
import p455w0rd.wct.WCT;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.api.WCTApi;
import p455w0rd.wct.init.ModConfig;
import p455w0rd.wct.init.ModLogger;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.sync.packets.PacketOpenGui;
import p455w0rd.wct.util.WCTUtils;

public class WCTAPIImpl
extends WCTApi {
    private static WCTAPIImpl INSTANCE = null;

    public static WCTAPIImpl instance() {
        if (INSTANCE == null) {
            if (!WCTAPIImpl.hasFinishedPreInit()) {
                return null;
            }
            INSTANCE = new WCTAPIImpl();
        }
        return INSTANCE;
    }

    protected static boolean hasFinishedPreInit() {
        if (WCT.PROXY.getLoaderState() == LoaderState.NOINIT) {
            ModLogger.warn("API is not available until WCT finishes the PreInit phase.");
            return false;
        }
        return true;
    }

    @Override
    public boolean isInfinityBoosterCardEnabled() {
        return ModConfig.WCT_BOOSTER_ENABLED;
    }

    @Override
    public void openWirelessCraftingTerminalGui(EntityPlayer player) {
        if (player == null || player instanceof FakePlayer || player instanceof EntityPlayerMP || FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return;
        }
        ItemStack is = WCTUtils.getWirelessTerm(player.field_71071_by);
        if (is == null) {
            return;
        }
        if (this.isTerminalLinked(is)) {
            ModNetworking.instance().sendToServer(new PacketOpenGui(0));
        }
    }

    private boolean isTerminalLinked(ItemStack wirelessTerminalItemstack) {
        String sourceKey = "";
        if (wirelessTerminalItemstack.func_77973_b() instanceof IWirelessCraftingTerminalItem && wirelessTerminalItemstack.func_77942_o()) {
            sourceKey = ((IWirelessCraftingTerminalItem)wirelessTerminalItemstack.func_77973_b()).getEncryptionKey(wirelessTerminalItemstack);
            return sourceKey != null && !sourceKey.isEmpty();
        }
        return false;
    }
}

