/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.init;

import appeng.core.AEConfig;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModConfig {
    public static Configuration CONFIG;
    private static final String DEF_CAT = "General";
    private static final String CLIENT_CAT = "Client Configs";
    public static boolean WCT_BOOSTER_ENABLED;
    public static boolean USE_OLD_INFINTY_MECHANIC;
    public static boolean WCT_MINETWEAKER_OVERRIDE;
    public static boolean WCT_ENABLE_CONTROLLER_CHUNKLOADER;
    public static boolean WCT_WITHER_DROPS_BOOSTER;
    public static boolean WCT_DRAGON_DROPS_BOOSTER;
    public static int WCT_BOOSTER_DROP_CHANCE;
    public static int WCT_MAX_POWER;
    public static boolean WCT_DISABLE_BOOSTER_RECIPE;
    public static int INFINITY_ENERGY_PER_BOOSTER_CARD;
    public static int INFINITY_ENERGY_DRAIN;
    public static int INFINTY_ENERGY_LOW_WARNING_AMOUNT;
    public static boolean WCT_ENDERMAN_DROP_BOOSTERS;
    public static int WCT_ENDERMAN_BOOSTER_DROP_CHANCE;

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals("wct")) {
            ModConfig.preInit();
        }
    }

    public static void preInit() {
        if (CONFIG == null) {
            CONFIG = new Configuration(new File("config/WirelessCraftingTerminal.cfg"));
            MinecraftForge.EVENT_BUS.register((Object)new ModConfig());
        }
        WCT_BOOSTER_ENABLED = CONFIG.getBoolean("EnableBooster", DEF_CAT, true, "Enable Infinity Booster Card");
        WCT_ENABLE_CONTROLLER_CHUNKLOADER = CONFIG.getBoolean("EnableControllerChunkLoading", DEF_CAT, true, "If true, AE2 controller will chunk load itself");
        WCT_BOOSTER_DROP_CHANCE = CONFIG.getInt("BoosterDropChance", DEF_CAT, 30, 1, 100, "Percentage chance that booster card will drop upon killing a wither. (between 1 and 100)");
        WCT_ENDERMAN_DROP_BOOSTERS = CONFIG.getBoolean("EndermanDropBoosters", DEF_CAT, true, "Will Enderman randomly drop infinity booster cards on death?");
        WCT_ENDERMAN_BOOSTER_DROP_CHANCE = CONFIG.getInt("EndermanBoosterDropChance", DEF_CAT, 5, 1, 100, "Percentage chance that booster card will drop upon killing an Enderman. (between 1 and 100)");
        WCT_WITHER_DROPS_BOOSTER = CONFIG.getBoolean("WitherDropsBooster", DEF_CAT, true, "Should Withers drop Infinity Booster Card?");
        WCT_DRAGON_DROPS_BOOSTER = CONFIG.getBoolean("DragonDropsBooster", DEF_CAT, true, "Should Dragons drop Infinity Booster Card?");
        WCT_DISABLE_BOOSTER_RECIPE = CONFIG.getBoolean("DisableBoosterRecipe", DEF_CAT, false, "Should Infinity Booster Card Recipe be disable?");
        USE_OLD_INFINTY_MECHANIC = CONFIG.getBoolean("UseOldInfinityMechanic", DEF_CAT, false, "If true, then simply inserting 1 Infinity Booster Card into the slot, will give limitless infinite range.");
        INFINITY_ENERGY_PER_BOOSTER_CARD = CONFIG.getInt("InfinityEnergyPerBooster", DEF_CAT, 100, 5, 1000, "Amount of Infinity Energy 1 Infinity Booster Card will convert to");
        INFINITY_ENERGY_DRAIN = CONFIG.getInt("InfinityEnergyDrainAmount", DEF_CAT, 15, 5, 100, "Amount of Infinity Energy Consumed every 10 ticks when not in range of a WAP");
        INFINTY_ENERGY_LOW_WARNING_AMOUNT = CONFIG.getInt("InfinityEnergyWarningAmount", CLIENT_CAT, 5000, 10, 1000000, "WCT will show a warning when Infinty Energy drops below this point and infinite range is active");
        if (CONFIG.hasChanged()) {
            CONFIG.save();
        }
    }

    static {
        WCT_BOOSTER_ENABLED = true;
        USE_OLD_INFINTY_MECHANIC = false;
        WCT_MINETWEAKER_OVERRIDE = false;
        WCT_ENABLE_CONTROLLER_CHUNKLOADER = true;
        WCT_WITHER_DROPS_BOOSTER = true;
        WCT_DRAGON_DROPS_BOOSTER = true;
        WCT_BOOSTER_DROP_CHANCE = 30;
        WCT_MAX_POWER = AEConfig.instance().getWirelessTerminalBattery();
        WCT_DISABLE_BOOSTER_RECIPE = false;
        INFINITY_ENERGY_PER_BOOSTER_CARD = 100;
        INFINITY_ENERGY_DRAIN = 15;
        INFINTY_ENERGY_LOW_WARNING_AMOUNT = 5000;
        WCT_ENDERMAN_DROP_BOOSTERS = true;
        WCT_ENDERMAN_BOOSTER_DROP_CHANCE = 5;
    }
}

