/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.items;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import com.google.common.base.Splitter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;
import p455w0rd.wct.api.IWirelessCraftingTermHandler;
import p455w0rd.wct.api.networking.security.WCTPlayerSource;
import p455w0rd.wct.helpers.WCTGuiObject;
import p455w0rd.wct.init.ModGuiHandler;
import p455w0rd.wct.init.ModItems;
import p455w0rd.wct.init.ModKeybindings;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.items.ItemBase;
import p455w0rd.wct.sync.packets.PacketMagnetFilter;
import p455w0rd.wct.sync.packets.PacketSetMagnet;
import p455w0rd.wct.util.WCTUtils;
import p455w0rdslib.util.EntityItemUtils;
import p455w0rdslib.util.ItemUtils;

public class ItemMagnet
extends ItemBase {
    private int distanceFromPlayer;
    private WCTGuiObject obj;
    private IEnergySource powerSrc;
    private IActionSource mySrc;
    private ItemStack thisItemStack = ItemStack.field_190927_a;
    private int pickupTimer = 0;
    private static final String name = "magnet_card";

    public ItemMagnet() {
        super(name);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack item) {
        return this.isActivated(item);
    }

    public void setItemStack(@Nonnull ItemStack is) {
        this.thisItemStack = is;
    }

    public boolean func_77645_m() {
        return false;
    }

    public ItemStack getItemStack() {
        if (this.thisItemStack != null && this.thisItemStack.func_77973_b() == ModItems.MAGNET_CARD) {
            return this.thisItemStack;
        }
        return ItemStack.field_190927_a;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack is, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.add(this.color("aqua") + "==============================");
        String shift = I18n.func_135052_a((String)"tooltip.press_shift.desc", (Object[])new Object[0]).replace("Shift", this.color("yellow") + this.color("bold") + this.color("italics") + "Shift" + this.color("gray"));
        if (ItemMagnet.isShiftKeyDown()) {
            ItemStack itemStack = this.getItemStack();
            String info = I18n.func_135052_a((String)"tooltip.magnet.desc", (Object[])new Object[0]);
            for (String line : Splitter.on((String)"\n").split((CharSequence)WordUtils.wrap((String)info, (int)37, (String)"\n", (boolean)false))) {
                list.add(line.trim());
            }
            list.add("");
            list.add(this.color("italics") + "" + I18n.func_135052_a((String)"tooltip.magnet_set_filter.desc", (Object[])new Object[0]));
            if (this.isActivated(itemStack)) {
                String boundKey2;
                String boundKey = ModKeybindings.openMagnetFilter.getDisplayName();
                if (!boundKey.equals("NONE")) {
                    list.add(this.color("italics") + I18n.func_135052_a((String)"tooltip.or_press.desc", (Object[])new Object[0]) + " " + this.color("yellow") + this.color("bold") + "[" + boundKey + "]");
                }
                if (!(boundKey2 = ModKeybindings.changeMagnetMode.getDisplayName()).equals("NONE")) {
                    list.add(this.color("italics") + I18n.func_135052_a((String)"tooltip.press.desc", (Object[])new Object[0]) + " " + this.color("yellow") + this.color("bold") + "[" + boundKey2 + "] " + this.color("gray") + this.color("italics") + I18n.func_135052_a((String)"tooltip.to_switch.desc", (Object[])new Object[0]));
                }
            }
            list.add("");
            list.add(I18n.func_135052_a((String)"tooltip.status.desc", (Object[])new Object[0]) + ": " + (this.isActivated(is) ? this.color("green") + I18n.func_135052_a((String)"tooltip.active.desc", (Object[])new Object[0]) : this.color("red") + I18n.func_135052_a((String)"tooltip.active.desc", (Object[])new Object[0])));
            if (ItemMagnet.getDamageUnsafe(is) == 1) {
                list.add(this.color("white") + "  " + I18n.func_135052_a((String)"tooltip.magnet_active_1.desc", (Object[])new Object[0]));
            } else if (ItemMagnet.getDamageUnsafe(is) == 2) {
                list.add(this.color("white") + "  " + I18n.func_135052_a((String)"tooltip.magnet_active_2.desc", (Object[])new Object[0]));
            }
            String white = I18n.func_135052_a((String)"tooltip.magnet_whitelisting.desc", (Object[])new Object[0]);
            String black = I18n.func_135052_a((String)"tooltip.magnet_blacklisting.desc", (Object[])new Object[0]);
            list.add(I18n.func_135052_a((String)"tooltip.filter_mode.desc", (Object[])new Object[0]) + ": " + this.color("white") + (this.getMode(is) ? white : black));
            String not = I18n.func_135052_a((String)"tooltip.not.desc", (Object[])new Object[0]);
            String ignoring = I18n.func_135052_a((String)"tooltip.ignoring.desc", (Object[])new Object[0]);
            String nbtData = I18n.func_135052_a((String)"tooltip.nbt.desc", (Object[])new Object[0]);
            String metaData = I18n.func_135052_a((String)"tooltip.meta.desc", (Object[])new Object[0]);
            String usingOreDict = I18n.func_135052_a((String)"tooltip.using.desc", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"tooltip.oredict.desc", (Object[])new Object[0]);
            list.add((!this.doesMagnetUseOreDict() ? " " + not : this.color("green")) + " " + usingOreDict);
            list.add((!this.doesMagnetIgnoreNBT() ? " " + not : this.color("green")) + " " + ignoring + " " + nbtData);
            list.add((!this.doesMagnetIgnoreMeta() ? " " + not : this.color("green")) + " " + ignoring + " " + metaData);
            NonNullList<ItemStack> filteredItems = this.getFilteredItems(itemStack);
            if (filteredItems != null) {
                list.add("");
                list.add(this.color("gray") + I18n.func_135052_a((String)"tooltip.filtered_items.desc", (Object[])new Object[0]) + ":");
                for (int i = 0; i < filteredItems.size(); ++i) {
                    list.add("  " + ((ItemStack)filteredItems.get(i)).func_82833_r());
                }
            }
            list.add("");
            String onlyWorks = I18n.func_135052_a((String)"tooltip.only_works.desc", (Object[])new Object[0]);
            for (String line : Splitter.on((String)"\n").split((CharSequence)WordUtils.wrap((String)onlyWorks, (int)27, (String)"\n", (boolean)false))) {
                list.add(this.color("white") + this.color("bold") + this.color("italics") + line.trim());
            }
        } else {
            list.add(shift);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String color(String color) {
        return WCTUtils.color(color);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (world.field_72995_K && hand == EnumHand.MAIN_HAND && !item.func_190926_b()) {
            if (!WCTUtils.isMagnetInitialized(item)) {
                ModNetworking.instance().sendToServer(new PacketMagnetFilter(0, true));
            }
            if (player.func_70093_af()) {
                ItemMagnet.switchMagnetMode(item);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
            }
            int x = (int)player.field_70165_t;
            int y = (int)player.field_70163_u;
            int z = (int)player.field_70161_v;
            ModGuiHandler.open(4, player, world, new BlockPos(x, y, z));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)item);
    }

    public static String getMessage(int mode) {
        switch (mode) {
            case 1: {
                return I18n.func_135052_a((String)"chatmessages.magnet_activated.desc", (Object[])new Object[0]) + " - " + I18n.func_135052_a((String)"tooltip.magnet_active_1.desc", (Object[])new Object[0]);
            }
            case 2: {
                return I18n.func_135052_a((String)"chatmessages.magnet_activated.desc", (Object[])new Object[0]) + " - " + I18n.func_135052_a((String)"tooltip.magnet_active_2.desc", (Object[])new Object[0]);
            }
        }
        return I18n.func_135052_a((String)"chatmessages.magnet_deactivated.desc", (Object[])new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public static void displayMessage(int mode) {
        EntityPlayer player = WCTUtils.player();
        WCTUtils.chatMessage(player, (ITextComponent)new TextComponentString(ItemMagnet.getMessage(mode)));
    }

    public static void switchMagnetMode(@Nonnull ItemStack item) {
        if (item == null || item.func_190926_b()) {
            return;
        }
        int newMode = 0;
        newMode = ItemMagnet.getDamageUnsafe(item) == 0 ? 1 : (ItemMagnet.getDamageUnsafe(item) == 1 ? 2 : 0);
        ItemMagnet.setDamageUnsafe(item, newMode);
        ItemMagnet.displayMessage(newMode);
        ModNetworking.instance().sendToServer(new PacketSetMagnet(newMode));
    }

    public static int getDamageUnsafe(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
                if (!stack.func_77978_p().func_74764_b("MagnetMode")) {
                    stack.func_77978_p().func_74768_a("MagnetMode", 0);
                }
            }
            return stack.func_77978_p().func_74762_e("MagnetMode");
        }
        return -1;
    }

    public static void setDamageUnsafe(@Nonnull ItemStack stack, int damage) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("MagnetMode", damage);
    }

    public void doMagnet(@Nonnull ItemStack item, World world, EntityPlayer player, @Nonnull ItemStack wirelessTerm) {
        if (world.field_72995_K) {
            return;
        }
        if (this.getItemStack().func_190926_b()) {
            return;
        }
        if (!this.isActivated(item)) {
            return;
        }
        if (player == null) {
            return;
        }
        if (player.func_70093_af()) {
            return;
        }
        this.distanceFromPlayer = 6;
        NonNullList<ItemStack> filteredList = this.getFilteredItems(this.getItemStack());
        for (EntityItem entityItem : ItemMagnet.getEntitiesInRange(EntityItem.class, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, this.distanceFromPlayer)) {
            if (entityItem == null) {
                return;
            }
            if (EntityItemUtils.getThrowerName((EntityItem)entityItem) != null && EntityItemUtils.getThrowerName((EntityItem)entityItem).equals(player.func_70005_c_()) && !EntityItemUtils.canPickup((EntityItem)entityItem)) continue;
            ItemStack itemStackToGet = entityItem.func_92059_d();
            if (itemStackToGet.func_190926_b()) {
                return;
            }
            int stackSize = itemStackToGet.func_190916_E();
            this.obj = this.getGuiObject(wirelessTerm, player, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            this.powerSrc = this.obj;
            this.mySrc = new WCTPlayerSource(player, this.obj);
            boolean ignoreRange = WCTUtils.hasInfiniteRange(wirelessTerm);
            boolean hasAxxess = this.hasNetworkAccess(SecurityPermissions.INJECT, true, player, wirelessTerm);
            if ((!ignoreRange || !hasAxxess) && (!this.obj.rangeCheck() || !hasAxxess)) continue;
            IAEItemStack ais = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)itemStackToGet);
            ais.setStackSize((long)stackSize);
            if (entityItem.field_70128_L) continue;
            if (this.getMode(this.getItemStack())) {
                if (this.isItemFiltered(itemStackToGet, filteredList) && !filteredList.isEmpty()) {
                    if (!this.doInject(ais, stackSize, player, entityItem, itemStackToGet, world)) continue;
                    entityItem.func_70106_y();
                    continue;
                }
                if (ItemMagnet.getDamageUnsafe(item) != 1) continue;
                this.doInventoryPickup(entityItem, player, itemStackToGet, world, stackSize);
                continue;
            }
            if (!this.isItemFiltered(itemStackToGet, filteredList) || filteredList.isEmpty()) {
                if (!this.doInject(ais, stackSize, player, entityItem, itemStackToGet, world)) continue;
                entityItem.func_70106_y();
                continue;
            }
            if (ItemMagnet.getDamageUnsafe(item) != 1) continue;
            this.doInventoryPickup(entityItem, player, itemStackToGet, world, stackSize);
        }
        for (EntityXPOrb entityXPOrb : ItemMagnet.getEntitiesInRange(EntityXPOrb.class, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v, this.distanceFromPlayer)) {
            if (entityXPOrb.field_70128_L || entityXPOrb.func_82150_aj()) continue;
            int xpAmount = entityXPOrb.field_70530_e;
            entityXPOrb.func_70106_y();
            world.func_184148_a((EntityPlayer)null, entityXPOrb.field_70165_t, entityXPOrb.field_70163_u, entityXPOrb.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            ItemStack itemstack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)player);
            if (!itemstack.func_190926_b() && itemstack.func_77951_h()) {
                int i = Math.min(this.xpToDurability(xpAmount), itemstack.func_77952_i());
                xpAmount -= this.durabilityToXp(i);
                itemstack.func_77964_b(itemstack.func_77952_i() - i);
            }
            if (xpAmount <= 0) continue;
            player.func_71023_q(xpAmount);
        }
    }

    private int durabilityToXp(int durability) {
        return durability / 2;
    }

    private int xpToDurability(int xp) {
        return xp * 2;
    }

    private void doInventoryPickup(EntityItem itemToGet, EntityPlayer player, ItemStack itemStackToGet, World world, int stackSize) {
        if (itemToGet.func_70032_d((Entity)player) <= (float)this.distanceFromPlayer && player.field_71071_by.func_70441_a(itemStackToGet)) {
            player.func_71001_a((Entity)itemToGet, stackSize);
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.1f, 0.5f * ((WCTUtils.world((EntityPlayer)player).field_73012_v.nextFloat() - WCTUtils.world((EntityPlayer)player).field_73012_v.nextFloat()) * 0.7f + 2.0f));
        }
    }

    private boolean doesMagnetIgnoreNBT() {
        return ItemUtils.readBoolean((ItemStack)this.getItemStack(), (String)"IgnoreNBT");
    }

    private boolean doesMagnetIgnoreMeta() {
        return ItemUtils.readBoolean((ItemStack)this.getItemStack(), (String)"IgnoreMeta");
    }

    private boolean doesMagnetUseOreDict() {
        return ItemUtils.readBoolean((ItemStack)this.getItemStack(), (String)"UseOreDict");
    }

    private boolean areOresEqual(ItemStack is1, ItemStack is2) {
        int[] list1 = OreDictionary.getOreIDs((ItemStack)is1);
        int[] list2 = OreDictionary.getOreIDs((ItemStack)is2);
        for (int element : list1) {
            for (int element2 : list2) {
                if (element != element2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isItemFiltered(@Nonnull ItemStack is, NonNullList<ItemStack> itemList) {
        if (!is.func_190926_b() && !itemList.isEmpty()) {
            for (int i = 0; i < itemList.size(); ++i) {
                ItemStack thisStack = (ItemStack)itemList.get(i);
                if (this.doesMagnetUseOreDict() && this.areOresEqual(is, thisStack)) {
                    return true;
                }
                if (!(this.doesMagnetIgnoreMeta() && this.doesMagnetIgnoreNBT() ? is.func_77973_b().equals(thisStack.func_77973_b()) : (this.doesMagnetIgnoreMeta() && !this.doesMagnetIgnoreNBT() ? ItemStack.func_77970_a((ItemStack)is, (ItemStack)thisStack) && is.func_77973_b() == thisStack.func_77973_b() : (!this.doesMagnetIgnoreMeta() && this.doesMagnetIgnoreNBT() && is.func_77973_b() == thisStack.func_77973_b() ? this.isMetaEqual(is, thisStack) : this.isMetaEqual(is, thisStack) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)thisStack) && is.func_77973_b() == thisStack.func_77973_b())))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMetaEqual(@Nonnull ItemStack is1, @Nonnull ItemStack is2) {
        return is1.func_77952_i() == is2.func_77952_i();
    }

    private boolean hasNetworkAccess(SecurityPermissions perm, boolean requirePower, EntityPlayer player, @Nonnull ItemStack wirelessTerm) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        IGrid g = this.obj.getTargetGrid();
        if (g != null) {
            IEnergyGrid eg;
            if (requirePower && !(eg = (IEnergyGrid)g.getCache(IEnergyGrid.class)).isNetworkPowered()) {
                return false;
            }
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            if (sg.hasPermission(player, perm)) {
                return true;
            }
        }
        return false;
    }

    private NonNullList<ItemStack> getFilteredItems(@Nonnull ItemStack magnetItem) {
        if (magnetItem.func_190926_b()) {
            return NonNullList.func_191196_a();
        }
        if (magnetItem.func_77973_b() == ModItems.MAGNET_CARD && magnetItem.func_77942_o()) {
            NBTTagCompound nbtTC = magnetItem.func_77978_p();
            if (!nbtTC.func_74764_b("MagnetFilter")) {
                return NonNullList.func_191196_a();
            }
            NBTTagList tagList = nbtTC.func_150295_c("MagnetFilter", 10);
            if (tagList.func_74745_c() > 0 && tagList != null) {
                NonNullList itemList = NonNullList.func_191196_a();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    itemList.add((Object)new ItemStack(tagList.func_150305_b(i)));
                }
                return itemList;
            }
        }
        return NonNullList.func_191196_a();
    }

    private boolean doInject(IAEItemStack ais, int stackSize, EntityPlayer player, EntityItem itemToGet, @Nonnull ItemStack itemStackToGet, World world) {
        ais = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).poweredInsert(this.powerSrc, (IMEInventory)this.obj, (IAEStack)ais, this.mySrc);
        if (ais != null && !WCTUtils.getMagnet(player.field_71071_by).func_190926_b() && WCTUtils.getMagnet(player.field_71071_by).func_77952_i() != 2) {
            player.func_71001_a((Entity)itemToGet, stackSize);
            player.field_71071_by.func_70441_a(itemStackToGet);
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.1f, 0.5f * ((WCTUtils.world((EntityPlayer)player).field_73012_v.nextFloat() - WCTUtils.world((EntityPlayer)player).field_73012_v.nextFloat()) * 0.7f + 2.0f));
        }
        return ais == null;
    }

    private boolean getMode(@Nonnull ItemStack magnetItem) {
        NBTTagCompound nbtTC;
        if (magnetItem.func_77973_b() == ModItems.MAGNET_CARD && magnetItem.func_77942_o() && (nbtTC = magnetItem.func_77978_p()).func_74764_b("Whitelisting")) {
            return nbtTC.func_74767_n("Whitelisting");
        }
        return true;
    }

    private WCTGuiObject getGuiObject(@Nonnull ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (!it.func_190926_b() && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WCTGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    public static List<? extends Entity> getEntitiesInRange(Class<? extends Entity> entityType, World world, int x, int y, int z, int distance) {
        return world.func_72872_a(entityType, new AxisAlignedBB((double)(x - distance), (double)(y - distance), (double)(z - distance), (double)(x + distance), (double)(y + distance), (double)(z + distance)));
    }

    @Nonnull
    public ItemStack getStack() {
        return this.getStack(1);
    }

    @Nonnull
    public ItemStack getStack(int size) {
        return new ItemStack((Item)this, size);
    }

    public boolean isActivated(@Nonnull ItemStack item) {
        if (item.func_190926_b()) {
            return false;
        }
        return ItemMagnet.getDamageUnsafe(item) > 0;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i < 3; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    public static enum MagnetMode {
        INACTIVE,
        ACTIVE_KEEP,
        ACTIVE_LEAVE;

    }
}

