/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.items;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.util.IConfigManager;
import appeng.core.localization.GuiText;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import baubles.api.BaubleType;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.lwjgl.input.Keyboard;
import p455w0rd.wct.api.IBaubleItem;
import p455w0rd.wct.api.IBaubleRender;
import p455w0rd.wct.api.IModelHolder;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.client.render.RenderLayerWCT;
import p455w0rd.wct.client.render.StackSizeRenderer;
import p455w0rd.wct.init.ModConfig;
import p455w0rd.wct.init.ModCreativeTab;
import p455w0rd.wct.init.ModGuiHandler;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.sync.packets.PacketSetInRange;
import p455w0rd.wct.util.WCTUtils;

@Optional.InterfaceList(value={@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles|API", striprefs=true)})
public class ItemWCT
extends AEBasePoweredItem
implements IModelHolder,
IWirelessCraftingTerminalItem,
IBaubleItem {
    public static double GLOBAL_POWER_MULTIPLIER = PowerMultiplier.CONFIG.multiplier;
    private EntityPlayer entityPlayer;

    public ItemWCT() {
        this("wct");
    }

    public ItemWCT(String name) {
        super((double)ModConfig.WCT_MAX_POWER);
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77625_d(1);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.func_77637_a(ModCreativeTab.CREATIVE_TAB);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND && !item.func_190926_b() && this.getAECurrentPower(item) > 0.0) {
            ModGuiHandler.open(0, player, world, player.func_180425_c());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
        }
        if (this.getAECurrentPower(item) <= 0.0 && !world.field_72995_K) {
            WCTUtils.chatMessage(player, (ITextComponent)new TextComponentString("No Power"));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean showDurabilityBar(ItemStack is) {
        double aeMaxPower;
        double aeCurrPower = this.getAECurrentPower(is);
        if ((int)aeCurrPower >= (int)(aeMaxPower = this.getAEMaxPower(is))) {
            return false;
        }
        return !WCTUtils.isWCTCreative(is);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack is, World world, List<String> list, ITooltipFlag advancedTooltips) {
        if (this.entityPlayer == null || WCTUtils.getGUIObject(is, this.entityPlayer) == null) {
            return;
        }
        String encKey = this.getEncryptionKey(is);
        String shift = I18n.func_135052_a((String)"tooltip.press_shift.desc", (Object[])new Object[0]).replace("Shift", TextFormatting.YELLOW + "" + TextFormatting.BOLD + "" + TextFormatting.ITALIC + "Shift" + TextFormatting.GRAY);
        String pctTxtColor = TextFormatting.WHITE + "";
        double aeCurrPower = this.getAECurrentPower(is);
        double aeCurrPowerPct = (double)((int)Math.floor(aeCurrPower / this.getAEMaxPower(is) * 10000.0)) / 100.0;
        if ((int)aeCurrPowerPct >= 75) {
            pctTxtColor = TextFormatting.GREEN + "";
        }
        if ((int)aeCurrPowerPct <= 5) {
            pctTxtColor = TextFormatting.RED + "";
        }
        list.add(TextFormatting.AQUA + "==============================");
        if (WCTUtils.isWCTCreative(is)) {
            list.add(GuiText.StoredEnergy.getLocal() + ": " + TextFormatting.GREEN + "" + I18n.func_135052_a((String)"tooltip.infinite.desc", (Object[])new Object[0]));
        } else {
            list.add(GuiText.StoredEnergy.getLocal() + ": " + pctTxtColor + (int)aeCurrPower + " AE - " + aeCurrPowerPct + "%");
        }
        String linked = TextFormatting.RED + GuiText.Unlinked.getLocal();
        if (encKey != null && !encKey.isEmpty()) {
            linked = TextFormatting.BLUE + GuiText.Linked.getLocal();
        }
        list.add("Link Status: " + linked);
        String magnetStatus = (WCTUtils.isMagnetInstalled(is) ? TextFormatting.GREEN + "" : TextFormatting.RED + "" + I18n.func_135052_a((String)"tooltip.not.desc", (Object[])new Object[0])) + " " + I18n.func_135052_a((String)"tooltip.installed.desc", (Object[])new Object[0]);
        if (ModConfig.WCT_BOOSTER_ENABLED) {
            if (ModConfig.USE_OLD_INFINTY_MECHANIC) {
                list.add(I18n.func_135052_a((String)"item.infinity_booster_card.name", (Object[])new Object[0]) + ": " + (this.checkForBooster(is) ? TextFormatting.GREEN + "" : TextFormatting.RED + "" + I18n.func_135052_a((String)"tooltip.not.desc", (Object[])new Object[0])) + " " + I18n.func_135052_a((String)"tooltip.installed.desc", (Object[])new Object[0]));
            } else {
                boolean outsideOfWAPRange;
                int infinityEnergyAmount = WCTUtils.getInfinityEnergy(is);
                String amountColor = infinityEnergyAmount < ModConfig.INFINTY_ENERGY_LOW_WARNING_AMOUNT ? TextFormatting.RED.toString() : TextFormatting.GREEN.toString();
                String reasonString = "";
                if (infinityEnergyAmount <= 0) {
                    reasonString = "(" + I18n.func_135052_a((String)"tooltip.out_of.desc", (Object[])new Object[0]) + " " + I18n.func_135052_a((String)"tooltip.infinity_energy.desc", (Object[])new Object[0]) + ")";
                }
                boolean bl = outsideOfWAPRange = !WCTUtils.isInRange(is);
                if (!outsideOfWAPRange) {
                    reasonString = I18n.func_135052_a((String)"tooltip.in_wap_range.desc", (Object[])new Object[0]);
                }
                String activeString = infinityEnergyAmount > 0 && outsideOfWAPRange ? TextFormatting.GREEN + "" + I18n.func_135052_a((String)"tooltip.active.desc", (Object[])new Object[0]) : TextFormatting.GRAY + "" + I18n.func_135052_a((String)"tooltip.inactive.desc", (Object[])new Object[0]) + " " + reasonString;
                list.add(I18n.func_135052_a((String)"tooltip.infinite_range.desc", (Object[])new Object[0]) + ": " + activeString);
                String infinityEnergyString = WCTUtils.isWCTCreative(is) ? I18n.func_135052_a((String)"tooltip.infinite.desc", (Object[])new Object[0]) : (ItemWCT.isShiftKeyDown() ? "" + infinityEnergyAmount + "" + TextFormatting.GRAY + " " + I18n.func_135052_a((String)"tooltip.units.desc", (Object[])new Object[0]) : StackSizeRenderer.ReadableNumberConverter.INSTANCE.toSlimReadableForm(infinityEnergyAmount));
                list.add(I18n.func_135052_a((String)"tooltip.infinity_energy.desc", (Object[])new Object[0]) + ": " + amountColor + "" + infinityEnergyString);
            }
        }
        list.add(I18n.func_135052_a((String)"item.magnet_card.name", (Object[])new Object[0]) + ": " + magnetStatus);
    }

    @Override
    public boolean isWirelessCraftingEnabled(ItemStack wirelessTerminal) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount, Actionable.MODULATE) >= amount - 0.5;
    }

    public boolean hasPower(EntityPlayer player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    public IConfigManager getConfigManager(ItemStack target) {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData((ItemStack)target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT(Platform.openNbtData((ItemStack)target).func_74737_b());
        return out;
    }

    public String getEncryptionKey(ItemStack item) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)item);
        return tag.func_74779_i("encryptionKey");
    }

    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        NBTTagCompound tag = Platform.openNbtData((ItemStack)item);
        tag.func_74778_a("encryptionKey", encKey);
        tag.func_74778_a("name", name);
    }

    public boolean canHandle(ItemStack is) {
        return is.func_77973_b() == this;
    }

    private double injectPower(PowerUnits inputUnit, ItemStack is, double amount, boolean simulate) {
        if (simulate) {
            int requiredExt = (int)PowerUnits.AE.convertTo(inputUnit, this.getAEMaxPower(is) - this.getAECurrentPower(is));
            if (amount < (double)requiredExt) {
                return 0.0;
            }
            return amount - (double)requiredExt;
        }
        double powerRemainder = this.injectAEPower(is, inputUnit.convertTo(PowerUnits.AE, amount), simulate ? Actionable.SIMULATE : Actionable.MODULATE);
        return PowerUnits.AE.convertTo(inputUnit, powerRemainder);
    }

    public double injectAEPower(ItemStack is, double amount, Actionable mode) {
        double maxStorage = this.getAEMaxPower(is);
        double currentStorage = this.getAECurrentPower(is);
        double required = maxStorage - currentStorage;
        double overflow = Math.min(amount * 2.0 - required, amount - required);
        if (mode == Actionable.MODULATE) {
            NBTTagCompound data = Platform.openNbtData((ItemStack)is);
            double toAdd = Math.min(amount * 2.0, required);
            data.func_74780_a("internalCurrentPower", currentStorage + toAdd);
        }
        return Math.max(0.0, overflow);
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack is, int maxReceive, boolean simulate) {
        return maxReceive - (int)this.injectPower(PowerUnits.RF, is, maxReceive, simulate);
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack is) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(is));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack is) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(is));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack is) {
        if (ModConfig.USE_OLD_INFINTY_MECHANIC) {
            return this.checkForBooster(is);
        }
        return WCTUtils.hasInfiniteRange(is) && !WCTUtils.isInRange(is) && this.getEncryptionKey(is) != null && !this.getEncryptionKey(is).isEmpty();
    }

    public void func_77663_a(ItemStack wirelessTerminal, World w, Entity e, int i, boolean f) {
        if (!(e instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer p = (EntityPlayer)e;
        if (this.entityPlayer == null) {
            this.entityPlayer = p;
        }
        if (wirelessTerminal == null || !(wirelessTerminal.func_77973_b() instanceof IWirelessCraftingTerminalItem)) {
            return;
        }
        if (p instanceof EntityPlayerMP) {
            this.rangeCheck(wirelessTerminal, (EntityPlayerMP)p);
        }
        WCTUtils.isBoosterInstalled(wirelessTerminal);
        WCTUtils.isMagnetInstalled(wirelessTerminal);
    }

    private void rangeCheck(ItemStack wirelessTerm, EntityPlayerMP player) {
        boolean currentValue;
        boolean inRange = WCTUtils.isInRangeOfWAP(wirelessTerm, (EntityPlayer)player);
        if (inRange != (currentValue = WCTUtils.isInRange(wirelessTerm))) {
            WCTUtils.setInRange(wirelessTerm, inRange);
            ModNetworking.instance().sendTo(new PacketSetInRange(inRange), player);
        }
    }

    @Override
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.HEAD;
    }

    @Override
    public IBaubleRender getRender() {
        return RenderLayerWCT.getInstance();
    }

    @Override
    public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase playerIn) {
        if (playerIn instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)playerIn;
            this.rangeCheck(itemstack, player);
        }
    }
}

