/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.util;

import appeng.api.features.IWirelessTermHandler;
import appeng.api.implementations.tiles.IWirelessAccessPoint;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.container.ContainerMagnet;
import p455w0rd.wct.container.ContainerWCT;
import p455w0rd.wct.helpers.WCTGuiObject;
import p455w0rd.wct.init.ModConfig;
import p455w0rd.wct.init.ModIntegration;
import p455w0rd.wct.init.ModItems;
import p455w0rd.wct.init.ModKeybindings;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.integration.Baubles;
import p455w0rd.wct.items.ItemInfinityBooster;
import p455w0rd.wct.items.ItemMagnet;
import p455w0rd.wct.sync.packets.PacketMagnetFilter;
import p455w0rd.wct.sync.packets.PacketOpenGui;
import p455w0rd.wct.sync.packets.PacketSyncInfinityEnergy;

public class WCTUtils {
    public static final String INFINITY_ENERGY_NBT = "InfinityEnergy";
    public static final String BOOSTER_SLOT_NBT = "BoosterSlot";
    public static final String MAGNET_SLOT_NBT = "MagnetSlot";
    public static final String TIMER_RESET_NBT = "WCTReset";
    public static final String TIMER_PICKUP_NBT = "WCTPickupTimer";
    public static final String IN_RANGE_NBT = "IsInRange";
    public static final String AUTOCONSUME_BOOSTER_NBT = "AutoConsumeBoosters";
    public static final String MAGNET_MODE_NBT = "MagnetMode";

    public static NonNullList<ItemStack> getWirelessTerminals(EntityPlayer player) {
        NonNullList terminalList = NonNullList.func_191196_a();
        InventoryPlayer playerInventory = player.field_71071_by;
        for (ItemStack wirelessTerm : playerInventory.field_70462_a) {
            if (!WCTUtils.isAnyWCT(wirelessTerm)) continue;
            terminalList.add((Object)wirelessTerm);
        }
        if (ModIntegration.Mods.BAUBLES.isLoaded() && !Baubles.getWCTBauble(player).func_190926_b()) {
            terminalList.add((Object)Baubles.getWCTBauble(player));
        }
        return terminalList;
    }

    @Nonnull
    public static ItemStack getWirelessTerm(InventoryPlayer playerInv) {
        if (!playerInv.field_70458_d.func_184614_ca().func_190926_b() && playerInv.field_70458_d.func_184614_ca().func_77973_b() instanceof IWirelessCraftingTerminalItem) {
            return playerInv.field_70458_d.func_184614_ca();
        }
        ItemStack wirelessTerm = ItemStack.field_190927_a;
        if (ModIntegration.Mods.BAUBLES.isLoaded()) {
            wirelessTerm = Baubles.getWCTBauble(playerInv.field_70458_d);
        }
        if (wirelessTerm.func_190926_b()) {
            int invSize = playerInv.func_70302_i_();
            if (invSize <= 0) {
                return ItemStack.field_190927_a;
            }
            for (int i = 0; i < invSize; ++i) {
                ItemStack item = playerInv.func_70301_a(i);
                if (item.func_190926_b() || !(item.func_77973_b() instanceof IWirelessCraftingTerminalItem)) continue;
                wirelessTerm = item;
                break;
            }
        }
        return wirelessTerm;
    }

    public static boolean shouldConsumeBoosters(ItemStack wirelessTerminal) {
        if (!ModConfig.USE_OLD_INFINTY_MECHANIC && wirelessTerminal.func_77942_o() && wirelessTerminal.func_77978_p().func_74764_b(AUTOCONSUME_BOOSTER_NBT)) {
            return wirelessTerminal.func_77978_p().func_74767_n(AUTOCONSUME_BOOSTER_NBT);
        }
        return false;
    }

    public static boolean isBoosterInstalled(ItemStack wirelessTerminal) {
        ItemStack boosterCard;
        NBTTagCompound boosterTagCompound;
        NBTTagList boosterNBTList;
        NBTTagCompound boosterNBT;
        if (wirelessTerminal.func_77942_o() && (boosterNBT = wirelessTerminal.func_179543_a(BOOSTER_SLOT_NBT)) != null && (boosterNBTList = boosterNBT.func_150295_c("Items", 10)) != null && (boosterTagCompound = boosterNBTList.func_150305_b(0)) != null && (boosterCard = new ItemStack(boosterTagCompound)) != null && !boosterCard.func_190926_b()) {
            return boosterCard.func_77973_b() instanceof ItemInfinityBooster && ModConfig.WCT_BOOSTER_ENABLED;
        }
        return false;
    }

    public static void setInRange(ItemStack wirelessTerm, boolean value) {
        NBTTagCompound nbt = WCTUtils.ensureTag(wirelessTerm);
        nbt.func_74757_a(IN_RANGE_NBT, value);
        wirelessTerm.func_77982_d(nbt);
    }

    public static boolean isInRange(ItemStack wirelessTerm) {
        NBTTagCompound nbt = WCTUtils.ensureTag(wirelessTerm);
        return nbt.func_74764_b(IN_RANGE_NBT) && nbt.func_74767_n(IN_RANGE_NBT) || WCTUtils.isWCTCreative(wirelessTerm);
    }

    public static ItemStack addInfinityBoosters(@Nonnull ItemStack wirelessTerm, ItemStack boosterCardStack) {
        int maxCardCount;
        int currentCardCount = WCTUtils.getInfinityEnergy(wirelessTerm) / ModConfig.INFINITY_ENERGY_PER_BOOSTER_CARD;
        if (currentCardCount < (maxCardCount = Integer.MAX_VALUE / ModConfig.INFINITY_ENERGY_PER_BOOSTER_CARD)) {
            int cardsTryingToAdd;
            int spaceAvailable = maxCardCount - currentCardCount;
            int numberOfCardsTryingToAdd = boosterCardStack.func_190916_E();
            if (spaceAvailable > 0 && numberOfCardsTryingToAdd > 0 && (cardsTryingToAdd = numberOfCardsTryingToAdd * ModConfig.INFINITY_ENERGY_PER_BOOSTER_CARD) <= spaceAvailable) {
                WCTUtils.setInfinityEnergy(wirelessTerm, cardsTryingToAdd + currentCardCount * ModConfig.INFINITY_ENERGY_PER_BOOSTER_CARD);
                if (cardsTryingToAdd == spaceAvailable) {
                    boosterCardStack = ItemStack.field_190927_a;
                } else {
                    boosterCardStack.func_190920_e(cardsTryingToAdd - spaceAvailable);
                }
            }
        }
        return boosterCardStack;
    }

    public static boolean hasInfiniteRange(@Nonnull ItemStack wirelessTerm) {
        if (ModConfig.USE_OLD_INFINTY_MECHANIC) {
            return WCTUtils.isBoosterInstalled(wirelessTerm) || WCTUtils.isWCTCreative(wirelessTerm);
        }
        return WCTUtils.hasInfinityEnergy(wirelessTerm) || WCTUtils.isWCTCreative(wirelessTerm);
    }

    public static boolean hasInfinityEnergy(@Nonnull ItemStack wirelessTerm) {
        if (WCTUtils.ensureTag(wirelessTerm).func_74764_b(INFINITY_ENERGY_NBT)) {
            return WCTUtils.getInfinityEnergy(wirelessTerm) > 0 && ModConfig.WCT_BOOSTER_ENABLED;
        }
        return WCTUtils.isWCTCreative(wirelessTerm);
    }

    public static boolean isAnyWCT(@Nonnull ItemStack wirelessTerm) {
        return wirelessTerm.func_77973_b() == ModItems.WCT || wirelessTerm.func_77973_b() == ModItems.CREATIVE_WCT;
    }

    public static boolean isInRangeOfWAP(@Nonnull ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        return WCTUtils.getDistanceToWAP(wirelessTerm, player) <= WCTUtils.getWAPRange(wirelessTerm, player) && WCTUtils.getWAPRange(wirelessTerm, player) != Double.MAX_VALUE;
    }

    public static double getDistanceToWAP(@Nonnull ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        IWirelessAccessPoint wap = WCTUtils.getClosestWAPToPlayer(wirelessTerm, player);
        if (wap != null && player.func_130014_f_().field_73011_w.getDimension() == wap.getLocation().getWorld().field_73011_w.getDimension()) {
            BlockPos wapPos = wap.getLocation().getPos();
            BlockPos playerPos = player.func_180425_c();
            double distanceToWap = Math.sqrt(playerPos.func_177951_i((Vec3i)wapPos));
            return distanceToWap;
        }
        return Double.MAX_VALUE;
    }

    public static double getWAPRange(@Nonnull ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        IWirelessAccessPoint wap = WCTUtils.getClosestWAPToPlayer(wirelessTerm, player);
        if (wap != null) {
            return wap.getRange();
        }
        return Double.MAX_VALUE;
    }

    public static IWirelessAccessPoint getClosestWAPToPlayer(@Nonnull ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        List<IWirelessAccessPoint> wapList = WCTUtils.getWAPs(wirelessTerm, player);
        double closestDistance = -1.0;
        IWirelessAccessPoint closestWAP = null;
        for (IWirelessAccessPoint wap : wapList) {
            BlockPos wapPos = wap.getLocation().getPos();
            BlockPos playerPos = player.func_180425_c();
            double thisWAPDistance = Math.sqrt(playerPos.func_177951_i((Vec3i)wapPos));
            if (closestDistance == -1.0) {
                closestDistance = thisWAPDistance;
                closestWAP = wap;
                continue;
            }
            if (!(thisWAPDistance < closestDistance)) continue;
            closestDistance = thisWAPDistance;
            closestWAP = wap;
        }
        return closestDistance == -1.0 ? null : closestWAP;
    }

    public static List<IWirelessAccessPoint> getWAPs(@Nonnull ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        WCTGuiObject object = WCTUtils.getGUIObject(wirelessTerm, player);
        if (object != null) {
            return object.getWAPs();
        }
        return Collections.emptyList();
    }

    public static WCTGuiObject getGUIObject(EntityPlayer player) {
        return WCTUtils.getGUIObject(null, player);
    }

    public static WCTGuiObject getGUIObject(@Nullable ItemStack wirelessTerm, @Nonnull EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerWCT || wirelessTerm == null) {
            ContainerWCT c = (ContainerWCT)player.field_71070_bA;
            if (c.getObject() != null) {
                return c.getObject();
            }
        } else if (wirelessTerm.func_77973_b() instanceof IWirelessTermHandler && player != null && player.func_130014_f_() != null) {
            return new WCTGuiObject((IWirelessTermHandler)wirelessTerm.func_77973_b(), wirelessTerm, player, player.func_130014_f_(), player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
        }
        return null;
    }

    public static void setInfinityEnergy(@Nonnull ItemStack wirelessTerm, int amount) {
        if (!WCTUtils.isWCTCreative(wirelessTerm)) {
            NBTTagCompound nbt = WCTUtils.ensureTag(wirelessTerm);
            nbt.func_74768_a(INFINITY_ENERGY_NBT, amount);
            wirelessTerm.func_77982_d(nbt);
        }
    }

    public static int getInfinityEnergy(@Nonnull ItemStack wirelessTerm) {
        NBTTagCompound nbt = WCTUtils.ensureTag(wirelessTerm);
        if (!nbt.func_74764_b(INFINITY_ENERGY_NBT) && !WCTUtils.isWCTCreative(wirelessTerm)) {
            nbt.func_74768_a(INFINITY_ENERGY_NBT, 0);
        }
        return WCTUtils.isWCTCreative(wirelessTerm) ? Integer.MAX_VALUE : nbt.func_74762_e(INFINITY_ENERGY_NBT);
    }

    public static void drainInfinityEnergy(@Nonnull ItemStack wirelessTerm, EntityPlayer player) {
        if (player instanceof EntityPlayerMP && !ModConfig.USE_OLD_INFINTY_MECHANIC && !WCTUtils.isWCTCreative(wirelessTerm)) {
            int current = WCTUtils.getInfinityEnergy(wirelessTerm);
            if (!WCTUtils.isInRangeOfWAP(wirelessTerm, player)) {
                int reducedAmount = current - ModConfig.INFINITY_ENERGY_DRAIN;
                if (reducedAmount < 0) {
                    reducedAmount = 0;
                }
                WCTUtils.setInfinityEnergy(wirelessTerm, reducedAmount);
                ModNetworking.instance().sendTo(new PacketSyncInfinityEnergy(WCTUtils.getInfinityEnergy(wirelessTerm)), (EntityPlayerMP)player);
            }
        }
    }

    public static NBTTagCompound ensureTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    @Nonnull
    public static ItemStack getMagnet(@Nonnull ItemStack wirelessTerm) {
        NBTTagList magnetSlot;
        ItemStack magnetItem;
        NBTTagCompound magnetNBT;
        if (!wirelessTerm.func_190926_b() && wirelessTerm.func_77942_o() && wirelessTerm.func_77973_b() instanceof IWirelessCraftingTerminalItem && (magnetNBT = wirelessTerm.func_179543_a(MAGNET_SLOT_NBT)) != null && (magnetItem = new ItemStack((magnetSlot = magnetNBT.func_150295_c("Items", 10)).func_150305_b(0))) != null && !magnetItem.func_190926_b() && magnetItem.func_77973_b() == ModItems.MAGNET_CARD) {
            return magnetItem;
        }
        return ItemStack.field_190927_a;
    }

    public static int getMagnetMode(ItemStack wirelessTerm) {
        if (!WCTUtils.getMagnet(wirelessTerm).func_190926_b()) {
            return ItemMagnet.getDamageUnsafe(WCTUtils.getMagnet(wirelessTerm));
        }
        return -1;
    }

    @Nonnull
    public static ItemStack getMagnet(InventoryPlayer playerInv) {
        NBTTagList magnetSlot;
        ItemStack magnetItem;
        NBTTagCompound magnetNBT;
        if (!playerInv.field_70458_d.func_184614_ca().func_190926_b() && playerInv.field_70458_d.func_184614_ca().func_77973_b() == ModItems.MAGNET_CARD) {
            return playerInv.field_70458_d.func_184614_ca();
        }
        ItemStack wirelessTerm = WCTUtils.getWirelessTerm(playerInv);
        if (!wirelessTerm.func_190926_b() && wirelessTerm.func_77942_o() && wirelessTerm.func_77973_b() instanceof IWirelessCraftingTerminalItem && (magnetNBT = wirelessTerm.func_179543_a(MAGNET_SLOT_NBT)) != null && (magnetItem = new ItemStack((magnetSlot = magnetNBT.func_150295_c("Items", 10)).func_150305_b(0))) != null && !magnetItem.func_190926_b() && magnetItem.func_77973_b() == ModItems.MAGNET_CARD) {
            return magnetItem;
        }
        int invSize = playerInv.func_70302_i_();
        ItemStack magnetItem2 = ItemStack.field_190927_a;
        if (invSize <= 0) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < invSize; ++i) {
            ItemStack item = playerInv.func_70301_a(i);
            if (item.func_190926_b() || item.func_77973_b() != ModItems.MAGNET_CARD) continue;
            magnetItem2 = item;
            break;
        }
        return magnetItem2;
    }

    public static boolean isMagnetInitialized(@Nonnull ItemStack magnetItem) {
        if (!magnetItem.func_190926_b() && magnetItem.func_77973_b() == ModItems.MAGNET_CARD) {
            if (!magnetItem.func_77942_o()) {
                magnetItem.func_77982_d(new NBTTagCompound());
            }
            if (!magnetItem.func_77978_p().func_74764_b("Initialized")) {
                magnetItem.func_77978_p().func_74757_a("Initialized", true);
            }
        }
        return magnetItem.func_77978_p().func_74767_n("Initialized");
    }

    public static boolean isMagnetInstalled(InventoryPlayer ip) {
        return WCTUtils.isMagnetInstalled(WCTUtils.getWirelessTerm(ip));
    }

    public static boolean isMagnetInstalled(ItemStack wirelessTerm) {
        ItemStack magnetItem;
        NBTTagCompound magnetNBTForm;
        NBTTagList magnetList;
        NBTTagCompound magnetNBT;
        return !wirelessTerm.func_190926_b() && wirelessTerm.func_77942_o() && wirelessTerm.func_77978_p().func_74764_b(MAGNET_SLOT_NBT) && (magnetNBT = wirelessTerm.func_179543_a(MAGNET_SLOT_NBT)) != null && (magnetList = magnetNBT.func_150295_c("Items", 10)) != null && !magnetList.func_82582_d() && (magnetNBTForm = magnetList.func_150305_b(0)) != null && !(magnetItem = new ItemStack(magnetNBTForm)).func_190926_b() && magnetItem.func_77973_b() instanceof ItemMagnet;
    }

    public static boolean isWCTCreative(ItemStack wirelessTerm) {
        return !wirelessTerm.func_190926_b() && wirelessTerm.func_77973_b() == ModItems.CREATIVE_WCT;
    }

    public static ItemStack setCreativeWCT(ItemStack wirelessTerm, boolean makeCreative) {
        if (!wirelessTerm.func_190926_b()) {
            if (makeCreative) {
                if (wirelessTerm.func_77973_b() == ModItems.WCT) {
                    ItemStack creativeStack = new ItemStack((Item)ModItems.CREATIVE_WCT);
                    if (wirelessTerm.func_77942_o()) {
                        creativeStack.func_77982_d(wirelessTerm.func_77955_b(new NBTTagCompound()));
                    }
                    wirelessTerm = creativeStack.func_77946_l();
                }
            } else if (wirelessTerm.func_77973_b() == ModItems.CREATIVE_WCT) {
                ItemStack wirelessStack = new ItemStack((Item)ModItems.WCT);
                if (wirelessTerm.func_77942_o()) {
                    wirelessStack.func_77982_d(wirelessTerm.func_77955_b(new NBTTagCompound()));
                }
                wirelessTerm = wirelessStack.func_77946_l();
            }
        }
        return wirelessTerm;
    }

    public static ItemStack getCreativeWCT(ItemStack wirelessTerm) {
        return WCTUtils.setCreativeWCT(wirelessTerm, true);
    }

    public static void removeTimerTags(ItemStack is) {
        if (is.func_190926_b() || is.func_77978_p() == null) {
            return;
        }
        if (is.func_77978_p().func_74764_b(TIMER_RESET_NBT)) {
            is.func_77982_d(null);
        }
        if (is.func_77978_p() != null && is.func_77978_p().func_74764_b(TIMER_PICKUP_NBT)) {
            is.func_77978_p().func_82580_o(TIMER_PICKUP_NBT);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static String color(String color) {
        switch (color) {
            case "white": {
                return TextFormatting.WHITE.toString();
            }
            case "black": {
                return TextFormatting.BLACK.toString();
            }
            case "green": {
                return TextFormatting.GREEN.toString();
            }
            case "red": {
                return TextFormatting.RED.toString();
            }
            case "yellow": {
                return TextFormatting.YELLOW.toString();
            }
            case "aqua": {
                return TextFormatting.AQUA.toString();
            }
            case "blue": {
                return TextFormatting.BLUE.toString();
            }
            case "italics": {
                return TextFormatting.ITALIC.toString();
            }
            case "bold": {
                return TextFormatting.BOLD.toString();
            }
        }
        return TextFormatting.GRAY.toString();
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer player() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static EntityPlayer player(InventoryPlayer playerInv) {
        return playerInv.field_70458_d;
    }

    @SideOnly(value=Side.CLIENT)
    public static World world() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    public static World world(EntityPlayer player) {
        return player.func_130014_f_();
    }

    public static void chatMessage(EntityPlayer player, ITextComponent message) {
        player.func_145747_a(message);
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleKeybind() {
        ItemStack magnetItem;
        EntityPlayer p = WCTUtils.player();
        if (p.field_71070_bA == null) {
            return;
        }
        if (ModKeybindings.openTerminal.func_151463_i() != 0 && ModKeybindings.openTerminal.func_151468_f()) {
            ItemStack is = WCTUtils.getWirelessTerm(p.field_71071_by);
            if (is.func_190926_b()) {
                return;
            }
            IWirelessCraftingTerminalItem wirelessTerm = (IWirelessCraftingTerminalItem)is.func_77973_b();
            if (wirelessTerm != null && wirelessTerm.isWirelessCraftingEnabled(is)) {
                if (!(p.field_71070_bA instanceof ContainerWCT)) {
                    ModNetworking.instance().sendToServer(new PacketOpenGui(0));
                } else {
                    p.func_71053_j();
                }
            }
        } else if (ModKeybindings.openMagnetFilter.func_151463_i() != 0 && ModKeybindings.openMagnetFilter.func_151468_f()) {
            ItemStack magnetItem2 = WCTUtils.getMagnet(p.field_71071_by);
            if (!magnetItem2.func_190926_b()) {
                if (!WCTUtils.isMagnetInitialized(magnetItem2)) {
                    if (magnetItem2.func_77978_p() == null) {
                        magnetItem2.func_77982_d(new NBTTagCompound());
                    }
                    ModNetworking.instance().sendToServer(new PacketMagnetFilter(0, true));
                }
                if (!(p.field_71070_bA instanceof ContainerMagnet)) {
                    ModNetworking.instance().sendToServer(new PacketOpenGui(4));
                }
            }
        } else if (ModKeybindings.changeMagnetMode.func_151463_i() != 0 && ModKeybindings.changeMagnetMode.func_151468_f() && !(magnetItem = WCTUtils.getMagnet(p.field_71071_by)).func_190926_b()) {
            if (!WCTUtils.isMagnetInitialized(magnetItem)) {
                if (!magnetItem.func_77942_o()) {
                    magnetItem.func_77982_d(new NBTTagCompound());
                }
                ModNetworking.instance().sendToServer(new PacketMagnetFilter(0, true));
            }
            ItemMagnet.switchMagnetMode(magnetItem);
        }
    }
}

