/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.proxy;

import com.infinityraider.infinitylib.InfinityMod;
import com.infinityraider.infinitylib.block.ICustomRenderedBlock;
import com.infinityraider.infinitylib.block.IInfinityBlock;
import com.infinityraider.infinitylib.entity.EntityRegistryEntry;
import com.infinityraider.infinitylib.handler.ConfigurationHandler;
import com.infinityraider.infinitylib.item.IAutoRenderedItem;
import com.infinityraider.infinitylib.item.ICustomRenderedItem;
import com.infinityraider.infinitylib.item.IInfinityItem;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.modules.Module;
import com.infinityraider.infinitylib.proxy.IProxy;
import com.infinityraider.infinitylib.proxy.base.IClientProxyBase;
import com.infinityraider.infinitylib.render.block.BlockRendererRegistry;
import com.infinityraider.infinitylib.render.item.ItemRendererRegistry;
import com.infinityraider.infinitylib.utility.ReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
implements IProxy,
IClientProxyBase {
    @Override
    public void initEnd(FMLInitializationEvent event) {
        IProxy.super.initEnd(event);
        Module.getActiveModules().forEach(Module::initClient);
    }

    @Override
    public void postInitEnd(FMLPostInitializationEvent event) {
        IProxy.super.postInitEnd(event);
        Module.getActiveModules().forEach(Module::postInitClient);
    }

    @Override
    public void initConfiguration(FMLPreInitializationEvent event) {
        IProxy.super.initConfiguration(event);
        ConfigurationHandler.getInstance().initClientConfigs(event);
    }

    @Override
    public void registerBlocks(InfinityMod mod, IForgeRegistry<Block> registry) {
        IProxy.super.registerBlocks(mod, registry);
        if (mod.getModBlockRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModBlockRegistry(), IInfinityBlock.class, block -> {
                if (block.isEnabled() && block instanceof ICustomRenderedBlock) {
                    BlockRendererRegistry.getInstance().registerCustomBlockRenderer((ICustomRenderedBlock)block);
                }
            });
        }
        for (ICustomRenderedBlock block2 : BlockRendererRegistry.getInstance().getRegisteredBlocks()) {
            mod.getLogger().debug("registered custom renderer for " + block2.getBlockModelResourceLocation(), new Object[0]);
        }
    }

    @Override
    public void registerItems(InfinityMod mod, IForgeRegistry<Item> registry) {
        IProxy.super.registerItems(mod, registry);
        if (mod.getModItemRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModItemRegistry(), IInfinityItem.class, item -> {
                if (item instanceof Item && item.isEnabled()) {
                    if (item instanceof IItemWithModel) {
                        for (Tuple<Integer, ModelResourceLocation> entry : ((IItemWithModel)item).getModelDefinitions()) {
                            ModelLoader.setCustomModelResourceLocation((Item)((Item)item), (int)((Integer)entry.func_76341_a()), (ModelResourceLocation)((ModelResourceLocation)entry.func_76340_b()));
                        }
                    }
                    if (item instanceof IAutoRenderedItem) {
                        ItemRendererRegistry.getInstance().registerCustomItemRendererAuto((Item)((IAutoRenderedItem)((Item)item)));
                    } else if (item instanceof ICustomRenderedItem) {
                        ItemRendererRegistry.getInstance().registerCustomItemRenderer((Item)item, ((ICustomRenderedItem)item).getRenderer());
                    }
                }
            });
        }
        if (mod.getModBlockRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModBlockRegistry(), IInfinityBlock.class, block -> {
                if (block.isEnabled()) {
                    block.getItemBlock().ifPresent(item -> {
                        if (item instanceof IItemWithModel) {
                            for (Tuple<Integer, ModelResourceLocation> entry : ((IItemWithModel)item).getModelDefinitions()) {
                                mod.getLogger().debug("Registering model for ItemBlock: {0} meta: {1} location: {2}", ((IInfinityItem)item).getInternalName(), entry.func_76341_a(), entry.func_76340_b());
                                ModelLoader.setCustomModelResourceLocation((Item)item, (int)((Integer)entry.func_76341_a()), (ModelResourceLocation)((ModelResourceLocation)entry.func_76340_b()));
                            }
                        }
                        if (item instanceof IAutoRenderedItem) {
                            ItemRendererRegistry.getInstance().registerCustomItemRendererAuto((Item)((IAutoRenderedItem)item));
                        } else if (item instanceof ICustomRenderedItem) {
                            ItemRendererRegistry.getInstance().registerCustomItemRenderer((Item)item, ((ICustomRenderedItem)item).getRenderer());
                        }
                    });
                }
            });
        }
    }

    @Override
    public void registerEntities(InfinityMod mod, IForgeRegistry<EntityEntry> registry) {
        if (mod.getModEntityRegistry() != null) {
            ReflectionHelper.forEachValueIn(mod.getModEntityRegistry(), EntityRegistryEntry.class, entry -> {
                if (entry.isEnabled()) {
                    entry.registerClient(mod, registry);
                }
            });
        }
    }

    @Override
    public void registerEventHandlers() {
        IProxy.super.registerEventHandlers();
        for (Module module : Module.getActiveModules()) {
            module.getClientEventHandlers().forEach(this::registerEventHandler);
        }
    }
}

