/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.init;

import cofh.CoFHCore;
import cofh.core.gui.CreativeTabCore;
import cofh.core.init.CoreProps;
import cofh.core.util.CoreUtils;
import cofh.core.util.TimeTracker;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.block.BlockOre;
import cofh.thermalfoundation.init.TFEquipment;
import cofh.thermalfoundation.item.tome.ItemTomeLexicon;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.core.util.Loader;

public class TFProps {
    public static boolean disableBasicItems = false;
    public static boolean disableUpgradeItems = false;
    public static boolean disableAllTools = false;
    public static boolean disableAllArmor = false;
    public static boolean disableVanillaTools = false;
    public static boolean disableAllBows = false;
    public static boolean disableAllFishingRods = false;
    public static boolean disableAllShears = false;
    public static boolean disableAllShields = false;
    public static boolean showDisabledEquipment = false;
    public static boolean showCreativeItems = true;
    public static boolean showEmptyItems = false;
    public static boolean showFullItems = true;
    public static boolean useUnifiedTabs = true;
    public static ArrayList<ItemStack> blockList = new ArrayList();
    public static ArrayList<ItemStack> itemList = new ArrayList();
    public static ArrayList<ItemStack> utilList = new ArrayList();
    public static ArrayList<ItemStack> toolList = new ArrayList();
    public static ArrayList<ItemStack> miscList = new ArrayList();
    public static final String EXPERIENCE_TIMER = "thermalfoundation.experience_timer";
    public static final String LEXICON_TIMER = "thermalfoundation.lexicon_timer";
    public static final String LEXICON_DATA = "thermalfoundation.lexicon_data";
    public static boolean dropSulfurFireImmuneMobs = true;
    public static boolean enablePyrotheumCrafting = true;
    public static boolean enablePetrotheumCrafting = true;
    public static boolean enableCryotheumCrafting = true;
    public static boolean enableHorseArmorCrafting = true;
    public static boolean enableSaddleCrafting = true;
    public static int fuelCokeFuel = 3200;
    public static int globRosinFuel = 800;
    public static int globTarFuel = 800;
    public static int dustPyrotheumFuel = 24000;
    public static boolean iconBlazePowder = true;
    public static boolean renderStarfieldCage = false;

    private TFProps() {
    }

    public static void preInit() {
        TFProps.configCommon();
        TFProps.configClient();
        TFProps.addWorldGeneration();
    }

    private static void configCommon() {
        String category = "General";
        String comment = "If TRUE, Fire-Immune mobs have a chance to drop Sulfur.";
        dropSulfurFireImmuneMobs = ThermalFoundation.CONFIG.getConfiguration().getBoolean("FireImmuneMobsDropSulfur", category, dropSulfurFireImmuneMobs, comment);
        comment = "If TRUE, recipes for Basic Craftable Items (Gears, Parts) are disabled. Only enable this option if you understand the consequences.";
        disableBasicItems = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableBasicItemRecipes", category, disableBasicItems, comment);
        comment = "If TRUE, recipes for Upgrade Items (Kits) are disabled. Only enable this option if you understand the consequences.";
        disableUpgradeItems = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableUpgradeItemRecipes", category, disableUpgradeItems, comment);
        comment = "If TRUE, Pyrotheum Dust can be used to smelt Ores into Ingots.";
        enablePyrotheumCrafting = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnablePyrotheumCrafting", category, enablePyrotheumCrafting, comment);
        comment = "If TRUE, Petrotheum Dust can be used to break Ores into Dusts and Gems.";
        enablePetrotheumCrafting = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnablePetrotheumCrafting", category, enablePetrotheumCrafting, comment);
        comment = "If TRUE, Cryotheum Dust can be used to create Ice and solidify Clathrates.";
        enableCryotheumCrafting = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnableCryotheumCrafting", category, enableCryotheumCrafting, comment);
        comment = "If TRUE, Horse Armor will be craftable.";
        enableHorseArmorCrafting = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnableHorseArmorCrafting", category, enableHorseArmorCrafting, comment);
        comment = "If TRUE, Saddles will be craftable.";
        enableSaddleCrafting = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnableSaddleCrafting", category, enableSaddleCrafting, comment);
        category = "Equipment";
        comment = "If TRUE, recipes for all Armor Sets are disabled.";
        disableAllArmor = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllArmorRecipes", category, disableAllArmor, comment);
        comment = "If TRUE, recipes for all Tools are disabled.";
        disableAllTools = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllToolRecipes", category, disableAllTools, comment);
        comment = "If TRUE, recipes for new Vanilla material (Wood, Stone, Iron, Gold, Diamond) Tools are disabled.";
        disableVanillaTools = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableVanillaToolRecipes", category, disableVanillaTools, comment);
        comment = "If TRUE, recipes for all new Bows will be disabled, leaving only the Vanilla Bow";
        disableAllBows = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllBows", category, disableAllBows, comment);
        comment = "If TRUE, recipes for all new Shears will be disabled, leaving only the Vanilla (Iron) Shears.";
        disableAllShears = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllShears", category, disableAllShears, comment);
        comment = "If TRUE, recipes for all new Fishing Rods will be disabled, leaving only the Vanilla (Wood) Fishing Rod";
        disableAllFishingRods = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllFishingRods", category, disableAllFishingRods, comment);
        comment = "If TRUE, recipes for all new Shields will be disabled, leaving only the Vanilla (Wood) Shield";
        disableAllShields = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllShields", category, disableAllShields, comment);
        comment = "If TRUE, items which have had their recipes disabled will show in the Creative Tab and JEI.";
        showDisabledEquipment = ThermalFoundation.CONFIG.getConfiguration().getBoolean("ShowDisabledEquipment", category, showDisabledEquipment, comment);
    }

    private static void configClient() {
        String category = "Render";
        String comment = "If TRUE, Ender devices will be a bit more Cagey year-round.";
        renderStarfieldCage = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("CageyEnder", category, renderStarfieldCage, comment);
        boolean utilTabCommon = false;
        boolean toolTabCommon = false;
        boolean armorTabCommon = false;
        category = "Global";
        comment = "If TRUE, Creative versions of Items will show in Creative Tabs.";
        showCreativeItems = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("ShowCreativeItems", category, showCreativeItems, comment);
        comment = "If TRUE, Empty versions of Items which contain a specific resource (such as RF or Water) will show in Creative Tabs.";
        showEmptyItems = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("ShowEmptyItems", category, showEmptyItems, comment);
        comment = "If TRUE, Full versions of Items which contain a specific resource (such as RF or Water) will show in Creative Tabs.";
        showFullItems = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("ShowFullItems", category, showFullItems, comment);
        comment = "If TRUE, all Thermal Series mods will be share common pre-configured \"Thermal Series\" Creative Tabs. Basic Armor and Basic Tools will go to appropriate vanilla Creative Tabs.";
        useUnifiedTabs = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("ThermalSeriesTabs", category, useUnifiedTabs, comment);
        category = "Interface";
        comment = "If TRUE, Thermal Foundation Utility Items appear under the general \"Thermal Foundation\" Creative Tab. Does not work if \"Thermal Series\" Creative Tabs are in use.";
        utilTabCommon = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("UtilsInCommonTab", category, utilTabCommon, comment);
        comment = "If TRUE, Thermal Foundation Basic Tools appear under the general \"Thermal Foundation\" Creative Tab. Does not work if \"Thermal Series\" Creative Tabs are in use.";
        toolTabCommon = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("ToolsInCommonTab", category, toolTabCommon, comment);
        comment = "If TRUE, Thermal Foundation Basic Armor Sets appear under the general \"Thermal Foundation\" Creative Tab. Does not work if \"Thermal Series\" Creative Tabs are in use.";
        armorTabCommon = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("ArmorInCommonTab", category, armorTabCommon, comment);
        if (useUnifiedTabs) {
            TFProps.initCommonTab();
            TFProps.initItemTab();
            TFProps.initUtilTab();
            ThermalFoundation.tabBasicTools = CreativeTabs.field_78040_i;
            ThermalFoundation.tabBasicCombat = CreativeTabs.field_78037_j;
            ThermalFoundation.tabBasicArmor = CreativeTabs.field_78037_j;
        } else {
            ThermalFoundation.tabCommon = new CreativeTabCore("thermalfoundation"){

                @SideOnly(value=Side.CLIENT)
                public ItemStack func_78016_d() {
                    return BlockOre.oreNickel;
                }
            };
            if (utilTabCommon) {
                ThermalFoundation.tabUtils = ThermalFoundation.tabCommon;
            } else {
                ThermalFoundation.tabUtils = new CreativeTabCore("thermalfoundation", "Utils"){

                    @SideOnly(value=Side.CLIENT)
                    public ItemStack func_78016_d() {
                        return ItemTomeLexicon.tomeLexicon;
                    }
                };
                ThermalFoundation.tabBasicTools = toolTabCommon ? ThermalFoundation.tabCommon : new CreativeTabCore("thermalfoundation", "Tools"){

                    @SideOnly(value=Side.CLIENT)
                    public ItemStack func_78016_d() {
                        return TFEquipment.ToolSet.INVAR.toolPickaxe;
                    }
                };
                ThermalFoundation.tabBasicArmor = armorTabCommon ? ThermalFoundation.tabCommon : new CreativeTabCore("thermalfoundation", "Armor"){

                    @SideOnly(value=Side.CLIENT)
                    public ItemStack func_78016_d() {
                        return TFEquipment.ArmorSet.INVAR.armorChestplate;
                    }
                };
                ThermalFoundation.tabItems = ThermalFoundation.tabCommon;
                ThermalFoundation.tabMisc = ThermalFoundation.tabCommon;
                ThermalFoundation.tabBasicCombat = ThermalFoundation.tabBasicTools;
            }
        }
    }

    public static void initCommonTab() {
        if (!useUnifiedTabs || ThermalFoundation.tabCommon != null) {
            return;
        }
        ThermalFoundation.tabCommon = new CreativeTabCore("thermalseries", "Blocks"){
            int iconIndex = 0;
            TimeTracker iconTracker = new TimeTracker();

            public void updateIcon() {
                World world = CoFHCore.proxy.getClientWorld();
                if (CoreUtils.isClient() && this.iconTracker.hasDelayPassed(world, 80)) {
                    this.iconIndex = MathHelper.RANDOM.nextInt(blockList.size());
                    this.iconTracker.markTime(world);
                }
            }

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                if (blockList.isEmpty()) {
                    return ItemStack.field_190927_a;
                }
                this.updateIcon();
                return blockList.get(this.iconIndex);
            }
        };
    }

    public static void initItemTab() {
        if (!useUnifiedTabs || ThermalFoundation.tabItems != null) {
            return;
        }
        ThermalFoundation.tabItems = new CreativeTabCore("thermalseries", "Items"){
            int iconIndex = 0;
            TimeTracker iconTracker = new TimeTracker();

            public void updateIcon() {
                World world = CoFHCore.proxy.getClientWorld();
                if (CoreUtils.isClient() && this.iconTracker.hasDelayPassed(world, 80)) {
                    this.iconIndex = MathHelper.RANDOM.nextInt(itemList.size());
                    this.iconTracker.markTime(world);
                }
            }

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                if (itemList.isEmpty()) {
                    return ItemStack.field_190927_a;
                }
                this.updateIcon();
                return itemList.get(this.iconIndex);
            }
        };
    }

    public static void initUtilTab() {
        if (!useUnifiedTabs || ThermalFoundation.tabUtils != null) {
            return;
        }
        ThermalFoundation.tabUtils = new CreativeTabCore("thermalseries", "Utils"){
            int iconIndex = 0;
            TimeTracker iconTracker = new TimeTracker();

            public void updateIcon() {
                World world = CoFHCore.proxy.getClientWorld();
                if (CoreUtils.isClient() && this.iconTracker.hasDelayPassed(world, 80)) {
                    this.iconIndex = MathHelper.RANDOM.nextInt(utilList.size());
                    this.iconTracker.markTime(world);
                }
            }

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                if (utilList.isEmpty()) {
                    return ItemStack.field_190927_a;
                }
                this.updateIcon();
                return utilList.get(this.iconIndex);
            }
        };
    }

    public static void initToolTab() {
        if (!useUnifiedTabs || ThermalFoundation.tabTools != null) {
            return;
        }
        ThermalFoundation.tabTools = new CreativeTabCore("thermalseries", "Tools"){
            int iconIndex = 0;
            TimeTracker iconTracker = new TimeTracker();

            public void updateIcon() {
                World world = CoFHCore.proxy.getClientWorld();
                if (CoreUtils.isClient() && this.iconTracker.hasDelayPassed(world, 80)) {
                    this.iconIndex = MathHelper.RANDOM.nextInt(toolList.size());
                    this.iconTracker.markTime(world);
                }
            }

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                if (toolList.isEmpty()) {
                    return ItemStack.field_190927_a;
                }
                this.updateIcon();
                return toolList.get(this.iconIndex);
            }
        };
    }

    public static void initMiscTab() {
        if (!useUnifiedTabs || ThermalFoundation.tabMisc != null) {
            return;
        }
        ThermalFoundation.tabMisc = new CreativeTabCore("thermalseries", "Misc"){
            int iconIndex = 0;
            TimeTracker iconTracker = new TimeTracker();

            public void updateIcon() {
                World world = CoFHCore.proxy.getClientWorld();
                if (CoreUtils.isClient() && this.iconTracker.hasDelayPassed(world, 80)) {
                    this.iconIndex = MathHelper.RANDOM.nextInt(miscList.size());
                    this.iconTracker.markTime(world);
                }
            }

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                if (miscList.isEmpty()) {
                    return ItemStack.field_190927_a;
                }
                this.updateIcon();
                return miscList.get(this.iconIndex);
            }
        };
    }

    private static void addWorldGeneration() {
        String worldGenPath = "assets/thermalfoundation/world/";
        String worldGenOre = "01_thermalfoundation_ores.json";
        String worldGenOil = "02_thermalfoundation_oil.json";
        String worldGenClathrates = "03_thermalfoundation_clathrates.json";
        String category = "World";
        String comment = "If TRUE, Thermal Foundation will create default world generation files if it cannot find existing ones. These files will only work if CoFH World is installed! Only disable this if you know what you are doing.";
        boolean generateDefaultFiles = ThermalFoundation.CONFIG.getConfiguration().getBoolean("GenerateDefaultFiles", category, true, comment);
        if (!generateDefaultFiles) {
            return;
        }
        File worldGenFile = new File(CoreProps.configDir, "/cofh/world/" + worldGenOre);
        if (!worldGenFile.exists()) {
            try {
                worldGenFile.createNewFile();
                FileUtils.copyInputStreamToFile((InputStream)Loader.getResource((String)(worldGenPath + worldGenOre), null).openStream(), (File)worldGenFile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!(worldGenFile = new File(CoreProps.configDir, "/cofh/world/" + worldGenOil)).exists()) {
            try {
                worldGenFile.createNewFile();
                FileUtils.copyInputStreamToFile((InputStream)Loader.getResource((String)(worldGenPath + worldGenOil), null).openStream(), (File)worldGenFile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!(worldGenFile = new File(CoreProps.configDir, "/cofh/world/" + worldGenClathrates)).exists()) {
            try {
                worldGenFile.createNewFile();
                FileUtils.copyInputStreamToFile((InputStream)Loader.getResource((String)(worldGenPath + worldGenClathrates), null).openStream(), (File)worldGenFile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

