/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item.tome;

import cofh.api.item.IInventoryContainerItem;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.util.CoreUtils;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.item.tome.ItemTome;
import cofh.thermalfoundation.util.LexiconManager;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemTomeLexicon
extends ItemTome
implements IInventoryContainerItem {
    public static boolean enable = true;
    public static ItemStack tomeLexicon;

    public ItemTomeLexicon() {
        this.func_77655_b("lexicon");
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.thermalfoundation.tome.lexicon.0"));
        tooltip.add(StringHelper.localize((String)("info.thermalfoundation.tome.lexicon.a." + (this.isEmpowered(stack) ? 1 : 0))) + "\u00a7r");
        tooltip.add(StringHelper.localizeFormat((String)("info.thermalfoundation.tome.lexicon.b." + (this.isEmpowered(stack) ? 1 : 0)), (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!this.isEmpowered(stack)) {
            return;
        }
        NBTTagCompound tag = entity.getEntityData();
        tag.func_74772_a("thermalfoundation.lexicon_timer", entity.field_70170_p.func_82737_E());
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player) || hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (ServerHelper.isServerWorld((World)world) && LexiconManager.getSortedOreNames().size() > 0) {
            if (this.isEmpowered(stack)) {
                player.openGui((Object)ThermalFoundation.instance, 2, world, 0, 0, 0);
            } else {
                player.openGui((Object)ThermalFoundation.instance, 1, world, 0, 0, 0);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public int getSizeInventory(ItemStack container) {
        return 3;
    }

    public boolean preInit() {
        ForgeRegistries.ITEMS.register(this.setRegistryName("tome_lexicon"));
        ThermalFoundation.proxy.addIModelRegister(this);
        ItemTomeLexicon.config();
        tomeLexicon = new ItemStack((Item)this);
        return true;
    }

    public boolean initialize() {
        if (enable) {
            RecipeHelper.addShapedRecipe((ItemStack)tomeLexicon, (Object[])new Object[]{" L ", "GBI", " R ", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('G'), "ingotGold", Character.valueOf('I'), "ingotIron", Character.valueOf('L'), "gemLapis", Character.valueOf('R'), "dustRedstone"});
        }
        return true;
    }

    public static void config() {
        String category = "Tome.Lexicon";
        String comment = "If TRUE, the recipe for the Forge Lexicon is enabled. Set this to FALSE only if you know what you are doing and/or want to create needless inconvenience.";
        enable = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnableRecipe", category, enable, comment);
    }
}

