/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.util;

import cofh.core.init.CoreProps;
import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.ItemWrapper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.thermalfoundation.ThermalFoundation;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class LexiconManager {
    private static HashSet<String> listNames = new HashSet();
    private static HashSet<ItemWrapper> blacklistStacks = new HashSet();
    private static List<String> sortedNames = new ArrayList<String>();
    private static boolean isWhitelist = true;
    private static boolean logEntries = false;
    private static boolean writeDefaultFile = true;
    private static boolean alwaysWriteFile = false;
    private static File filterList;
    private static final boolean DEBUG = false;

    private LexiconManager() {
    }

    public static void initialize() {
        LexiconManager.config();
    }

    public static void config() {
        String category = "Lexicon";
        String comment = "If TRUE, a WHITELIST is used, if FALSE, a BLACKLIST is used.";
        isWhitelist = ThermalFoundation.CONFIG.getConfiguration().getBoolean("UseWhiteList", category, isWhitelist, comment);
        comment = "If TRUE, a default list will be generated depending on your list setting. This will ONLY generate if no list file already exists OR the Always Generate option is enabled.";
        writeDefaultFile = ThermalFoundation.CONFIG.getConfiguration().getBoolean("GenerateDefaultList", category, writeDefaultFile, comment);
        comment = "If TRUE, a default list will generate EVERY time. Enable this if you are satisfied with the default filtering and are adding/removing mods.";
        alwaysWriteFile = ThermalFoundation.CONFIG.getConfiguration().getBoolean("AlwaysGenerateList", category, alwaysWriteFile, comment);
        comment = "If TRUE, all entries will be echoed to the system LOG.";
        logEntries = ThermalFoundation.CONFIG.getConfiguration().getBoolean("LogEntries", category, logEntries, comment);
    }

    public static void loadComplete() {
        LexiconManager.generateList();
        LexiconManager.addAllListedOres();
        LexiconManager.sortOreNames();
    }

    private static void generateList() {
        filterList = isWhitelist ? new File(CoreProps.configDir, "/cofh/thermalfoundation/lexicon-whitelist.cfg") : new File(CoreProps.configDir, "/cofh/thermalfoundation/lexicon-blacklist.cfg");
        boolean writingDefaultFile = false;
        BufferedWriter out = null;
        ArrayList<String> defaultList = new ArrayList<String>();
        if (writeDefaultFile && alwaysWriteFile && filterList.exists()) {
            filterList.delete();
        }
        if (writeDefaultFile && !filterList.exists()) {
            try {
                writingDefaultFile = true;
                filterList.createNewFile();
                out = new BufferedWriter(new FileWriter(filterList));
            }
            catch (Throwable t) {
                ThermalFoundation.LOG.warn("There is an error in the " + filterList.getName() + " file!");
                t.printStackTrace();
            }
        }
        if (writingDefaultFile) {
            String[] registeredOreNames = OreDictionary.getOreNames();
            for (String oreName : registeredOreNames) {
                if (isWhitelist && ComparableItemStack.DEFAULT_VALIDATOR.validate(oreName)) {
                    if (oreName.contains("blockCloth") || oreName.contains("blockGlass")) continue;
                    listNames.add(oreName);
                    defaultList.add(oreName);
                    continue;
                }
                if ((isWhitelist || ComparableItemStack.DEFAULT_VALIDATOR.validate(oreName)) && !oreName.contains("blockCloth") && !oreName.contains("blockGlass")) continue;
                listNames.add(oreName);
                defaultList.add(oreName);
            }
            Collections.sort(defaultList);
            if (isWhitelist) {
                ThermalFoundation.LOG.info("[Whitelist] Generating Default Whitelist.");
            } else {
                ThermalFoundation.LOG.info("[Blacklist] Generating Default Blacklist.");
            }
            try {
                for (String listEntry : defaultList) {
                    out.write(listEntry + "\n");
                }
                out.close();
                defaultList.clear();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static void addAllListedOres() {
        try {
            if (!filterList.exists()) {
                return;
            }
            if (isWhitelist) {
                ThermalFoundation.LOG.info("[Whitelist] Reading established Whitelist from file.");
            } else {
                ThermalFoundation.LOG.info("[Blacklist] Reading established Blacklist from file.");
            }
            Scanner scan = new Scanner(filterList);
            while (scan.hasNext()) {
                String[] line = scan.next().split("\\n");
                String[] tokens = line[0].split(":");
                if (tokens.length != 1) continue;
                listNames.add(line[0]);
                if (!logEntries) continue;
                if (isWhitelist) {
                    ThermalFoundation.LOG.info("[Whitelist] The Forge Lexicon will allow conversions for ALL items of type '" + line[0] + "'.");
                    continue;
                }
                ThermalFoundation.LOG.info("[Blacklist] The Forge Lexicon will disable conversions for ALL items of type '" + line[0] + "'.");
            }
            scan.close();
        }
        catch (Throwable t) {
            ThermalFoundation.LOG.warn("There is an error in the " + filterList.getName() + " file!");
            t.printStackTrace();
        }
    }

    private static void sortOreNames() {
        String[] ores;
        for (String ore : ores = OreDictionary.getOreNames()) {
            if (!LexiconManager.validType(ore) || OreDictionaryArbiter.getOres((String)ore) == null) continue;
            sortedNames.add(ore);
        }
        Collections.sort(sortedNames);
    }

    public static List<String> getSortedOreNames() {
        return sortedNames;
    }

    public static boolean validOre(ItemStack stack) {
        if (blacklistStacks.contains(new ItemWrapper(stack)) || ItemHelper.getItemDamage((ItemStack)stack) == Short.MAX_VALUE) {
            return false;
        }
        return ItemHelper.hasOreName((ItemStack)stack) && isWhitelist == listNames.contains(OreDictionaryArbiter.getOreName((ItemStack)stack));
    }

    private static boolean validType(String oreName) {
        return isWhitelist == listNames.contains(oreName);
    }

    public static ItemStack getPreferredStack(EntityPlayer player, ItemStack stack) {
        ItemStack retStack;
        String oreName;
        NBTTagCompound lexicon;
        NBTTagCompound tag = player.getEntityData();
        if (tag.func_74764_b("thermalfoundation.lexicon_data") && (lexicon = tag.func_74775_l("thermalfoundation.lexicon_data")).func_74764_b(oreName = OreDictionaryArbiter.getOreName((ItemStack)stack)) && ItemHelper.isOreNameEqual((ItemStack)(retStack = new ItemStack(lexicon.func_74775_l(oreName))), (String)oreName)) {
            return ItemHelper.cloneStack((ItemStack)retStack, (int)stack.func_190916_E());
        }
        ItemStack defaultStack = (ItemStack)OreDictionaryArbiter.getOres((ItemStack)stack).get(0);
        if (ItemHelper.getItemDamage((ItemStack)defaultStack) == Short.MAX_VALUE) {
            return stack;
        }
        return ItemHelper.cloneStack((ItemStack)defaultStack, (int)stack.func_190916_E());
    }

    public static ItemStack getPreferredStack(EntityPlayer player, String oreName) {
        ItemStack retStack;
        NBTTagCompound lexicon;
        NBTTagCompound tag = player.getEntityData();
        if (tag.func_74764_b("thermalfoundation.lexicon_data") && (lexicon = tag.func_74775_l("thermalfoundation.lexicon_data")).func_74764_b(oreName) && ItemHelper.isOreNameEqual((ItemStack)(retStack = new ItemStack(lexicon.func_74775_l(oreName))), (String)oreName)) {
            return ItemHelper.cloneStack((ItemStack)retStack, (int)1);
        }
        return ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionaryArbiter.getOres((String)oreName).get(0)), (int)1);
    }

    public static void setPreferredStack(EntityPlayer player, ItemStack stack) {
        NBTTagCompound tag = player.getEntityData();
        NBTTagCompound lexicon = tag.func_74775_l("thermalfoundation.lexicon_data");
        String oreName = OreDictionaryArbiter.getOreName((ItemStack)stack);
        lexicon.func_74782_a(oreName, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        tag.func_74782_a("thermalfoundation.lexicon_data", (NBTBase)lexicon);
    }

    public static void clearPreferredStack(EntityPlayer player, ItemStack stack) {
        NBTTagCompound tag = player.getEntityData();
        NBTTagCompound lexicon = tag.func_74775_l("thermalfoundation.lexicon_data");
        String oreName = OreDictionaryArbiter.getOreName((ItemStack)stack);
        lexicon.func_82580_o(oreName);
        tag.func_74782_a("thermalfoundation.lexicon_data", (NBTBase)lexicon);
    }

    public static boolean hasPreferredStack(EntityPlayer player, String oreName) {
        NBTTagCompound tag = player.getEntityData();
        NBTTagCompound lexicon = tag.func_74775_l("thermalfoundation.lexicon_data");
        return lexicon.func_74764_b(oreName);
    }

    public static boolean addBlacklistEntry(ItemStack stack) {
        return !stack.func_190926_b() && blacklistStacks.add(new ItemWrapper(stack));
    }

    public static boolean removeBlacklistEntry(ItemStack stack) {
        return !stack.func_190926_b() && blacklistStacks.remove(new ItemWrapper(stack));
    }
}

