/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.util.crafting;

import cofh.thermalfoundation.util.helpers.FluidPotionHelper;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class ShapelessPotionFillRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        ShapelessOreRecipe recipe = ShapelessOreRecipe.factory((JsonContext)context, (JsonObject)json);
        return new ShapelessPotionFillRecipe(new ResourceLocation("thermalfoundation", "potion_fill_shapeless"), recipe.func_77571_b(), recipe.func_192400_c().toArray());
    }

    public static class ShapelessPotionFillRecipe
    extends ShapelessOreRecipe {
        public ShapelessPotionFillRecipe(ResourceLocation group, ItemStack result, Object ... recipe) {
            super(group, result, recipe);
        }

        public boolean isPotion(ItemStack stack) {
            Item item = stack.func_77973_b();
            return item.equals(Items.field_151068_bn) || item.equals(Items.field_185155_bH) || item.equals(Items.field_185156_bI);
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            NonNullList ret = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < ret.size(); ++i) {
                if (!this.isPotion(inv.func_70301_a(i))) continue;
                ret.set(i, (Object)new ItemStack(Items.field_151069_bo));
            }
            return ret;
        }

        @Nonnull
        public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
            ItemStack potionStack = ItemStack.field_190927_a;
            IFluidHandlerItem handler = null;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (this.isPotion(stack)) {
                    potionStack = stack.func_77946_l();
                    continue;
                }
                if (handler != null) continue;
                handler = FluidUtil.getFluidHandler((ItemStack)stack.func_77946_l());
            }
            if (potionStack.func_190926_b() || handler == null) {
                return ItemStack.field_190927_a;
            }
            FluidStack potionFluid = FluidPotionHelper.getFluidPotion(250, potionStack);
            if (handler.fill(potionFluid, false) < 250) {
                return ItemStack.field_190927_a;
            }
            handler.fill(potionFluid, true);
            return handler.getContainer().func_77946_l();
        }

        public boolean func_192399_d() {
            return true;
        }
    }
}

