/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.experimental;

import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.experimental.EventLoopBase;
import kotlinx.coroutines.experimental.TimeSourceKt;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\b\u00c1\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0003J\b\u0010\u0016\u001a\u00020\rH\u0003J\r\u0010\u0017\u001a\u00020\u0015H\u0001\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u000fH\u0014J\b\u0010\u001a\u001a\u00020\u0015H\u0003J\b\u0010\u001b\u001a\u00020\u0015H\u0016J\u0015\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0001\u00a2\u0006\u0002\b\u001eJ\b\u0010\u001f\u001a\u00020\rH\u0002J\b\u0010 \u001a\u00020\u0015H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006!"}, d2={"Lkotlinx/coroutines/experimental/DefaultExecutor;", "Lkotlinx/coroutines/experimental/EventLoopBase;", "Ljava/lang/Runnable;", "()V", "ACTIVE", "", "DEFAULT_KEEP_ALIVE", "", "FRESH", "KEEP_ALIVE_NANOS", "SHUTDOWN_ACK", "SHUTDOWN_REQ", "_thread", "Ljava/lang/Thread;", "canComplete", "", "getCanComplete", "()Z", "debugStatus", "isCompleted", "acknowledgeShutdown", "", "createThreadSync", "ensureStarted", "ensureStarted$kotlinx_coroutines_core", "isCorrectThread", "notifyStartup", "run", "shutdown", "timeout", "shutdown$kotlinx_coroutines_core", "thread", "unpark", "kotlinx-coroutines-core"})
public final class DefaultExecutor
extends EventLoopBase
implements Runnable {
    private static final long DEFAULT_KEEP_ALIVE = 1000L;
    private static final long KEEP_ALIVE_NANOS;
    private static volatile Thread _thread;
    private static final int FRESH = 0;
    private static final int ACTIVE = 1;
    private static final int SHUTDOWN_REQ = 2;
    private static final int SHUTDOWN_ACK = 3;
    private static volatile int debugStatus;
    public static final DefaultExecutor INSTANCE;

    @Override
    protected boolean getCanComplete() {
        return false;
    }

    @Override
    protected boolean isCompleted() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long shutdownNanos = Long.MAX_VALUE;
        TimeSourceKt.getTimeSource().registerTimeLoopThread();
        this.notifyStartup();
        try {
            while (true) {
                Thread.interrupted();
                long parkNanos = this.processNextEvent();
                if (parkNanos == Long.MAX_VALUE) {
                    if (shutdownNanos == Long.MAX_VALUE) {
                        long tillShutdown;
                        long now = TimeSourceKt.getTimeSource().nanoTime();
                        if (shutdownNanos == Long.MAX_VALUE) {
                            shutdownNanos = now + KEEP_ALIVE_NANOS;
                        }
                        if ((tillShutdown = shutdownNanos - now) <= 0L) {
                            break;
                        }
                        parkNanos = RangesKt.coerceAtMost(parkNanos, tillShutdown);
                    } else {
                        parkNanos = RangesKt.coerceAtMost(parkNanos, KEEP_ALIVE_NANOS);
                    }
                }
                if (parkNanos <= 0L) continue;
                if (debugStatus == 2) {
                    this.acknowledgeShutdown();
                    break;
                }
                TimeSourceKt.getTimeSource().parkNanos(this, parkNanos);
            }
        }
        finally {
            _thread = null;
            TimeSourceKt.getTimeSource().unregisterTimeLoopThread();
            if (!this.isEmpty()) {
                this.thread();
            }
        }
    }

    private final Thread thread() {
        Thread thread2 = _thread;
        if (thread2 == null) {
            thread2 = this.createThreadSync();
        }
        return thread2;
    }

    private final synchronized Thread createThreadSync() {
        Thread thread2 = _thread;
        if (thread2 == null) {
            Thread thread3;
            Thread $receiver;
            _thread = $receiver = (thread3 = new Thread((Runnable)this, "kotlinx.coroutines.DefaultExecutor"));
            $receiver.setDaemon(true);
            $receiver.start();
            thread2 = thread3;
        }
        return thread2;
    }

    @Override
    protected void unpark() {
        TimeSourceKt.getTimeSource().unpark(this.thread());
    }

    @Override
    protected boolean isCorrectThread() {
        return true;
    }

    public final synchronized void ensureStarted$kotlinx_coroutines_core() {
        boolean bl;
        boolean bl2 = bl = _thread == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        debugStatus = 0;
        this.createThreadSync();
        while (debugStatus == 0) {
            DefaultExecutor defaultExecutor = this;
            if (defaultExecutor == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
            }
            ((Object)defaultExecutor).wait();
        }
    }

    private final synchronized void notifyStartup() {
        debugStatus = 1;
        DefaultExecutor defaultExecutor = this;
        if (defaultExecutor == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
        }
        ((Object)defaultExecutor).notifyAll();
    }

    public final synchronized void shutdown$kotlinx_coroutines_core(long timeout) {
        if (_thread != null) {
            long remaining;
            long deadline = System.currentTimeMillis() + timeout;
            if (debugStatus == 1) {
                debugStatus = 2;
            }
            this.unpark();
            while (debugStatus != 3 && _thread != null && (remaining = deadline - System.currentTimeMillis()) > 0L) {
                DefaultExecutor defaultExecutor = this;
                if (defaultExecutor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
                }
                ((Object)defaultExecutor).wait(timeout);
            }
        }
        debugStatus = 0;
    }

    private final synchronized void acknowledgeShutdown() {
        debugStatus = 3;
        this.clearAll();
        DefaultExecutor defaultExecutor = this;
        if (defaultExecutor == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Object");
        }
        ((Object)defaultExecutor).notifyAll();
    }

    private DefaultExecutor() {
        Long l;
        TimeUnit timeUnit;
        INSTANCE = this;
        TimeUnit timeUnit2 = TimeUnit.MILLISECONDS;
        try {
            timeUnit = timeUnit2;
            l = Long.getLong("kotlinx.coroutines.DefaultExecutor.keepAlive", 1000L);
        }
        catch (SecurityException e) {
            timeUnit = timeUnit2;
            l = 1000L;
        }
        Long l2 = l;
        Intrinsics.checkExpressionValueIsNotNull(l2, "try {\n            java.l\u2026AULT_KEEP_ALIVE\n        }");
        KEEP_ALIVE_NANOS = timeUnit.toNanos(l2);
    }

    static {
        new DefaultExecutor();
    }
}

