/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.api.core.IPortableData;
import cofh.core.block.TileCore;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileTEBase
extends TileCore
implements ITilePacketHandler,
IPortableData {
    public String customName = "";
    public static final int NONE = 0;
    public static final int INPUT_ALL = 1;
    public static final int OUTPUT_PRIMARY = 2;
    public static final int OUTPUT_SECONDARY = 3;
    public static final int OUTPUT_ALL = 4;
    public static final int INPUT_PRIMARY = 5;
    public static final int INPUT_SECONDARY = 6;
    public static final int OPEN = 7;
    public static final int OMNI = 8;
    public static boolean[] SIDE_INSERTION = new boolean[]{false, true, false, false, false, true, true, true, true};
    public static boolean[] SIDE_EXTRACTION = new boolean[]{false, true, true, true, true, true, true, true, true};
    public static boolean[] SIDE_INPUT_PRIMARY = new boolean[]{false, true, false, false, false, true, false, false, true};
    public static boolean[] SIDE_INPUT_SECONDARY = new boolean[]{false, true, false, false, false, false, true, false, true};
    public static boolean[] SIDE_OUTPUT_PRIMARY = new boolean[]{false, false, true, false, true, false, false, false, true};
    public static boolean[] SIDE_OUTPUT_SECONDARY = new boolean[]{false, false, false, true, true, false, false, false, true};

    public void setCustomName(String name) {
        if (!name.isEmpty()) {
            this.customName = name;
        }
    }

    protected abstract Object getMod();

    protected abstract String getModVersion();

    protected abstract String getTileName();

    public abstract int getType();

    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        return true;
    }

    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        return true;
    }

    public int getScaledProgress(int scale) {
        return 0;
    }

    public int getScaledSpeed(int scale) {
        return 0;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (this.hasGui()) {
            player.openGui(this.getMod(), 0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
        return this.hasGui();
    }

    @Override
    public boolean openConfigGui(EntityPlayer player) {
        if (this.hasConfigGui()) {
            player.openGui(this.getMod(), 1, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
        return this.hasConfigGui();
    }

    @Override
    public void sendGuiNetworkData(Container container, IContainerListener listener) {
        PacketBase guiPacket;
        if (listener instanceof EntityPlayer && (guiPacket = this.getGuiPacket()) != null) {
            PacketHandler.sendTo(guiPacket, (EntityPlayer)listener);
        }
    }

    public FluidTankCore getTank() {
        return null;
    }

    public FluidStack getTankFluid() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("Name")) {
            this.customName = nbt.func_74779_i("Name");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("Version", this.getModVersion());
        if (!this.customName.isEmpty()) {
            nbt.func_74778_a("Name", this.customName);
        }
        return nbt;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addString(this.customName);
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        this.customName = payload.getString();
        this.field_145850_b.func_175664_x(this.field_174879_c);
    }

    @Override
    public String getDataType() {
        return this.getTileName();
    }

    @Override
    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        if (!this.canPlayerAccess(player)) {
            return;
        }
        if (this.readPortableTagInternal(player, tag)) {
            this.markChunkDirty();
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        if (!this.canPlayerAccess(player)) {
            return;
        }
        this.writePortableTagInternal(player, tag);
    }

    public boolean allowInsertion(int type) {
        return SIDE_INSERTION[type];
    }

    public boolean allowExtraction(int type) {
        return SIDE_EXTRACTION[type];
    }

    public boolean isPrimaryInput(int type) {
        return SIDE_INPUT_PRIMARY[type];
    }

    public boolean isSecondaryInput(int type) {
        return SIDE_INPUT_SECONDARY[type];
    }

    public boolean isPrimaryOutput(int type) {
        return SIDE_OUTPUT_PRIMARY[type];
    }

    public boolean isSecondaryOutput(int type) {
        return SIDE_OUTPUT_SECONDARY[type];
    }

    public static class SlotConfig {
        public boolean[] allowInsertionSlot;
        public boolean[] allowExtractionSlot;
    }

    public static class SideConfig {
        public int numConfig;
        public int[] sideTypes;
        public int[][] slotGroups;
        public byte[] defaultSides;
    }

    public static class EnergyConfig {
        public int minPower = 2;
        public int maxPower = 20;
        public int maxEnergy = 20000;
        public int minPowerLevel = this.maxEnergy / 10;
        public int maxPowerLevel = 9 * this.maxEnergy / 10;
        public int energyRamp = this.maxPowerLevel / this.maxPower;

        public EnergyConfig() {
        }

        public EnergyConfig(EnergyConfig config) {
            this.minPower = config.minPower;
            this.maxPower = config.maxPower;
            this.maxEnergy = config.maxEnergy;
            this.minPowerLevel = config.minPowerLevel;
            this.maxPowerLevel = config.maxPowerLevel;
            this.energyRamp = config.energyRamp;
        }

        public EnergyConfig copy() {
            return new EnergyConfig(this);
        }

        public boolean setDefaultParams(int basePower) {
            this.maxPower = basePower;
            this.minPower = basePower / 10;
            this.maxEnergy = basePower * 1000;
            this.maxPowerLevel = 9 * this.maxEnergy / 10;
            this.minPowerLevel = this.maxEnergy / 10;
            this.energyRamp = this.maxPowerLevel / basePower;
            return true;
        }

        public boolean setDefaultParams(int basePower, boolean smallStorage) {
            if (!smallStorage) {
                return this.setDefaultParams(basePower);
            }
            this.maxPower = basePower;
            this.minPower = basePower;
            this.maxEnergy = basePower * 10;
            this.maxPowerLevel = this.maxPower;
            this.minPowerLevel = this.maxPower - 1;
            this.energyRamp = 1;
            return true;
        }
    }
}

