/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.gui.element.tab;

import cofh.api.tileentity.ISteamInfo;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.init.CoreTextures;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;

public class TabSteam
extends TabBase {
    public static int defaultSide = 0;
    public static int defaultHeaderColor = 14797103;
    public static int defaultSubHeaderColor = 11186104;
    public static int defaultTextColor = 0;
    public static int defaultBackgroundColorOut = 14255164;
    public static int defaultBackgroundColorIn = 3903961;
    private ISteamInfo myContainer;
    private boolean isProducer;
    private boolean displayMax = true;
    private boolean displayStored = true;
    static final String UNIT_INSTANT = " mB/t";

    public TabSteam(GuiContainerCore gui, ISteamInfo container, boolean isProducer) {
        this(gui, defaultSide, container, isProducer);
    }

    public TabSteam(GuiContainerCore gui, int side, ISteamInfo container, boolean producer) {
        super(gui, side);
        this.headerColor = defaultHeaderColor;
        this.subheaderColor = defaultSubHeaderColor;
        this.textColor = defaultTextColor;
        this.backgroundColor = producer ? defaultBackgroundColorOut : defaultBackgroundColorIn;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.myContainer = container;
        this.isProducer = producer;
    }

    public TabSteam isProducer(boolean isProducer) {
        this.isProducer = isProducer;
        return this;
    }

    public TabSteam displayMax(boolean displayMax) {
        this.displayMax = displayMax;
        return this;
    }

    public TabSteam displayStored(boolean displayStored) {
        this.displayStored = displayStored;
        return this;
    }

    @Override
    protected void drawForeground() {
        this.drawTabIcon(CoreTextures.ICON_STEAM);
        if (!this.isFullyOpened()) {
            return;
        }
        String flowDirection = this.isProducer ? "info.cofh.steamProduce" : "info.cofh.steamConsume";
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.steam"), (float)(this.posXOffset() + 20), (float)(this.posY + 6), this.headerColor);
        this.getFontRenderer().func_175063_a(StringHelper.localize(flowDirection) + ":", (float)(this.posXOffset() + 6), (float)(this.posY + 18), this.subheaderColor);
        this.getFontRenderer().func_78276_b(this.myContainer.getInfoSteamPerTick() + UNIT_INSTANT, this.posXOffset() + 14, this.posY + 30, this.textColor);
        this.getFontRenderer().func_175063_a(StringHelper.localize("info.cofh.steamMax") + ":", (float)(this.posXOffset() + 6), (float)(this.posY + 42), this.subheaderColor);
        this.getFontRenderer().func_78276_b(this.myContainer.getInfoMaxSteamPerTick() + UNIT_INSTANT, this.posXOffset() + 14, this.posY + 54, this.textColor);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void addTooltip(List<String> list) {
        if (!this.isFullyOpened()) {
            list.add(this.myContainer.getInfoSteamPerTick() + UNIT_INSTANT);
        }
    }

    public void setProducer(boolean producer) {
        this.backgroundColor = producer ? defaultBackgroundColorOut : defaultBackgroundColorIn;
        this.isProducer = producer;
    }
}

