/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item.tool;

import cofh.core.item.IAOEBreakItem;
import cofh.core.item.tool.ItemToolCore;
import cofh.core.util.RayTracer;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ItemHammerCore
extends ItemToolCore
implements IAOEBreakItem {
    public ItemHammerCore(Item.ToolMaterial toolMaterial) {
        super(4.0f, -3.4f, toolMaterial);
        this.addToolClass("pickaxe");
        this.addToolClass("hammer");
        this.func_77656_e(toolMaterial.func_77997_a() * 2);
        this.field_150914_c.addAll((Collection)ItemPickaxe.field_150915_c);
        this.effectiveMaterials.add((Object)Material.field_151573_f);
        this.effectiveMaterials.add((Object)Material.field_151574_g);
        this.effectiveMaterials.add((Object)Material.field_151576_e);
        this.effectiveMaterials.add((Object)Material.field_151588_w);
        this.effectiveMaterials.add((Object)Material.field_151598_x);
        this.effectiveMaterials.add((Object)Material.field_151592_s);
        this.effectiveMaterials.add((Object)Material.field_151591_t);
        if (this.harvestLevel > 0) {
            this.field_77865_bY = 10.0f;
            this.field_185065_c = -3.5f + 0.1f * (float)this.harvestLevel;
        } else {
            this.field_77865_bY = 7.0f;
            this.field_185065_c = -3.4f + 0.1f * (float)((int)(this.field_77864_a / 5.0f));
        }
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185887_b(world, pos) == 0.0f) {
            return false;
        }
        if (!this.canHarvestBlock(state, stack)) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return false;
        }
        if (player.func_70093_af()) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return false;
        }
        float refStrength = state.func_185903_a(player, world, pos);
        if (refStrength != 0.0f) {
            RayTraceResult traceResult = RayTracer.retrace(player, false);
            if (traceResult == null || traceResult.field_178784_b == null) {
                return false;
            }
            int count = 0;
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            int radius = 1;
            switch (traceResult.field_178784_b) {
                case DOWN: 
                case UP: {
                    for (int i = x - radius; i <= x + radius; ++i) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (i == x && k == z || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(i, y, k))).func_185903_a(player, world, adjPos)) > 0.0f) || !(refStrength / strength <= 4.0f) || !this.harvestBlock(world, adjPos, player)) continue;
                            ++count;
                        }
                    }
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    for (int i = x - radius; i <= x + radius; ++i) {
                        for (int j = y - radius; j <= y + radius; ++j) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (i == x && j == y || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(i, j, z))).func_185903_a(player, world, adjPos)) > 0.0f) || !(refStrength / strength <= 4.0f) || !this.harvestBlock(world, adjPos, player)) continue;
                            ++count;
                        }
                    }
                    break;
                }
                case WEST: 
                case EAST: {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        for (int k = z - radius; k <= z + radius; ++k) {
                            BlockPos adjPos;
                            IBlockState adjState;
                            float strength;
                            if (j == y && k == z || !((strength = (adjState = world.func_180495_p(adjPos = new BlockPos(x, j, k))).func_185903_a(player, world, adjPos)) > 0.0f) || !(refStrength / strength <= 4.0f) || !this.harvestBlock(world, adjPos, player)) continue;
                            ++count;
                        }
                    }
                    break;
                }
            }
            if (count > 0 && !player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(count, (EntityLivingBase)player);
            }
        }
        return false;
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, BlockPos pos, EntityPlayer player) {
        ArrayList<BlockPos> area = new ArrayList<BlockPos>();
        World world = player.func_130014_f_();
        RayTraceResult traceResult = RayTracer.retrace(player, false);
        if (traceResult == null || traceResult.field_178784_b == null || !this.canHarvestBlock(world.func_180495_p(pos), stack) || player.func_70093_af()) {
            return ImmutableList.copyOf(area);
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int radius = 1;
        switch (traceResult.field_178784_b) {
            case DOWN: 
            case UP: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos harvestPos;
                        if (i == x && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, y, k)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
            case NORTH: 
            case SOUTH: {
                for (int i = x - radius; i <= x + radius; ++i) {
                    for (int j = y - radius; j <= y + radius; ++j) {
                        BlockPos harvestPos;
                        if (i == x && j == y || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(i, j, z)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
            case WEST: 
            case EAST: {
                for (int j = y - radius; j <= y + radius; ++j) {
                    for (int k = z - radius; k <= z + radius; ++k) {
                        BlockPos harvestPos;
                        if (j == y && k == z || !this.canHarvestBlock(world.func_180495_p(harvestPos = new BlockPos(x, j, k)), stack)) continue;
                        area.add(harvestPos);
                    }
                }
                break;
            }
        }
        return ImmutableList.copyOf(area);
    }
}

