/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network;

import cofh.CoFHCore;
import cofh.api.core.IFilterable;
import cofh.api.core.ISecurable;
import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ITransferControl;
import cofh.core.gui.container.IAugmentableContainer;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class PacketCore
extends PacketBase {
    public static void initialize() {
        PacketHandler.INSTANCE.registerPacket(PacketCore.class);
    }

    @Override
    public void handlePacket(EntityPlayer player, boolean isServer) {
        try {
            byte type = this.getByte();
            switch (PacketTypes.values()[type]) {
                case RS_POWER_UPDATE: {
                    TileEntity tile;
                    BlockPos pos = this.getCoords();
                    if (player.field_70170_p.func_175667_e(pos) && (tile = player.field_70170_p.func_175625_s(pos)) instanceof IRedstoneControl) {
                        IRedstoneControl rs = (IRedstoneControl)tile;
                        rs.setPowered(this.getBool());
                    }
                    return;
                }
                case RS_CONFIG_UPDATE: {
                    TileEntity tile;
                    BlockPos pos = this.getCoords();
                    if (player.field_70170_p.func_175667_e(pos) && (tile = player.field_70170_p.func_175625_s(pos)) instanceof IRedstoneControl) {
                        IRedstoneControl rs = (IRedstoneControl)tile;
                        rs.setControl(IRedstoneControl.ControlMode.values()[this.getByte()]);
                    }
                    return;
                }
                case TRANSFER_UPDATE: {
                    TileEntity tile;
                    BlockPos pos = this.getCoords();
                    if (player.field_70170_p.func_175667_e(pos) && (tile = player.field_70170_p.func_175625_s(pos)) instanceof ITransferControl) {
                        ITransferControl transfer = (ITransferControl)tile;
                        transfer.setTransferIn(this.getBool());
                        transfer.setTransferOut(this.getBool());
                    }
                    return;
                }
                case SECURITY_UPDATE: {
                    if (player.field_71070_bA instanceof ISecurable) {
                        ((ISecurable)player.field_71070_bA).setAccess(ISecurable.AccessMode.values()[this.getByte()]);
                    }
                    return;
                }
                case FILTER_UPDATE: {
                    if (player.field_71070_bA instanceof IFilterable && isServer) {
                        ((IFilterable)player.field_71070_bA).setFlag(this.getInt(), this.getBool());
                    }
                    return;
                }
                case TAB_AUGMENT: {
                    if (player.field_71070_bA instanceof IAugmentableContainer) {
                        ((IAugmentableContainer)player.field_71070_bA).setAugmentLock(this.getBool());
                    }
                    return;
                }
                case CONFIG_SYNC: {
                    return;
                }
            }
            CoFHCore.LOG.error("Unknown Packet! Internal: COFH, ID: " + type);
        }
        catch (Exception e) {
            CoFHCore.LOG.error("Packet payload failure! Please check your config files!");
            e.printStackTrace();
        }
    }

    public static void sendRSPowerUpdatePacketToClients(IRedstoneControl rs, World world, BlockPos pos) {
        PacketCore.sendRSPowerUpdatePacketToClients(rs, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private static void sendRSPowerUpdatePacketToClients(IRedstoneControl rs, World world, int x, int y, int z) {
        PacketHandler.sendToAllAround(PacketCore.getPacket(PacketTypes.RS_POWER_UPDATE).addCoords(x, y, z).addBool(rs.isPowered()), world, x, y, z);
    }

    public static void sendRSConfigUpdatePacketToServer(IRedstoneControl rs, BlockPos pos) {
        PacketCore.sendRSConfigUpdatePacketToServer(rs, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private static void sendRSConfigUpdatePacketToServer(IRedstoneControl rs, int x, int y, int z) {
        PacketHandler.sendToServer(PacketCore.getPacket(PacketTypes.RS_CONFIG_UPDATE).addCoords(x, y, z).addByte(rs.getControl().ordinal()));
    }

    public static void sendTransferUpdatePacketToServer(ITransferControl transfer, BlockPos pos) {
        PacketCore.sendTransferUpdatePacketToServer(transfer, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private static void sendTransferUpdatePacketToServer(ITransferControl transfer, int x, int y, int z) {
        PacketHandler.sendToServer(PacketCore.getPacket(PacketTypes.TRANSFER_UPDATE).addCoords(x, y, z).addBool(transfer.getTransferIn()).addBool(transfer.getTransferOut()));
    }

    public static void sendSecurityPacketToServer(ISecurable securable) {
        PacketHandler.sendToServer(PacketCore.getPacket(PacketTypes.SECURITY_UPDATE).addByte(securable.getAccess().ordinal()));
    }

    public static void sendFilterPacketToServer(int flag, boolean value) {
        PacketHandler.sendToServer(PacketCore.getPacket(PacketTypes.FILTER_UPDATE).addInt(flag).addBool(value));
    }

    public static void sendTabAugmentPacketToServer(boolean lock) {
        PacketHandler.sendToServer(PacketCore.getPacket(PacketTypes.TAB_AUGMENT).addBool(lock));
    }

    public static void sendConfigSyncPacketToClient(EntityPlayer player) {
    }

    public static PacketBase getPacket(PacketTypes type) {
        return new PacketCore().addByte(type.ordinal());
    }

    public static enum PacketTypes {
        RS_POWER_UPDATE,
        RS_CONFIG_UPDATE,
        TRANSFER_UPDATE,
        SECURITY_UPDATE,
        FILTER_UPDATE,
        TAB_AUGMENT,
        CONFIG_SYNC;

    }
}

