/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.api.item.IToolDye;
import cofh.core.util.oredict.OreDictionaryArbiter;
import gnu.trove.map.hash.THashMap;
import net.minecraft.item.ItemStack;

public final class ColorHelper {
    public static final int DYE_BLACK = 0x191919;
    public static final int DYE_RED = 0xCC4C4C;
    public static final int DYE_GREEN = 6717235;
    public static final int DYE_BROWN = 8349260;
    public static final int DYE_BLUE = 0x3366CC;
    public static final int DYE_PURPLE = 11691749;
    public static final int DYE_CYAN = 5020082;
    public static final int DYE_LIGHT_GRAY = 0x999999;
    public static final int DYE_GRAY = 0x4C4C4C;
    public static final int DYE_PINK = 15905484;
    public static final int DYE_LIME = 8375321;
    public static final int DYE_YELLOW = 0xE5E533;
    public static final int DYE_LIGHT_BLUE = 10072818;
    public static final int DYE_MAGENTA = 15040472;
    public static final int DYE_ORANGE = 15905331;
    public static final int DYE_WHITE = 0xFFFFFF;
    public static final int[] DYE_COLORS = new int[]{0x191919, 0xCC4C4C, 6717235, 8349260, 0x3366CC, 11691749, 5020082, 0x999999, 0x4C4C4C, 15905484, 8375321, 0xE5E533, 10072818, 15040472, 15905331, 0xFFFFFF};
    public static final String[] WOOL_COLOR_CONFIG = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "Gray", "LightGray", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
    public static final THashMap<String, Integer> COLOR_MAP = new THashMap();

    private ColorHelper() {
    }

    public static boolean isDye(ItemStack stack) {
        if (stack.func_77973_b() instanceof IToolDye) {
            return ((IToolDye)stack.func_77973_b()).hasColor(stack);
        }
        for (String ore : OreDictionaryArbiter.getAllOreNames(stack)) {
            if (!ore.startsWith("dye") && !ore.equals("dye")) continue;
            return true;
        }
        return false;
    }

    public static int getDyeColor(int color) {
        return color < 0 || color > 15 ? 0xFFFFFF : DYE_COLORS[color];
    }

    public static int getDyeColor(ItemStack stack) {
        if (stack.func_77973_b() instanceof IToolDye) {
            return ((IToolDye)stack.func_77973_b()).getColor(stack);
        }
        for (String ore : OreDictionaryArbiter.getAllOreNames(stack)) {
            if (!ore.startsWith("dye") || ore.equals("dye")) continue;
            return (Integer)COLOR_MAP.get((Object)ore);
        }
        return 0xFFFFFF;
    }

    public static boolean hasColor0(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Color0");
    }

    public static boolean hasColor1(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Color1");
    }

    public static int getColor0(ItemStack stack) {
        return !stack.func_77942_o() ? 0xFFFFFF : stack.func_77978_p().func_74762_e("Color0");
    }

    public static int getColor1(ItemStack stack) {
        return !stack.func_77942_o() ? 0xFFFFFF : stack.func_77978_p().func_74762_e("Color1");
    }

    static {
        COLOR_MAP.put((Object)"dyeBlack", (Object)0x191919);
        COLOR_MAP.put((Object)"dyeRed", (Object)0xCC4C4C);
        COLOR_MAP.put((Object)"dyeGreen", (Object)6717235);
        COLOR_MAP.put((Object)"dyeBrown", (Object)8349260);
        COLOR_MAP.put((Object)"dyeBlue", (Object)0x3366CC);
        COLOR_MAP.put((Object)"dyePurple", (Object)11691749);
        COLOR_MAP.put((Object)"dyeCyan", (Object)5020082);
        COLOR_MAP.put((Object)"dyeLightGray", (Object)0x999999);
        COLOR_MAP.put((Object)"dyeGray", (Object)0x4C4C4C);
        COLOR_MAP.put((Object)"dyePink", (Object)15905484);
        COLOR_MAP.put((Object)"dyeLime", (Object)8375321);
        COLOR_MAP.put((Object)"dyeYellow", (Object)0xE5E533);
        COLOR_MAP.put((Object)"dyeLightBlue", (Object)10072818);
        COLOR_MAP.put((Object)"dyeMagenta", (Object)15040472);
        COLOR_MAP.put((Object)"dyeOrange", (Object)15905331);
        COLOR_MAP.put((Object)"dyeWhite", (Object)0xFFFFFF);
    }
}

