/*
 * Decompiled with CFR 0.152.
 */
package nex;

import java.io.File;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import nex.NetherExCreativeTab;
import nex.init.NetherExBiomes;
import nex.init.NetherExEntities;
import nex.init.NetherExOreDict;
import nex.init.NetherExRecipes;
import nex.proxy.IProxy;
import nex.village.TradeManager;
import nex.world.biome.NetherBiomeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="nex", name="NetherEx", version="2.1.14.15", dependencies="required-after:forge@[1.12-14.21.1.2387,);after:natura;", updateJSON="https://raw.githubusercontent.com/LogicTechCorp/NetherEx/1.12.x/src/main/resources/assets/nex/version.json", acceptedMinecraftVersions="[1.12]")
public class NetherEx {
    public static final String MOD_ID = "nex";
    public static final String NAME = "NetherEx";
    public static final String VERSION = "2.1.14.15";
    public static final String DEPENDENCIES = "required-after:forge@[1.12-14.21.1.2387,);after:natura;";
    public static final String UPDATE_JSON = "https://raw.githubusercontent.com/LogicTechCorp/NetherEx/1.12.x/src/main/resources/assets/nex/version.json";
    private static final String CLIENT_PROXY = "nex.proxy.CombinedClientProxy";
    private static final String SERVER_PROXY = "nex.proxy.DedicatedServerProxy";
    public static final boolean IS_DEV_ENV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    @Mod.Instance(value="nex")
    public static NetherEx instance;
    @SidedProxy(clientSide="nex.proxy.CombinedClientProxy", serverSide="nex.proxy.DedicatedServerProxy")
    public static IProxy proxy;
    public static final CreativeTabs CREATIVE_TAB;
    private File configDirectory;
    private static final Logger LOGGER;

    @Mod.EventHandler
    public void onFMLPreInitialization(FMLPreInitializationEvent event) {
        LOGGER.info("PreInitialization started.");
        this.configDirectory = event.getModConfigurationDirectory();
        proxy.preInit();
        LOGGER.info("PreInitialization completed.");
    }

    @Mod.EventHandler
    public void onFMLInitialization(FMLInitializationEvent event) {
        LOGGER.info("Initialization started.");
        NetherExBiomes.init();
        NetherExEntities.init();
        TradeManager.init(new File(this.configDirectory, "/NetherEx/Trade Lists"));
        NetherExRecipes.init();
        NetherExOreDict.init();
        proxy.init();
        LOGGER.info("Initialization completed.");
    }

    @Mod.EventHandler
    public void onFMLPostInitialization(FMLPostInitializationEvent event) {
        LOGGER.info("PostInitialization started.");
        NetherExBiomes.postInit();
        NetherBiomeManager.postInit(new File(this.configDirectory, "/NetherEx/Biome Lists"));
        proxy.postInit();
        LOGGER.info("PostInitialization completed.");
    }

    static {
        CREATIVE_TAB = new NetherExCreativeTab();
        LOGGER = LogManager.getLogger((String)"NetherEx|Main");
        FluidRegistry.enableUniversalBucket();
    }
}

