/*
 * Decompiled with CFR 0.152.
 */
package nex.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import nex.block.BlockNetherEx;
import nex.init.NetherExItems;

public class BlockElderMushroomStem
extends BlockNetherEx {
    public static final PropertyEnum<EnumType> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumType.class);

    public BlockElderMushroomStem() {
        super("plant_mushroom_elder_stem", Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(0.2f);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a(AXIS, (Comparable)((Object)EnumType.fromAxis(facing.func_176740_k())));
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return player.func_184614_ca().func_77973_b() == NetherExItems.TOOL_AXE_BONE;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((Object)EnumType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(AXIS))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS});
    }

    public static enum EnumType implements IStringSerializable
    {
        Y,
        X,
        Z,
        NONE;


        public String func_176610_l() {
            return this.toString().toLowerCase();
        }

        public static EnumType fromMeta(int meta) {
            if (meta < 0 || meta >= EnumType.values().length) {
                meta = 0;
            }
            return EnumType.values()[meta];
        }

        public static EnumType fromAxis(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return X;
                }
                case Y: {
                    return Y;
                }
                case Z: {
                    return Z;
                }
            }
            return NONE;
        }
    }
}

