/*
 * Decompiled with CFR 0.152.
 */
package nex.block;

import com.google.common.base.CaseFormat;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockWall;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import nex.NetherEx;
import org.apache.commons.lang3.StringUtils;

public class BlockNetherExFenceGate
extends BlockFenceGate {
    public BlockNetherExFenceGate(String name, Material material) {
        super(BlockPlanks.EnumType.OAK);
        ReflectionHelper.setPrivateValue(Block.class, (Object)((Object)this), (Object)material, (String[])new String[]{"field_149764_J", "blockMaterial"});
        ReflectionHelper.setPrivateValue(Block.class, (Object)((Object)this), (Object)material.func_151565_r(), (String[])new String[]{"field_181083_K", "blockMapColor"});
        String[] nameParts = name.split("_");
        String gateName = ":fenceGate" + StringUtils.capitalize((String)nameParts[0]) + ".";
        String gateType = nameParts[1];
        for (int i = 2; i < nameParts.length; ++i) {
            gateType = gateType + StringUtils.capitalize((String)nameParts[i]);
        }
        this.field_149783_u = true;
        this.func_149647_a(NetherEx.CREATIVE_TAB);
        this.func_149672_a(SoundType.field_185851_d);
        this.setRegistryName(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, "nex:fence_gate_" + (name.contains("vanilla_") ? name.replace("vanilla_", "") : name)));
        this.func_149663_c("nex" + gateName + gateType);
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)field_176466_a) != false ? PathNodeType.DOOR_OPEN : PathNodeType.DOOR_WOOD_CLOSED;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumFacing.Axis facing = ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176740_k();
        Block northBlock = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
        Block eastBlock = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
        Block southBlock = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
        Block westBlock = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
        if (facing == EnumFacing.Axis.Z && (westBlock instanceof BlockWall || eastBlock instanceof BlockWall) || facing == EnumFacing.Axis.X && (northBlock instanceof BlockWall || southBlock instanceof BlockWall)) {
            return state.func_177226_a((IProperty)field_176467_M, (Comparable)Boolean.valueOf(true));
        }
        return state.func_177226_a((IProperty)field_176467_M, (Comparable)Boolean.valueOf(false));
    }
}

