/*
 * Decompiled with CFR 0.152.
 */
package nex.block;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import nex.block.BlockNetherEx;
import nex.handler.ConfigHandler;
import nex.init.NetherExEffects;

public class BlockRime
extends BlockNetherEx {
    public BlockRime() {
        super("block_rime", Material.field_151576_e);
        this.func_149715_a(0.9375f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                for (int y = -1; y < 2; ++y) {
                    this.freezeSurroundings(world, pos.func_177982_a(x, y, z), world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + x), (double)(pos.func_177956_o() + y), (double)(pos.func_177952_p() + z))));
                }
            }
        }
        world.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)rand, (int)20, (int)40));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175684_a(pos, (Block)this, MathHelper.func_76136_a((Random)RANDOM, (int)20, (int)40));
    }

    private void freezeSurroundings(World world, BlockPos pos, List<EntityLivingBase> entities) {
        IBlockState state = world.func_180495_p(pos);
        if (state == Blocks.field_150355_j.func_176223_P() && ConfigHandler.block.rime.canFreezeWater) {
            world.func_180501_a(pos, Blocks.field_150432_aD.func_176223_P(), 3);
        } else if (state == Blocks.field_150353_l.func_176223_P() && ConfigHandler.block.rime.canFreezeLava) {
            world.func_180501_a(pos, Blocks.field_189877_df.func_176223_P(), 3);
        }
        for (EntityLivingBase entity : entities) {
            boolean canFreeze;
            ResourceLocation registryName = EntityList.func_191301_a((Entity)entity);
            if (registryName == null || !(canFreeze = !(entity instanceof EntityPlayer) && !Arrays.asList(ConfigHandler.potionEffect.freeze.blacklist).contains(registryName.toString())) || !ConfigHandler.block.rime.canFreezeMobs) continue;
            entity.func_70690_d(new PotionEffect((Potion)NetherExEffects.FREEZE, 300, 0));
        }
    }
}

