/*
 * Decompiled with CFR 0.152.
 */
package nex.entity.boss;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.World;
import nex.block.BlockUrnOfSorrow;
import nex.entity.ai.EntityAIGhastFly;
import nex.entity.ai.EntityAIGhastLookAround;
import nex.entity.ai.EntityAIGhastQueenFireballAttack;
import nex.entity.monster.EntityGhastling;
import nex.handler.ConfigHandler;
import nex.init.NetherExBlocks;
import nex.init.NetherExLootTables;
import nex.init.NetherExSoundEvents;

public class EntityGhastQueen
extends EntityGhast {
    private int cooldown;
    private int stage;
    private boolean[] stageStarted = new boolean[5];
    private boolean spawnGhastlings;
    private BlockPos urnPos = BlockPos.field_177992_a;
    private final EntityAIBase fireballAttack = new EntityAIGhastQueenFireballAttack(this);
    private final BossInfoServer bossInfo = new BossInfoServer(this.func_145748_c_(), BossInfo.Color.PURPLE, BossInfo.Overlay.PROGRESS);

    public EntityGhastQueen(World world) {
        super(world);
        this.func_70105_a(9.5f, 9.5f);
        this.field_70728_aV = 100;
    }

    protected SoundEvent func_184639_G() {
        return NetherExSoundEvents.ENTITY_AMBIENT_GHAST_QUEEN;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return NetherExSoundEvents.ENTITY_HURT_GHAST_QUEEN;
    }

    protected SoundEvent func_184615_bR() {
        return NetherExSoundEvents.ENTITY_DEATH_GHAST_QUEEN;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIGhastLookAround(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIGhastFly(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(256.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(140.0);
    }

    public float func_70047_e() {
        return 3.75f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getCooldown() == 0) {
            if (this.field_70714_bg.field_75782_a.size() == 2) {
                this.field_70714_bg.func_75776_a(0, this.fireballAttack);
            }
            if (this.getStage() < 4) {
                if (!this.getStageStarted(this.getStage()) && (double)this.func_110143_aJ() < (double)this.func_110138_aP() - (double)this.getStage() * 35.0) {
                    this.setShouldSpawnGhastlings(true);
                }
                if (!this.func_130014_f_().field_72995_K && this.shouldSpawnGhastlings()) {
                    for (int i = 0; i < ConfigHandler.entity.ghastQueen.ghastlingSpawns; ++i) {
                        EntityGhastling ghastling = new EntityGhastling(this.func_130014_f_());
                        ghastling.func_70107_b(this.func_180425_c().func_177958_n(), this.func_180425_c().func_177956_o() - 1, this.func_180425_c().func_177952_p());
                        this.func_130014_f_().func_72838_d((Entity)ghastling);
                    }
                    this.setStageStarted(this.getStage(), true);
                    this.setCooldown(ConfigHandler.entity.ghastQueen.ghastlingSpawnCooldown * 20);
                    this.setStage(this.getStage() + 1);
                    this.setShouldSpawnGhastlings(false);
                }
            }
        } else {
            if (this.field_70714_bg.field_75782_a.size() == 3) {
                this.field_70714_bg.func_85156_a(this.fireballAttack);
            }
            this.setCooldown(this.getCooldown() - 1);
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_70645_a(DamageSource cause) {
        if (this.getUrnPos() != BlockPos.field_177992_a) {
            this.func_130014_f_().func_175698_g(this.getUrnPos());
            this.func_130014_f_().func_175656_a(this.getUrnPos(), NetherExBlocks.TILE_URN_SORROW.func_176223_P().func_177226_a(BlockUrnOfSorrow.TYPE, (Comparable)((Object)BlockUrnOfSorrow.EnumType.EMPTY)));
        }
        super.func_70645_a(cause);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74783_a("UrnPos", new int[]{this.getUrnPos().func_177958_n(), this.getUrnPos().func_177956_o(), this.getUrnPos().func_177952_p()});
        compound.func_74768_a("Cooldown", this.getCooldown());
        compound.func_74768_a("Stage", this.getStage());
        for (int i = 0; i < this.stageStarted.length; ++i) {
            compound.func_74757_a("StageStarted" + i, this.getStageStarted(i));
        }
        compound.func_74757_a("SpawnGhast", this.shouldSpawnGhastlings());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setUrnPos(new BlockPos(compound.func_74759_k("UrnPos")[0], compound.func_74759_k("UrnPos")[1], compound.func_74759_k("UrnPos")[2]));
        this.setCooldown(compound.func_74762_e("Cooldown"));
        this.setStage(compound.func_74762_e("Stage"));
        for (int i = 0; i < this.stageStarted.length; ++i) {
            this.setStageStarted(i, compound.func_74767_n("StageStarted" + i));
        }
        this.setShouldSpawnGhastlings(compound.func_74767_n("SpawnGhast"));
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public int func_175453_cd() {
        return 3;
    }

    protected void func_70623_bb() {
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    public void func_96094_a(String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    protected ResourceLocation func_184647_J() {
        return NetherExLootTables.ENTITY_GHAST_QUEEN;
    }

    private BlockPos getUrnPos() {
        return this.urnPos;
    }

    private int getCooldown() {
        return this.cooldown;
    }

    private int getStage() {
        return this.stage;
    }

    private boolean shouldSpawnGhastlings() {
        return this.spawnGhastlings;
    }

    private boolean getStageStarted(int i) {
        return this.stageStarted[i];
    }

    public void setUrnPos(BlockPos pos) {
        this.urnPos = pos;
    }

    private void setCooldown(int i) {
        this.cooldown = i;
    }

    private void setStage(int i) {
        this.stage = i;
    }

    private void setShouldSpawnGhastlings(boolean bool) {
        this.spawnGhastlings = bool;
    }

    private void setStageStarted(int i, boolean bool) {
        this.stageStarted[i] = bool;
    }
}

