/*
 * Decompiled with CFR 0.152.
 */
package nex.handler;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Config.LangKey(value="config.nex:title")
@Config(modid="nex", name="NetherEx/NetherEx", category="nex")
public class ConfigHandler {
    @Config.Name(value="client")
    @Config.LangKey(value="config.nex:client")
    public static Client client = new Client();
    @Config.Name(value="dimension")
    @Config.LangKey(value="config.nex:dimension")
    public static Dimension dimension = new Dimension();
    @Config.Name(value="block")
    @Config.LangKey(value="config.nex:block")
    public static Block block = new Block();
    @Config.Name(value="potion_effect")
    @Config.LangKey(value="config.nex:potionEffect")
    public static PotionEffect potionEffect = new PotionEffect();
    @Config.Name(value="entity")
    @Config.LangKey(value="config.nex:entity")
    public static Entity entity = new Entity();
    @Config.Name(value="biome")
    @Config.LangKey(value="config.nex:biome")
    public static Biome biome = new Biome();
    private static final Logger LOGGER = LogManager.getLogger((String)"NetherEx|ConfigHandler");

    @Mod.EventBusSubscriber(modid="nex")
    public static class ConfigSyncHandler {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("nex")) {
                ConfigManager.sync((String)"nex", (Config.Type)Config.Type.INSTANCE);
                LOGGER.info("Configuration has been saved.");
            }
        }
    }

    public static class Biome {
        @Config.Name(value="hell")
        @Config.LangKey(value="config.nex:biome.hell")
        public Hell hell = new Hell();
        @Config.Name(value="ruthless_sands")
        @Config.LangKey(value="config.nex:biome.ruthlessSands")
        public RuthlessSands ruthlessSands = new RuthlessSands();
        @Config.Name(value="fungi_forest")
        @Config.LangKey(value="config.nex:biome.fungiForest")
        public FungiForest fungiForest = new FungiForest();
        @Config.Name(value="torrid_wasteland")
        @Config.LangKey(value="config.nex:biome.torridWasteland")
        public TorridWasteland torridWasteland = new TorridWasteland();
        @Config.Name(value="arctic_abyss")
        @Config.LangKey(value="config.nex:biome.arcticAbyss")
        public ArcticAbyss arcticAbyss = new ArcticAbyss();

        public class ArcticAbyss {
            @Config.LangKey(value="config.nex:biome.arcticAbyss.chanceOfFreezing")
            @Config.Comment(value={"The higher the number, the rarer it is for mobs to Freeze in the Arctic Abyss biome", "The lower the number, the more common it is for mobs to Freeze in the Arctic Abyss biome"})
            @Config.RangeInt(min=1, max=2048)
            public int chanceOfFreezing = 512;
        }

        public class TorridWasteland {
        }

        public class FungiForest {
            @Config.LangKey(value="config.nex:biome.fungiForest.generateElderMushrooms")
            public boolean generateElderMushrooms = true;
            @Config.LangKey(value="config.nex:biome.fungiForest.generateEnokiMushrooms")
            public boolean generateEnokiMushrooms = true;
            @Config.LangKey(value="config.nex:biome.fungiForest.elderMushroomRarity")
            @Config.Comment(value={"The lower the number, the rarer Elder Mushrooms are", "The higher the number, the more common Elder Mushrooms are"})
            @Config.RangeInt(min=1, max=256)
            public int elderMushroomRarity = 32;
            @Config.LangKey(value="config.nex:biome.fungiForest.enokiMushroomRarity")
            @Config.Comment(value={"The lower the number, the rarer Enoki Mushrooms are", "The higher the number, the more common Enoki Mushrooms are"})
            @Config.RangeInt(min=1, max=256)
            public int enokiMushroomRarity = 4;
        }

        public class RuthlessSands {
            @Config.LangKey(value="config.nex:biome.ruthlessSands.generateThornstalk")
            public boolean generateThornstalk = true;
            @Config.LangKey(value="config.nex:biome.ruthlessSands.thornstalkRarity")
            @Config.Comment(value={"The lower the number, the rarer Thornstalk is", "The higher the number, the more common Thornstalk is"})
            @Config.RangeInt(min=1, max=256)
            public int thornstalkRarity = 10;
        }

        public class Hell {
        }
    }

    public static class Entity {
        @Config.Name(value="ember")
        @Config.LangKey(value="config.nex:entity.ember")
        public Ember ember = new Ember();
        @Config.Name(value="nethermite")
        @Config.LangKey(value="config.nex:entity.nethermite")
        public Nethermite nethermite = new Nethermite();
        @Config.Name(value="spinout")
        @Config.LangKey(value="config.nex:entity.spinout")
        public Spinout spinout = new Spinout();
        @Config.Name(value="spore_creeper")
        @Config.LangKey(value="config.nex:entity.sporeCreeper")
        public SporeCreeper sporeCreeper = new SporeCreeper();
        @Config.Name(value="spore")
        @Config.LangKey(value="config.nex:entity.spore")
        public Spore spore = new Spore();
        @Config.Name(value="brute")
        @Config.LangKey(value="config.nex:entity.brute")
        public Brute brute = new Brute();
        @Config.Name(value="ghast_queen")
        @Config.LangKey(value="config.nex:entity.ghastQueen")
        public GhastQueen ghastQueen = new GhastQueen();

        public class GhastQueen {
            @Config.LangKey(value="config.nex:entity.ghastQueen.ghastlingSpawnCooldown")
            @Config.Comment(value={"The lower the number, the less cooldown the Ghast Queen has after spawning Ghastlings", "The higher the number, the more cooldown the Ghast Queen has after spawning Ghastlings"})
            @Config.RangeInt(min=1, max=512)
            public int ghastlingSpawnCooldown = 10;
            @Config.LangKey(value="config.nex:entity.ghastQueen.ghastlingSpawns")
            @Config.Comment(value={"The lower the number, the less Ghastling spawn", "The higher the number, the more Ghastling spawn"})
            @Config.RangeInt(min=1, max=256)
            public int ghastlingSpawns = 4;
        }

        public class Brute {
            @Config.LangKey(value="config.nex:entity.brute.chargeCooldown")
            @Config.Comment(value={"The lower the number, the less cooldown the Brute has after charging", "The higher the number, the more cooldown the Brute has after charging"})
            @Config.RangeInt(min=1, max=512)
            public int chargeCooldown = 2;
        }

        public class Spore {
            @Config.LangKey(value="config.nex:entity.spore.growthTime")
            @Config.Comment(value={"The lower the number, the less it takes a Spore to grow", "The higher the number, the more time it takes for a Spore to grow"})
            @Config.RangeInt(min=1, max=512)
            public int growthTime = 60;
            @Config.LangKey(value="config.nex:entity.spore.creeperSpawns")
            @Config.Comment(value={"The lower the number, the less Spore Creeper spawn from a Spore", "The higher the number, the more Spore Creeper spawn from a Spore"})
            @Config.RangeInt(min=1, max=256)
            public int creeperSpawns = 3;
        }

        public class SporeCreeper {
            @Config.LangKey(value="config.nex:entity.sporeCreeper.chanceOfSporeSpawning")
            @Config.Comment(value={"The higher the number, the rarer it is for s Spore Creeper to spawn a Spore on death", "The lower the number, the more common it is for a Spore Creeper to spawn a Spore on death"})
            @Config.RangeInt(min=1, max=256)
            public int chanceOfSporeSpawning = 12;
        }

        public class Spinout {
            @Config.LangKey(value="config.nex:entity.spinout.spinTime")
            @Config.Comment(value={"The lower the number, the less time a Spinout spins", "The higher the number, the more time a Spinout spins"})
            @Config.RangeInt(min=1, max=512)
            public int spinTime = 6;
            @Config.LangKey(value="config.nex:entity.spinout.spinCooldown")
            @Config.Comment(value={"The lower the number, the less time a Spinout goes without spinning", "The higher the number, the more time a Spinout goes without spinning"})
            @Config.RangeInt(min=1, max=512)
            public int spinCooldown = 2;
        }

        public class Nethermite {
            @Config.LangKey(value="config.nex:entity.nethermite.chanceOfSpawning")
            @Config.Comment(value={"The higher the number, the rarer it is for a Nethermite to spawn", "The lower the number, the more common it is for a Nethermite to spawn"})
            @Config.RangeInt(min=1, max=256)
            public int chanceOfSpawning = 64;
            @Config.LangKey(value="config.nex:entity.nethermite.whitelist")
            @Config.Comment(value={"Blocks the Nethermite should spawn from"})
            public String[] whitelist = new String[]{"minecraft:quartz_ore", "nex:ore_quartz", "nex:ore_amethyst", "nex:ore_rime", "tconstruct:ore", "nethermetals:nether_coal_ore", "nethermetals:nether_redstone_ore", "nethermetals:nether_diamond_ore", "nethermetals:nether_emerald_ore", "nethermetals:nether_gold_ore", "nethermetals:nether_iron_ore", "nethermetals:nether_lapis_ore", "nethermetals:nether_antimony_ore", "nethermetals:nether_bismuth_ore", "nethermetals:nether_copper_ore", "nethermetals:nether_lead_ore", "nethermetals:nether_mercury_ore", "nethermetals:nether_nickel_ore", "nethermetals:nether_platnium_ore", "nethermetals:nether_silver_ore", "nethermetals:nether_tin_ore", "nethermetals:nether_zinc_ore", "nethermetals:nether_aluminum_ore", "nethermetals:nether_cadmium_ore", "nethermetals:nether_chromium_ore", "nethermetals:nether_iridium_ore", "nethermetals:nether_magnesium_ore", "nethermetals:nether_magnanese_ore", "nethermetals:nether_osmium_ore", "nethermetals:nether_plutonium_ore", "nethermetals:nether_rutile_ore", "nethermetals:nether_tantalum_ore", "nethermetals:nether_titanium_ore", "nethermetals:nether_tungsten_ore", "nethermetals:nether_uramium_ore", "nethermetals:nether_zirconium_ore"};
        }

        public class Ember {
            @Config.LangKey(value="config.nex:entity.ember.chanceOfSettingPlayerOnFire")
            @Config.Comment(value={"The higher the number, the rarer it is to set a player on fire", "The lower the number, the more common it is to set a player on fire"})
            @Config.RangeInt(min=1, max=256)
            public int chanceOfSettingPlayerOnFire = 1;
        }
    }

    public static class PotionEffect {
        @Config.Name(value="freeze")
        @Config.LangKey(value="config.nex:potionEffect.freeze")
        public Freeze freeze = new Freeze();
        @Config.Name(value="spore")
        @Config.LangKey(value="config.nex:potionEffect.spore")
        public Spore spore = new Spore();
        @Config.Name(value="lost")
        @Config.LangKey(value="config.nex:potionEffect.lost")
        public Lost lost = new Lost();

        public class Lost {
            @Config.LangKey(value="config.nex:potionEffect.lost.chanceOfGhastlingSpawning")
            @Config.Comment(value={"The higher the number, the rarer it is to spawn a Ghastling", "The lower the number, the more common it is to spawn a Ghastling"})
            @Config.RangeInt(min=1, max=256)
            public int chanceOfGhastlingSpawning = 256;
        }

        public class Spore {
            @Config.LangKey(value="config.nex:potionEffect.spore.chanceOfSporeSpawning")
            @Config.Comment(value={"The higher the number, the rarer it is to spawn a Spore", "The lower the number, the more common it is to spawn a Spore"})
            @Config.RangeInt(min=1, max=256)
            public int chanceOfSporeSpawning = 128;
            @Config.LangKey(value="config.nex:potionEffect.spore.blacklist")
            @Config.Comment(value={"Mobs that shouldn't spawn Spores"})
            public String[] blacklist = new String[]{"nex:monster_spore_creeper", "nex:monster_spore", "nex:neutral_mogus"};
        }

        public class Freeze {
            @Config.LangKey(value="config.nex:potionEffect.freeze.chanceOfThawing")
            @Config.Comment(value={"The higher the number, the rarer it is to thaw", "The lower the number, the more common it is to thaw"})
            @Config.RangeInt(min=1, max=2048)
            public int chanceOfThawing = 1024;
            @Config.LangKey(value="config.nex:potionEffect.freeze.blacklist")
            @Config.Comment(value={"Mobs that shouldn't freeze"})
            public String[] blacklist = new String[]{"minecraft:blaze", "minecraft:ghast", "minecraft:wither_skeleton", "minecraft:polar_bear", "nex:monster_wight", "nex:monster_ember", "nex:monster_spinout", "nex:monster_bone_spider", "nex:monster_brute"};
        }
    }

    public static class Block {
        @Config.Name(value="nether_portal")
        @Config.LangKey(value="config.nex:block.netherPortal")
        public NetherPortal netherPortal = new NetherPortal();
        @Config.Name(value="netherrack")
        @Config.LangKey(value="config.nex:block.netherrack")
        public Netherrack netherrack = new Netherrack();
        @Config.Name(value="soul_sand")
        @Config.LangKey(value="config.nex:block.soulSand")
        public SoulSand soulSand = new SoulSand();
        @Config.Name(value="magma")
        @Config.LangKey(value="config.nex:block.magma")
        public Magma magma = new Magma();
        @Config.Name(value="rime")
        @Config.LangKey(value="config.nex:block.rime")
        public Rime rime = new Rime();
        @Config.Name(value="thornstalk")
        @Config.LangKey(value="config.nex:block.thornstalk")
        public Thornstalk thornstalk = new Thornstalk();
        @Config.Name(value="hyphae")
        @Config.LangKey(value="config.nex:block.hyphae")
        public Hyphae hyphae = new Hyphae();

        public class Hyphae {
            @Config.LangKey(value="config.nex:block.hyphae.doesSpread")
            public boolean doesSpread = false;
        }

        public class Thornstalk {
            @Config.LangKey(value="config.nex:block.thornstalk.canDestroyItems")
            public boolean canDestroyItems = false;
            @Config.LangKey(value="config.nex:block.thornstalk.blacklist")
            @Config.Comment(value={"Mobs the Thornstalk shouldn't hurt"})
            public String[] blacklist = new String[]{"minecraft:wither_skeleton", "minecraft:zombie_pigman", "nex:monster_spinout"};
        }

        public class Rime {
            @Config.LangKey(value="config.nex:block.rime.canFreezeWater")
            public boolean canFreezeWater = true;
            @Config.LangKey(value="config.nex:block.rime.canFreezeLava")
            public boolean canFreezeLava = true;
            @Config.LangKey(value="config.nex:block.rime.canFreezeMobs")
            public boolean canFreezeMobs = true;
        }

        public class Magma {
            @Config.LangKey(value="config.nex:block.magma.turnIntoLava")
            public boolean turnIntoLava = false;
        }

        public class SoulSand {
            @Config.LangKey(value="config.nex:block.soulSand.doesNetherwartUseNewGrowthSystem")
            public boolean doesNetherwartUseNewGrowthSystem = true;
            @Config.LangKey(value="config.nex:block.soulSand.allowAllHoesToTill")
            public boolean allowAllHoesToTill = false;
            @Config.LangKey(value="config.nex:block.soulSand.doesRequireIchor")
            public boolean doesRequireIchor = true;
        }

        public class Netherrack {
            @Config.LangKey(value="config.nex:block.netherrack.allowAllShovelsToFlatten")
            public boolean allowAllShovelsToFlatten = false;
        }

        public class NetherPortal {
            @Config.LangKey(value="config.nex:block.netherrack.allowPigmanSpawning")
            public boolean allowPigmanSpawning = true;
            @Config.RangeInt(min=4, max=2048)
            @Config.LangKey(value="config.nex:block.netherrack.pigmanSpawnRarity")
            @Config.Comment(value={"The higher the number, the rarer it is for Pigman to spawn", "The lower the number, the more common it is for Pigman to spawn"})
            public int pigmanSpawnRarity = 2000;
        }
    }

    public static class Dimension {
        @Config.Name(value="nether")
        @Config.LangKey(value="config.nex:dimension.nether")
        public Nether nether = new Nether();

        public class Nether {
            @Config.LangKey(value="config.nex:dimension.nether.generateSoulSand")
            public boolean generateSoulSand = false;
            @Config.LangKey(value="config.nex:dimension.nether.generateGravel")
            public boolean generateGravel = false;
            @Config.LangKey(value="config.nex:dimension.nether.isLavaInfinite")
            public boolean isLavaInfinite = false;
        }
    }

    public static class Client {
        @Config.Name(value="visual")
        @Config.LangKey(value="config.nex:client.visual")
        public Visual visual = new Visual();

        public class Visual {
            @Config.LangKey(value="config.nex:client.visual.disableNetherFog")
            public boolean disableNetherFog = true;
        }
    }
}

